package com.xebialabs.xlrelease.reports.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.xebialabs.xlrelease.reports.filters.CompositeFilter.Operator.OR;

@Metadata(description = "Composite filter to combine multiple child filters into a single AND or OR condition.")
public abstract class CompositeFilter extends ReportFilter {
     @Property(description = "Operator to apply when merging the child filters.")
     private CompositeFilter.Operator operator = OR;

     @Property(asContainment = true, description = "Child filters.")
     private List<ReportFilter> filters = new ArrayList<>();

     public CompositeFilter() {
     }

     public CompositeFilter(final CompositeFilter.Operator operator, final ReportFilter... filters) {
          this.operator = operator;
          this.filters = Arrays.asList(filters);
     }

     public List<ReportFilter> getFilters() {
          return filters;
     }

     public void setFilters(final List<ReportFilter> filters) {
          this.filters = filters;
     }

     public CompositeFilter.Operator getOperator() {
          return operator;
     }

     public void setOperator(final CompositeFilter.Operator operator) {
          this.operator = operator;
     }

     @Override
     public boolean equals(final Object o) {
          if (this == o) return true;
          if (o == null || getClass() != o.getClass()) return false;
          if (!super.equals(o)) return false;
          final CompositeFilter that = (CompositeFilter) o;
          return operator == that.operator &&
              Objects.equals(filters, that.filters);
     }

     @Override
     public int hashCode() {
          return Objects.hash(super.hashCode(), operator, filters);
     }

     @Override
     public String toString() {
          return filters.stream().map(Object::toString).collect(Collectors.joining(" " + operator.getValue() + " "));
     }

     public enum Operator {
          AND("AND"),
          OR("OR");

          private String value;

          Operator(String value) {
               this.value = value;
          }

          public String getValue() {
               return value;
          }
     }
}
