package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlrelease.runner.domain.{JobId, RunnerId}

import java.util.function.Predicate

trait JobQueue {
  def submit(job: Job): Unit

  def submitExisting(job: Job): Unit

  def submitBroadcasted(job: Job): Unit

  def replace(job: Job): Unit

  def finish(jobId: JobId): Unit

  def get(jobRunnerId: RunnerId): Option[Job]

  def confirm(runnerId: RunnerId, jobId: JobId): Boolean

  def cancelIf(predicate: Predicate[Job]): Unit

  def start(): Unit

  def stop(): Unit

  def isRunning(): Boolean

  def size(): Int
}
