package com.xebialabs.xlrelease.script;

import java.util.function.Function;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.service.CommentService;

public class TruncatingCommentUpdater implements CommentUpdater {
    private CommentService commentService;
    private final Task task;
    private final int maxCommentSize;
    private String commentId;
    private long currentCommentSize = 0L;

    public TruncatingCommentUpdater(CommentService commentService, Task task, int maxCommentSize) {
        this.commentService = commentService;
        this.task = task;
        this.maxCommentSize = maxCommentSize;
    }

    public Object apply(String commentUpdateText) {
        if (updateCommentAllowed()) {
            String commentText = commentUpdateText;
            if (maxCommentSize > 0 && commentUpdateText.length() > maxCommentSize) {
                commentText = commentUpdateText.substring(0, maxCommentSize + 1);
            }
            commentId = commentService.appendComment(task, this.commentId, commentText);
            currentCommentSize += commentText.length();
        }
        return commentId;
    }

    private boolean updateCommentAllowed() {
        return maxCommentSize < 0 || (maxCommentSize > 0 && currentCommentSize <= maxCommentSize);
    }
}

interface CommentUpdater extends Function<String, Object> {
}