package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration
import com.xebialabs.xlrelease.script.{XlrScript, XlrScriptContext}

import javax.script.ScriptContext.ENGINE_SCOPE

class ValueProviderScriptContextBuilder(valueProvider: ScriptValueProviderConfiguration, providerRelease: Release) extends ScriptContextBuilder {
  withRelease(providerRelease).withScriptApi().withLogger()
  valueProvider.`extension` match {
    case ".groovy" => withOpenApi()
    case ".py" => withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  }

  override def doBuild(context: XlrScriptContext): Unit = {
    context.addProperties(valueProvider, valueProvider.getType.getDescriptor.getPropertyDescriptors)
    context.setAttribute(XlrScriptContext.ATTR_VALUE_PROVIDER, valueProvider, ENGINE_SCOPE)

    val script = XlrScript.byResource(
      name = s"<value_provider>${valueProvider.getType}[${valueProvider.getId}]",
      resource = valueProvider.getScript(),
      wrap = true,
      checkPermissions = false)
    context.addScript(script)
  }

}