package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.io.SourceArtifactFile
import com.xebialabs.deployit.repository.RepositoryAdapter
import com.xebialabs.xlrelease.db.ArchivedReleases
import com.xebialabs.xlrelease.db.ArchivedReleases.shortenId
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper.newEncryptingConverter
import com.xebialabs.xltype.serialization.ConfigurationItemConverter
import grizzled.slf4j.Logging

trait ArchivedReleaseReader extends ArchivedReleaseDeserialization with Logging {
  def repositoryAdapter: RepositoryAdapter

  def archivedReleases: ArchivedReleases

  protected def getReleaseOption(releaseId: String,
                                 includePreArchived: Boolean = false,
                                 ciConverter: ConfigurationItemConverter = newEncryptingConverter()): Option[Release] = {
    archivedReleases.getRelease(releaseId, includePreArchived).map { releaseJson =>
      val release: Release = deserializeArchivedRelease(releaseJson, repositoryAdapter, ciConverter)

      val attachmentsFileNames: Map[String, String] = archivedReleases.getAttachmentsFileNames(release.getId)

      release.getAttachments.forEach { attachment =>
        attachmentsFileNames.get(shortenId(attachment.getId)) match {
          case Some(filename) =>
            attachment.setFile(SourceArtifactFile.withNullableWorkDir(filename, attachment, null))
          case None =>
            logger.error(s"Could not find attachment ${attachment.getId} of release $releaseId in the attachments table")
        }
      }

      release
    }
  }

}
