package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.api.v1.filter.WorkflowFilters
import com.xebialabs.xlrelease.api.v1.views.WorkflowOverview
import com.xebialabs.xlrelease.repository.WorkflowRepository
import grizzled.slf4j.Logging
import org.springframework.data.domain.{Page, Pageable}

class WorkflowService(workflowRepository: WorkflowRepository) extends Logging {
  def findBy(workflowFilters: WorkflowFilters, pageable: Pageable): Page[WorkflowOverview] = {
    logger.debug(s"Searching workflows with workflow filters [$workflowFilters]")
    workflowRepository.findBy(workflowFilters, pageable)
  }
}
