package com.xebialabs.xlrelease.support

import scala.math.BigDecimal.RoundingMode

package object report {
  val SYSTEM_INFORMATION_REPORT_TEMPLATE = "system-information-report-template.mustache"
  val SYSTEM_INFORMATION_REPORT_FILE_NAME = "release-system-information.html"
  val THREAD_DUMP_FILE_NAME = "release-thread-dump.log"
  val TASK_MANAGER_INFORMATION_FILE_NAME = "task-manager-report.json"

  def avg(count: Int, per: Int): Float = if (per > 0) (BigDecimal(count) / BigDecimal(per)).setScale(2, RoundingMode.HALF_UP).floatValue else 0F
}
