package com.xebialabs.xlrelease.upgrade.common;

import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;

/**
 * An {@link Upgrade} which is also a {@link RepositoryInitialization}. So it will be run
 * both on an empty repository as well as when upgrading to a specific version of a product or plugin.
 */
public abstract class BaseInitializingUpgrade extends Upgrade implements RepositoryInitialization {

    @Override
    public final void doInitialize() {
        doUpgrade();
    }

    @Override
    public final String getComponent() {
        return upgradeVersion().getComponent();
    }
}
