package com.xebialabs.xlrelease.utils

import com.xebialabs.deployit.engine.spi.event.{RoleCreatedEvent, RoleDeletedEvent, RolePrincipalsChangedEvent, RoleRenamedEvent}
import com.xebialabs.deployit.event.EventBusHolder
import com.xebialabs.deployit.security.Role

import java.util.Optional
import scala.jdk.CollectionConverters._
import scala.jdk.OptionConverters._

object RolePrincipalEventPublisher {

  def publishCreateOrUpdate(original: Optional[Role], updated: Role): Unit = {
    def publishRolePrincipalsChangedEvent: Unit =
      EventBusHolder.publish(new RolePrincipalsChangedEvent(List(s"${updated.getName} => ${updated.getPrincipals}").asJava))

    original.asScala match {
      case Some(role) =>
        if (role.getName != updated.getName) EventBusHolder.publish(new RoleRenamedEvent(role.getName, updated.getName))
        if (!role.getPrincipals.asScala.sorted.corresponds(updated.getPrincipals.asScala.sorted)(_ == _)) publishRolePrincipalsChangedEvent
      case _ =>
        EventBusHolder.publish(new RoleCreatedEvent(updated.getName))
        publishRolePrincipalsChangedEvent
    }
  }

  def publishDelete(role: Optional[Role]): Unit = {
    if (role.isPresent) EventBusHolder.publish(new RoleDeletedEvent(role.get.getName))
  }
}
