package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.xlrelease.domain.ExternalVariableServer
import com.xebialabs.xlrelease.domain.variables._
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, Ids}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._
import scala.util.Try

@Component
class ExternalVariableServerValueProvider(configurationRepository: ConfigurationRepository) extends ReferenceCiVariableProvider[ExternalVariableServer] {

  override def getSupportedTypes(): Seq[ReferencedType] = {
    DescriptorRegistry.getSubtypes(Type.valueOf(classOf[ExternalVariableServer])).asScala
      .filterNot(_.getDescriptor.isVirtual)
      .map(t => new ReferencedType(t.toString, t.getDescriptor.getLabel))
      .toSeq
  }

  override def getRawValue(variable: ReferenceVariable): Option[ExternalVariableServer] = {
    Try(configurationRepository.read[ExternalVariableServer](variable.getValue)).toOption
  }

  override def possibleValues(valueProviderConfiguration: CiProvider): Seq[PossibleValue] = {
    val variable = valueProviderConfiguration.getVariable.asInstanceOf[ReferenceVariable]
    val folderId = Ids.findFolderId(variable.getId)
    configurationRepository
      .findAllByTypeAndTitle[ExternalVariableServer](Type.valueOf(variable.getReferencedType), null, folderId, folderOnly = false)
      .asScala
      .map(httpConnection => new PossibleValue(httpConnection.getId, httpConnection.getTitle))
      .toSeq
  }


}
