package com.xebialabs.xlrelease.views;

import java.util.Date;

public class LogsFilters {

    public static final LogsFilters ALL = all();

    private String filter;
    private Date from;
    private Date to;
    private boolean important;
    private boolean releaseEdit;
    private boolean taskEdit;
    private boolean triggerEdit;
    private boolean deliveryEdit;
    private boolean comments;
    private boolean lifecycle;
    private boolean reassign;
    private boolean reportingRecordEdit;
    private boolean security;
    private boolean dateAsc;
    private boolean execution;
    private boolean other;
    private String targetId;

    public LogsFilters() {
    }

    public static LogsFilters all() {
        LogsFilters filter = new LogsFilters();
        filter.setReleaseEdit(true);
        filter.setTaskEdit(true);
        filter.setTriggerEdit(true);
        filter.setDeliveryEdit(true);
        filter.setComments(true);
        filter.setLifecycle(true);
        filter.setReassign(true);
        filter.setReportingRecordEdit(true);
        filter.setSecurity(true);
        filter.setExecution(true);
        filter.setOther(true);
        return filter;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public boolean withImportant() {
        return important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public boolean withReleaseEdit() {
        return releaseEdit;
    }

    public void setReleaseEdit(boolean releaseEdit) {
        this.releaseEdit = releaseEdit;
    }

    public boolean withTaskEdit() {
        return taskEdit;
    }

    public void setTaskEdit(boolean taskEdit) {
        this.taskEdit = taskEdit;
    }

    public boolean withTriggerEdit() {
        return triggerEdit;
    }

    public void setTriggerEdit(boolean triggerEdit) {
        this.triggerEdit = triggerEdit;
    }

    public boolean withDeliveryEdit() {
        return deliveryEdit;
    }

    public void setDeliveryEdit(boolean deliveryEdit) {
        this.deliveryEdit = deliveryEdit;
    }

    public boolean withComments() {
        return comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public boolean withLifecycle() {
        return lifecycle;
    }

    public void setLifecycle(boolean lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean withReassign() {
        return reassign;
    }

    public void setReassign(boolean reassign) {
        this.reassign = reassign;
    }

    public boolean withReportingRecordEdit() {
        return reportingRecordEdit;
    }

    public void setReportingRecordEdit(boolean reportingRecordEdit) {
        this.reportingRecordEdit = reportingRecordEdit;
    }

    public boolean withSecurity() {
        return security;
    }

    public void setSecurity(boolean security) {
        this.security = security;
    }

    public boolean isDateAsc() {
        return dateAsc;
    }

    public void setDateAsc(final boolean dateAsc) {
        this.dateAsc = dateAsc;
    }

    public boolean withExecution() {
        return execution;
    }

    public void setExecution(boolean execution) {
        this.execution = execution;
    }

    public void setOther(boolean other) {
        this.other = other;
    }

    public boolean withOther() {
        return other;
    }

    public void setTargetId(final String targetId) {
        this.targetId = targetId;
    }

    public String getTargetId() {
        return targetId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final LogsFilters that = (LogsFilters) o;

        if (important != that.important) return false;
        if (releaseEdit != that.releaseEdit) return false;
        if (taskEdit != that.taskEdit) return false;
        if (triggerEdit != that.triggerEdit) return false;
        if (deliveryEdit != that.deliveryEdit) return false;
        if (comments != that.comments) return false;
        if (lifecycle != that.lifecycle) return false;
        if (reassign != that.reassign) return false;
        if (reportingRecordEdit != that.reportingRecordEdit) return false;
        if (security != that.security) return false;
        if (dateAsc != that.dateAsc) return false;
        if (execution != that.execution) return false;
        if (other != that.other) return false;
        if (filter != null ? !filter.equals(that.filter) : that.filter != null) return false;
        if (from != null ? !from.equals(that.from) : that.from != null) return false;
        if (to != null ? !to.equals(that.to) : that.to != null) return false;
        return targetId != null ? targetId.equals(that.targetId) : that.targetId == null;
    }

    @Override
    public int hashCode() {
        int result = filter != null ? filter.hashCode() : 0;
        result = 31 * result + (from != null ? from.hashCode() : 0);
        result = 31 * result + (to != null ? to.hashCode() : 0);
        result = 31 * result + (important ? 1 : 0);
        result = 31 * result + (releaseEdit ? 1 : 0);
        result = 31 * result + (taskEdit ? 1 : 0);
        result = 31 * result + (triggerEdit ? 1 : 0);
        result = 31 * result + (deliveryEdit ? 1 : 0);
        result = 31 * result + (comments ? 1 : 0);
        result = 31 * result + (lifecycle ? 1 : 0);
        result = 31 * result + (reassign ? 1 : 0);
        result = 31 * result + (reportingRecordEdit ? 1 : 0);
        result = 31 * result + (security ? 1 : 0);
        result = 31 * result + (dateAsc ? 1 : 0);
        result = 31 * result + (execution ? 1 : 0);
        result = 31 * result + (other ? 1 : 0);
        result = 31 * result + (targetId != null ? targetId.hashCode() : 0);
        return result;
    }
}
