package com.xebialabs.xlrelease.views.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.views.ReleaseExtensionView;

import static java.text.MessageFormat.format;
import static java.util.Objects.isNull;

@Component
public class ReleaseExtensionsViewConverter {

    private Map<Class<? extends ReleaseExtension>, ReleaseExtensionViewConverter> releaseExtensionViewConvertersPerType = new HashMap<>();

    public ReleaseExtensionView toView(ReleaseExtension releaseExtension) {
        return getConverterForClass(releaseExtension.getClass())
            .toView(releaseExtension);
    }

    @Autowired(required = false)
    public void setReleaseExtensionViewConverters(final List<? extends ReleaseExtensionViewConverter<? extends ReleaseExtension, ? extends ReleaseExtensionView>> releaseExtensionViewConverters) {
        Optional.ofNullable(releaseExtensionViewConverters).ifPresent(converters -> converters.forEach(converter -> {
            Class<? extends ReleaseExtension> releaseExtensionClass = converter.getReleaseExtensionClass();
            if (releaseExtensionViewConvertersPerType.containsKey(releaseExtensionClass)) {
                throw new IllegalStateException(format("Two view converters were registered for release extension {0}", releaseExtensionClass));
            }
            releaseExtensionViewConvertersPerType.put(releaseExtensionClass, converter);
        }));
    }

    private ReleaseExtensionViewConverter getConverterForClass(final Class<? extends ReleaseExtension> releaseExtensionClass) {
        ReleaseExtensionViewConverter converter = releaseExtensionViewConvertersPerType.get(releaseExtensionClass);
        if (isNull(converter)) {
            throw new IllegalStateException(format("ReleaseExtensionViewConverter is not defined for release extension {0}", releaseExtensionClass));
        }
        return converter;
    }
}
