package com.xebialabs.xlrelease.events.handlers

import com.xebialabs.deployit.repository.ItemInUseException
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.repository.ReleaseRepository
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

@Service
@EventListener
class FolderActionEventHandler(releaseRepository: ReleaseRepository) extends Logging {

  @Subscribe
  def onFolderDeleting(action: FolderDeletingAction): Unit = {
    val folderId = action.folderId
    if (null != folderId) {
      val referencedTemplates = releaseRepository.getTemplateTitlesUsingDefaultTargetFolder(folderId)
      val msg = s"You cannot delete this folder. The folder or its subfolders are used as default target folders on the following workflow templates"
      checkTemplates(referencedTemplates, msg)
    }
  }

  private def checkTemplates(referencedTemplates: List[String], msg: String): Unit = {
    if (referencedTemplates.nonEmpty) {
      val titles = referencedTemplates.mkString("\"", "\", \"", "\"")
      throw new ItemInUseException(
        s"$msg: $titles"
      )
    }
  }
}
