package com.xebialabs.xlrelease.scheduler.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.RemoteExecution
import com.xebialabs.xlrelease.domain.runner.{JobRunner, JobRunnerOps}

import java.util
import scala.jdk.CollectionConverters._

sealed trait LocalJobRunner extends JobRunner

@Metadata(label = "Local job runner", description = "This job runner is always present and should not be configurable", virtual = true)
object LocalJobRunner extends LocalJobRunner {
  val DEFAULT_LOCAL_JOB_RUNNER_CAPABILITY: String = "local"

  override def getId(): String = "local"

  override def getCapabilities: util.Set[String] = Set[String](DEFAULT_LOCAL_JOB_RUNNER_CAPABILITY).asJava

  override def isEnabled: Boolean = true

  override def start(): Unit = {
    JobRunnerOps.start(this)
  }

  override def stop(): Unit = {
    JobRunnerOps.stop(this)
  }

  override def delete(): Unit = {
    JobRunnerOps.delete(this)
  }

  override def abortJob(jobId: Long, executionId: String): Unit = {
    JobRunnerOps.abortJob(this, jobId, executionId)
  }

  override def capacity: Integer = XlrConfig.getInstance.executors.scheduler.maxThreadsCount

  override def evictionTime: Integer = 0

  override def isEncryptJobData(): Boolean = false

  override def execute(remoteExecution: RemoteExecution): String = {
    JobRunnerOps.execute(this, remoteExecution)
  }
  override def idleTimeToLive: Integer = 60

  override def isAvailable: Boolean = true
}
