package com.xebialabs.xlrelease.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtils {

    private static final Logger logger = LoggerFactory.getLogger(ExecutorService.class);

    public static void shutdown(String description, ExecutorService executorService) {
        try {
            logger.info("Shutting down {}", description);
            executorService.shutdown();
            boolean terminated = awaitTerminationIfNecessary(description, executorService);
            if (!terminated) {
                for (Runnable remainingTask : executorService.shutdownNow()) {
                    cancelRemainingTask(remainingTask);
                }
                if (!awaitTerminationIfNecessary(description, executorService)) {
                    logger.error("Unable to terminate '{}' via shutdownNow", description);
                }
            }
        } catch (SecurityException ex) {
            logger.error("Unable to shutdown '{}' executor service", description, ex);
        }
    }

    private static void cancelRemainingTask(Runnable task) {
        if (task instanceof Future) {
            ((Future<?>) task).cancel(true);
        }
    }

    private static boolean awaitTerminationIfNecessary(String description, ExecutorService executorService) {
        boolean terminated = false;
        try {
            terminated = executorService.awaitTermination(10, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for executor {} to terminate", description);
            Thread.currentThread().interrupt();
        }
        return terminated;
    }
}
