package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.ItemConflictException
import com.xebialabs.xlrelease.api.v1.forms.ExternalVariableValue
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class ExternalVariableService @Autowired()(sharedConfigurationService: SharedConfigurationService) {

  def checkExistsAndCorrectType(externalVariableValue: ExternalVariableValue): Unit = {
    if (externalVariableValue == null) {
      return
    }

    val configuration = sharedConfigurationService.findById(externalVariableValue.getServer)
    if (configuration.getType != Type.valueOf(externalVariableValue.getServerType)) {
      throw new ItemConflictException("The configuration is not the expected type [%s]", externalVariableValue.getServerType)
    }
  }
}
