package com.xebialabs.xlrelease.service
import com.xebialabs.deployit.repository.{WorkDirContext, WorkDirFactory}
trait WorkdirSupport {
  def withWorkDir[T](block: => T): T = {
    WorkDirContext.initWorkdir(WorkDirFactory.DOWNLOAD_WORKDIR_PREFIX)
    try {
      block
    } finally {
      // WORKDIR has to be cleaned up here
      WorkDirContext.get.delete()
      WorkDirContext.clear()
    }
  }
}
