package com.xebialabs.xlrelease.builder;

import java.util.Date;

import com.xebialabs.xlrelease.views.LogsFilters;

public class LogsFiltersBuilder {
    private String filter;
    private Date from;
    private Date to;
    private boolean important = true;
    private boolean releaseEdit = true;
    private boolean taskEdit = true;
    private boolean triggerEdit = true;
    private boolean deliveryEdit = true;
    private boolean lifecycle = true;
    private boolean reassign = true;
    private boolean security = true;
    private boolean dateAsc = true;
    private boolean other = true;
    private String targetId;

    private LogsFiltersBuilder() {}

    public static LogsFiltersBuilder newLogsFilters() {
        return new LogsFiltersBuilder();
    }

    public LogsFiltersBuilder withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public LogsFiltersBuilder from(Date from) {
        this.from = from;
        return this;
    }

    public LogsFiltersBuilder to(Date to) {
        this.to = to;
        return this;
    }

    public LogsFiltersBuilder withImportant(boolean important) {
        this.important = important;
        return this;
    }

    public LogsFiltersBuilder withReleaseEdit(boolean releaseEdit) {
        this.releaseEdit = releaseEdit;
        return this;
    }

    public LogsFiltersBuilder withTaskEdit(boolean taskEdit) {
        this.taskEdit = taskEdit;
        return this;
    }

    public LogsFiltersBuilder withTriggerEdit(boolean triggerEdit) {
        this.triggerEdit = triggerEdit;
        return this;
    }

    public LogsFiltersBuilder withDeliveryEdit(boolean deliveryEdit) {
        this.deliveryEdit = deliveryEdit;
        return this;
    }

    public LogsFiltersBuilder withLifecycle(boolean lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    public LogsFiltersBuilder withReassign(boolean reassign) {
        this.reassign = reassign;
        return this;
    }

    public LogsFiltersBuilder withSecurity(boolean security) {
        this.security = security;
        return this;
    }

    public LogsFiltersBuilder withDateAsc(boolean dateAsc) {
        this.dateAsc = dateAsc;
        return this;
    }

    public LogsFiltersBuilder withOther(boolean other) {
        this.other = other;
        return this;
    }

    public LogsFiltersBuilder withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public LogsFilters build() {
        LogsFilters filters = new LogsFilters();
        filters.setFilter(filter);
        filters.setFrom(from);
        filters.setTo(to);
        filters.setImportant(important);
        filters.setReleaseEdit(releaseEdit);
        filters.setTaskEdit(taskEdit);
        filters.setTriggerEdit(triggerEdit);
        filters.setDeliveryEdit(deliveryEdit);
        filters.setLifecycle(lifecycle);
        filters.setReassign(reassign);
        filters.setSecurity(security);
        filters.setDateAsc(dateAsc);
        filters.setOther(other);
        filters.setTargetId(targetId);
        return filters;
    }
}
