package com.xebialabs.xlrelease.domain.variables

import com.xebialabs.xlrelease.script.ScriptService
import org.springframework.stereotype.Component

import java.util
import scala.jdk.CollectionConverters._
import scala.reflect.ClassTag

abstract class ScriptValueProvider[T <: ScriptValueProviderConfiguration : ClassTag](scriptServices: util.List[_ <: ScriptService])
  extends ValueProvider[AnyRef, T] {

  override def getValueProviderConfigurationClass: Class[T] = implicitly[ClassTag[T]].runtimeClass.asInstanceOf[Class[T]]

  override def possibleValues(valueProviderConfiguration: T): util.Collection[AnyRef] = {
    // execute script provided by user in ScriptValueProviderConfiguration
    scriptServices.asScala.find(_.accepts(valueProviderConfiguration.script)).map {
      _.executeScriptValueProvider(valueProviderConfiguration)
    }.get
  }
}

@Component
class GroovyScriptValueProvider(scriptServices: util.List[_ <: ScriptService]) extends ScriptValueProvider[GroovyProvider](scriptServices)

@Component
class JythonScriptValueProvider(scriptServices: util.List[_ <: ScriptService]) extends ScriptValueProvider[JythonProvider](scriptServices)

