package com.xebialabs.xlrelease.events.handlers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.events.{ReleaseCreatedEvent, ReleaseDeletedEvent, ReleaseStartedEvent, ReleaseUpdatedEvent}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.service.PendingPlanItemScheduledJobService
import com.xebialabs.xlrelease.user.User
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
@EventListener
class PendingReleaseAutoStartEventHandler @Autowired()(val releaseActorService: ReleaseActorService,
                                                       val pendingPlanItemScheduledJobService: PendingPlanItemScheduledJobService)
  extends Logging {

  @Subscribe
  def onReleaseCreated(event: ReleaseCreatedEvent): Unit = {
    if (event.release.canAutomaticallyStartReleaseNow) {
      releaseActorService.startReleaseWithoutResponse(event.release.getId, User.SYSTEM)
    } else if (event.release.canScheduleReleaseStart) {
      pendingPlanItemScheduledJobService.schedule(event.release)
    }
  }

  @Subscribe
  def onReleaseUpdated(event: ReleaseUpdatedEvent): Unit = {
    if (event.updated.canScheduleReleaseStart) {
      pendingPlanItemScheduledJobService.schedule(event.updated)
    } else if (!event.updated.isTemplate) {
      pendingPlanItemScheduledJobService.unschedule(event.updated)
    }
  }

  @Subscribe
  def onReleaseStarted(event: ReleaseStartedEvent): Unit = {
    pendingPlanItemScheduledJobService.unschedule(event.release)
  }

  @Subscribe
  def onReleaseDeleted(event: ReleaseDeletedEvent): Unit = {
    if (!event.release.isTemplate) {
      pendingPlanItemScheduledJobService.unschedule(event.release)
    }
  }
}
