package com.xebialabs.xlrelease.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.BaseArtifact;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.TemplateLogo;

import static com.google.common.io.ByteStreams.copy;

class TemplateExportHelper {
    static void addArtifacts(Release template, ZipOutputStream zipOutputStream) throws IOException {
        for (Attachment attachment : template.getAttachments()) {
            addArtifact(zipOutputStream, attachment);
        }
        final TemplateLogo logo = template.getLogo();
        if (null != logo) {
            addArtifact(zipOutputStream, logo, logo.getPortableFilename());
        }
    }

    public static void addArtifact(final ZipOutputStream zipOutputStream, final BaseArtifact artifact) throws IOException {
        String exportFilename = artifact.getExportFilename();
        addArtifact(zipOutputStream, artifact, exportFilename);
    }

    private static void addArtifact(final ZipOutputStream zipOutputStream, final BaseArtifact artifact, String exportFilename) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(exportFilename));
        try (InputStream inputStream = artifact.getFile().getInputStream()) {
            copy(inputStream, zipOutputStream);
        }
        zipOutputStream.closeEntry();
    }
}
