package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Database query logging",
  description = "With query logging turned on, database queries that take longer " +
    "than a specified time are logged in the server log to facilitate database optimization")
class DatabaseProxyFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Incubating", isTransient = true, hidden = true, readonly = true) // or that other
  var category: String = _

  @BeanProperty
  @XLProperty(label = "Log SQL queries", description = "Enable SQL query logging", category = "input", defaultValue = "false")
  var enableStatementLog: Boolean = _

  @BeanProperty
  @XLProperty(
    label = "Execution threshold",
    description = "Log SQL query that takes longer than the given threshold value in milliseconds",
    category = "input",
    defaultValue = "2000")
  @validation.Range(minimum = 0)
  var executionThresholdMs: Integer = _

  @BeanProperty
  @XLProperty(label = "Log parameters", description = "Log SQL query parameters", category = "input", defaultValue = "false")
  var logParameters: Boolean = _

}
