package com.xebialabs.xlrelease.security;

/**
 * Authentication plugins should provide a bean with the IdentityProvider's they provide.
 * These will be picked up by the AuthenticationResource that again provides it to the UI.
 * Currently we support only one auth plugin at a time. Otherwise they'll shield each other
 * on the classpath. So no error, just random behaviour.
 * TODO(REL-5084): Implement something that checks for the issue (we have a mention of that in REL-5084)
 */
public class IdentityProvider {
    private final String name;
    private final String loginUrl;
    private final String logoutUrl;

    public IdentityProvider(String name, String loginUrl, String logoutUrl) {
        this.name = name;
        this.loginUrl = loginUrl;
        this.logoutUrl = logoutUrl;
    }

    public String getName() {
        return name;
    }

    public String getLoginUrl() {
        return loginUrl;
    }

    public String getLogoutUrl() {
        return logoutUrl;
    }

    @Override
    public String toString() {
        return "IdentityProvider{" +
                "name='" + name + '\'' +
                ", loginUrl='" + loginUrl + '\'' +
                ", logoutUrl='" + logoutUrl + '\'' +
                '}';
    }
}
