package com.xebialabs.xlrelease.support.report

import com.xebialabs.plugin.manager.PluginId.{Artifact, LocalFile}
import com.xebialabs.plugin.manager.service.PluginService
import com.xebialabs.xlplatform.support.report.ReportDataProvider
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.nio.file.Files.isRegularFile
import java.nio.file.{Files, Path, Paths}
import java.util
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._
import scala.util.Using

@Component
class InstallationDataProvider @Autowired()(val pluginService: PluginService) extends ReportDataProvider {

  val name: String = "installation"
  val hotfixDir: Path = Paths.get("hotfix")
  val extDir: Path = Paths.get("ext")

  override def collectStatistics: Map[String, Any] = {
    val statistics = new InstallationUsageStatistics()
    val plugins = pluginService.listInstalled()
    statistics.setOfficialPlugins(plugins.filter(_.isInstanceOf[Artifact]).map(_.filename).asJava)
    statistics.setCustomPlugins(plugins.filter(_.isInstanceOf[LocalFile]).map(_.filename).asJava)
    statistics.setPluginsTotal(statistics.getOfficialPlugins.size() + statistics.getCustomPlugins.size())
    statistics.setCustomPluginsTotal(statistics.getCustomPlugins.size())
    statistics.setHotfixDirectory(listDirectory(hotfixDir).asJava)
    statistics.setExtDirectory(listDirectory(extDir).asJava)
    Map[String, Any]("installation" -> statistics)
  }

  private def listDirectory(path: Path): List[String] = {
    try {
      Using.resource(Files.walk(path)) { files =>
        files.iterator().asScala.filter(isRegularFile(_)).map(path.relativize(_).toString).toList
      }
    } catch {
      case e: Throwable => {
        logger.warn(s"Exception encountered listing contents of path ${path.toUri.getPath}", e)
        List.empty
      }
    }
  }
}

class InstallationUsageStatistics {
  @BeanProperty
  var officialPlugins: util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  var customPlugins: util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  var pluginsTotal: Int = 0

  @BeanProperty
  var customPluginsTotal: Int = 0

  @BeanProperty
  var hotfixDirectory: util.List[String] = new util.ArrayList[String]()

  @BeanProperty
  var extDirectory: util.List[String] = new util.ArrayList[String]()
}
