/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/profile")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ProfileResource {
    private final UserProfileService userProfileService;
    private final UserService userService;
    private final Users users;
    private final SessionService sessionService;
    private final UserAccountValidator userAccountValidator;
    private final PrincipalDataProvider principalDataProvider;

    @Autowired
    public ProfileResource(UserProfileService userProfileService, UserService userService, Users users, UserAccountValidator userAccountValidator, SessionService sessionService, PrincipalDataProvider principalDataProvider) {
        this.userProfileService = userProfileService;
        this.userService = userService;
        this.users = users;
        this.userAccountValidator = userAccountValidator;
        this.sessionService = sessionService;
        this.principalDataProvider = principalDataProvider;
    }

    @GET
    public UserAccount getProfile() {
        String authenticatedUsername = Permissions.getAuthenticatedUserName();
        UserProfile userProfile = this.userProfileService.findByUsername(authenticatedUsername);
        UserData userData = this.principalDataProvider.getUserData(authenticatedUsername);
        boolean isInternal = this.users.userExistsInRepository(authenticatedUsername);
        boolean personalAccessTokenEnabled = isInternal || userData.isFound();
        return new UserAccount(userProfile.getName(), userProfile, isInternal, personalAccessTokenEnabled);
    }

    @PUT
    public UserAccount saveProfile(UserAccount account) {
        String authenticatedUsername = Permissions.getAuthenticatedUserName();
        UserProfile profile = this.userProfileService.findByUsername(authenticatedUsername);
        UserData userData = this.principalDataProvider.getUserData(authenticatedUsername);
        boolean isInternal = this.users.userExistsInRepository(authenticatedUsername);
        boolean personalAccessTokenEnabled = isInternal || userData.isFound();
        profile.setEmail(account.getEmail());
        profile.setFullName(account.getFullName());
        profile.setDateFormat(account.getDateFormat());
        profile.setTimeFormat(account.getTimeFormat());
        profile.setFirstDayOfWeek(account.getFirstDayOfWeek());
        profile.setAnalyticsEnabled(account.isAnalyticsEnabled());
        profile.setTaskDrawerEnabled(account.isTaskDrawerEnabled());
        this.userProfileService.updateProfile(profile);
        if (account.hasPassword() && isInternal) {
            Preconditions.checkArgument((boolean)Strings.isNotBlank((String)account.getPreviousPassword()), (Object)"Previous password must be provided when changing the password.");
            this.userAccountValidator.checkPassword(account.getPassword());
            try {
                this.userService.modifyPassword(authenticatedUsername, account.getPassword(), account.getPreviousPassword());
                this.sessionService.disconnect(authenticatedUsername);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidPreviousPasswordException(e);
            }
        }
        return new UserAccount(profile.getName(), profile, isInternal, personalAccessTokenEnabled);
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class InvalidPreviousPasswordException
    extends DeployitException {
        public InvalidPreviousPasswordException(Throwable cause) {
            super(cause);
        }
    }
}

