/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\u0007\u000f\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002r\u0001!\t!a&\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007B\u0002-\u0001\t\u0013\tYNA\tVg\u0016\u0014Hk\\6f]J+7o\\;sG\u0016T!a\u0004\t\u0002\u0011%tG/\u001a:oC2T!!\u0005\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006g24GG\u001b\u0006\u0002K\u0005AqM]5{u2,G-\u0003\u0002(E\t9Aj\\4hS:<\u0017a\u00039fe6L7o]5p]N\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u0011M,7-\u001e:jifL!AL\u0016\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0007u_.,gnU3sm&\u001cW\r\u0005\u00022i5\t!G\u0003\u00024%\u000591/\u001a:wS\u000e,\u0017BA\u001b3\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0003vg\u0016\u00148\u000f\u0005\u00022q%\u0011\u0011H\r\u0002\u0006+N,'o]\u0001\u0016aJLgnY5qC2$\u0015\r^1Qe>4\u0018\u000eZ3s!\tat(D\u0001>\u0015\tq$#A\u0007qe&t7-\u001b9bY\u0012\fG/Y\u0005\u0003\u0001v\u0012Q\u0003\u0015:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u00163u\t\u0013\t\u0003\t\u0002i\u0011A\u0004\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006u\u0015\u0001\ra\u000f\u0015\u0003\u000b)\u0003\"a\u0013,\u000e\u00031S!!\u0014(\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002P!\u00069a-Y2u_JL(BA)S\u0003\u0015\u0011W-\u00198t\u0015\t\u0019F+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0016aA8sO&\u0011q\u000b\u0014\u0002\n\u0003V$xn^5sK\u0012\fQbZ3u+N,'\u000fV8lK:\u001cHc\u0001.h\u007fB\u00191\f\u00192\u000e\u0003qS!!\u00180\u0002\r\u0011|W.Y5o\u0015\ty&+\u0001\u0003eCR\f\u0017BA1]\u0005\u0011\u0001\u0016mZ3\u0011\u0005\r,W\"\u00013\u000b\u0005u\u0013\u0012B\u00014e\u0005%)6/\u001a:U_.,g\u000eC\u0003i\r\u0001\u0007\u0011.\u0001\u0003qC\u001e,\u0007CA\u000ek\u0013\tYGDA\u0002J]RDCaZ7xqB\u0011a.^\u0007\u0002_*\u0011\u0001/]\u0001\u0003eNT!A]:\u0002\u0005]\u001c(\"\u0001;\u0002\u000f)\f7.\u0019:uC&\u0011ao\u001c\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0001\u0006m\u0006dW/Z\u0011\u0002s\u0006\t\u0001\u0007\u000b\u0003hw^t\bC\u00018}\u0013\tixN\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\f\u0013\u0001\u001b\u0005\u0007\u0003\u00031\u0001\u0019A5\u0002\u001dI,7/\u001e7ugB+'\u000fU1hK\"*q0\\<\u0002\u0006\u0005\u0012\u0011qA\u0001\u0004cA\u0002\u0004&B@|o\u0006-\u0011EAA\u0001Q\r1\u0011q\u0002\t\u0004]\u0006E\u0011bAA\n_\n\u0019q)\u0012+)\r\u0019\t9b^A\u000f!\rq\u0017\u0011D\u0005\u0004\u00037y'\u0001\u0002)bi\"\f#!a\b\u0002\r=*8/\u001a:tQ\r1\u00111\u0005\t\u0005\u0003K\t\t$\u0004\u0002\u0002()\u0019Q*!\u000b\u000b\t\u0005-\u0012QF\u0001\b[\u0016$(/[2t\u0015\r\tyCF\u0001\tG>$\u0017\r[1mK&!\u00111GA\u0014\u0005\u0015!\u0016.\\3e\u0003Q9W\r\u001e+pW\u0016t7OR8s+N,'O\\1nKR9!,!\u000f\u0002^\u0005\r\u0004bBA\u001e\u000f\u0001\u0007\u0011QH\u0001\tkN,'O\\1nKB!\u0011qHA'\u001d\u0011\t\t%!\u0013\u0011\u0007\u0005\rC$\u0004\u0002\u0002F)\u0019\u0011q\t\r\u0002\rq\u0012xn\u001c;?\u0013\r\tY\u0005H\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-C\u0004K\u0004\u0002:\u0005Us/a\u0017\u0011\u00079\f9&C\u0002\u0002Z=\u0014\u0011\u0002U1uQB\u000b'/Y7\"\u0005\u0005m\u0002\"\u00025\b\u0001\u0004I\u0007&BA/[^D\b&BA/w^t\bBBA\u0001\u000f\u0001\u0007\u0011\u000e\u000b\u0004\u0002d5<\u0018Q\u0001\u0015\u0007\u0003GZx/a\u0003)\u0007\u001d\ty\u0001\u000b\u0004\b\u0003/9\u0018QN\u0011\u0003\u0003_\n\u0011cL;tKJ\u001cxf_;tKJt\u0017-\\3~\u0003E9WM\\3sCR,Wk]3s)>\\WM\u001c\u000b\u0006E\u0006U\u0014\u0011\u0010\u0005\b\u0003wA\u0001\u0019AA\u001fQ\u001d\t)(!\u0016x\u00037Bq!a\u001f\t\u0001\u0004\ti(A\u0007vg\u0016\u0014Hk\\6f]\u001a{'/\u001c\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u00151wN]7t\u0015\r\t9\tE\u0001\u0003mFJA!a#\u0002\u0002\ni2I]3bi\u0016\u0004VM]:p]\u0006d\u0017iY2fgN$vn[3o\r>\u0014X\u000eK\u0002\t\u0003\u001f\u00032A\\AI\u0013\r\t\u0019j\u001c\u0002\u0005!>\u001bF\u000b\u000b\u0004\t\u0003/9\u0018Q\u000e\u000b\u0004E\u0006e\u0005bBA>\u0013\u0001\u0007\u0011Q\u0010\u0015\u0004\u0013\u0005=\u0005FB\u0005\u0002\u0018]\fi\u0002K\u0002\n\u0003G\tq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0005\u0003K\u000bY\u000bE\u0002\u001c\u0003OK1!!+\u001d\u0005\u0011)f.\u001b;\t\u000f\u00055&\u00021\u0001\u00020\u0006)1-[+jIB!\u0011\u0011WA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016\u0001\u00027b]\u001eT!!!/\u0002\t)\fg/Y\u0005\u0005\u0003{\u000b\u0019LA\u0004J]R,w-\u001a:)\u000f\u0005-\u0016QK<\u0002B\u0006\u0012\u0011Q\u0016\u0015\u0004\u0015\u0005\u0015\u0007c\u00018\u0002H&\u0019\u0011\u0011Z8\u0003\r\u0011+E*\u0012+FQ\u0019Q\u0011qC<\u0002N\u0006\u0012\u0011qZ\u0001\u000f_U\u001cXM]:0w\u000eLW+\u001b3~Q\rQ\u00111E\u0001\"m\u0006d\u0017\u000eZ1uK\u0006sGMT8s[\u0006d\u0017N_3Vg\u0016\u0014Hk\\6f]\u001a{'/\u001c\u000b\u0007\u0003K\u000b9.!7\t\u000f\u0005m2\u00021\u0001\u0002>!9\u00111P\u0006A\u0002\u0005uDc\u0002.\u0002^\u0006}\u0017\u0011\u001d\u0005\b\u0003wa\u0001\u0019AA\u001f\u0011\u0015AG\u00021\u0001j\u0011\u0019\t\t\u0001\u0004a\u0001S\"2\u0001!a\u0006x\u0003K\f#!a:\u0002\u000f=\"xn[3og\"2\u0001!a;x\u0003c\u00042A\\Aw\u0013\r\tyo\u001c\u0002\t\u0007>t7/^7fg2\u0012\u00111_\u0011\u0003\u0003k\f\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\r\u0001\tIp^A\u0000!\rq\u00171`\u0005\u0004\u0003{|'\u0001\u0003)s_\u0012,8-Z:-\u0005\u0005M\bf\u0001\u0001\u0003\u0004A!!Q\u0001B\u0006\u001b\t\u00119AC\u0002\u0003\nI\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011iAa\u0002\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private final PrincipalDataProvider principalDataProvider;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users/{username}")
    public UserToken generateUserToken(@PathParam(value="username") String username, CreatePersonalAccessTokenForm userTokenForm) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.users.userExistsInRepository(username), (String)"Personal access tokens generated by administrator are only supported for internal users", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        boolean personalAccessTokenSupported = this.users.userExistsInRepository(username) || userData.isFound();
        Checks.checkArgument((boolean)personalAccessTokenSupported, (String)"Personal access tokens are only supported for internal users and external users authenticated via LDAP, Atlassian Crowd", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") Integer ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    private void validateAndNormalizeUserTokenForm(String username, CreatePersonalAccessTokenForm userTokenForm) {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    @Autowired
    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users, PrincipalDataProvider principalDataProvider) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
    }
}

