/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.io.ByteStreams;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.BaseArtifact;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class TemplateExportHelper {
    TemplateExportHelper() {
    }

    static void addArtifacts(Release template, ZipOutputStream zipOutputStream) throws IOException {
        for (Attachment attachment : template.getAttachments()) {
            TemplateExportHelper.addArtifact(zipOutputStream, (BaseArtifact)attachment);
        }
        TemplateLogo logo = template.getLogo();
        if (null != logo) {
            TemplateExportHelper.addArtifact(zipOutputStream, (BaseArtifact)logo, logo.getPortableFilename());
        }
    }

    public static void addArtifact(ZipOutputStream zipOutputStream, BaseArtifact artifact) throws IOException {
        String exportFilename = artifact.getExportFilename();
        TemplateExportHelper.addArtifact(zipOutputStream, artifact, exportFilename);
    }

    private static void addArtifact(ZipOutputStream zipOutputStream, BaseArtifact artifact, String exportFilename) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(exportFilename));
        try (InputStream inputStream = artifact.getFile().getInputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
        }
        zipOutputStream.closeEntry();
    }
}

