/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseAbortedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCompletedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u0011\"\u0001)B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011!9\u0006\u0001#b\u0001\n\u0013A\u0006b\u0002/\u0001\u0001\u0004%I!\u0018\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u0011\u0019y\u0007\u0001)Q\u0005=\"9\u0001\u000f\u0001a\u0001\n\u0013\t\bbB;\u0001\u0001\u0004%IA\u001e\u0005\u0007q\u0002\u0001\u000b\u0015\u0002:\t\u000fe\u0004\u0001\u0019!C\u0005c\"9!\u0010\u0001a\u0001\n\u0013Y\bBB?\u0001A\u0003&!\u000fC\u0003\u007f\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\u000e\u0001\t#\t9\u0004C\u0005\u0002d\u0001\t\n\u0011\"\u0005\u0002f!I\u0011\u0011\u0010\u0001\u0012\u0002\u0013E\u0011Q\r\u0005\b\u0003w\u0002A\u0011CA\u0001\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fB\u0011\"a$\u0001#\u0003%I!!%\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u0003Aa!a@\u0001\t\u0013i&!\u0005)sK\u0006\u00138\r[5wKN+'O^5dK*\u0011!eI\u0001\bg\u0016\u0014h/[2f\u0015\t!S%A\u0005yYJ,G.Z1tK*\u0011aeJ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001K\u0001\u0004G>l7\u0001A\n\u0004\u0001-\n\u0004C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#AB!osJ+g\r\u0005\u00023o5\t1G\u0003\u00025k\u0005)1\u000f\u001c45U*\ta'\u0001\u0005he&T(\u0010\\3e\u0013\tA4GA\u0004M_\u001e<\u0017N\\4\u0002\u0013ad'oQ8oM&<\u0007CA\u001e?\u001b\u0005a$BA\u001f$\u0003\u0019\u0019wN\u001c4jO&\u0011q\b\u0010\u0002\n12\u00148i\u001c8gS\u001e\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0011\u0005\t\u001bU\"A\u0011\n\u0005\u0011\u000b#\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u000e\n!B]3q_NLGo\u001c:z\u0013\tY\u0005JA\tSK2,\u0017m]3SKB|7/\u001b;pef\fq\"\u0019:dQ&4\u0018N\\4D_:4\u0017n\u001a\t\u0003w9K!a\u0014\u001f\u00031\u0005\u00138\r[5wS:<7+\u001a;uS:<7/T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0006%N#VK\u0016\t\u0003\u0005\u0002AQ!O\u0003A\u0002iBQ\u0001Q\u0003A\u0002\u0005CQ!R\u0003A\u0002\u0019CQ\u0001T\u0003A\u00025\u000ba\"\\1y)\"\u0014X-\u00193D_VtG/F\u0001Z!\ta#,\u0003\u0002\\[\t\u0019\u0011J\u001c;\u0002\tA|w\u000e\\\u000b\u0002=B\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\u000bG>t7-\u001e:sK:$(BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011q\r\u0019\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001\u00039p_2|F%Z9\u0015\u0005)l\u0007C\u0001\u0017l\u0013\taWF\u0001\u0003V]&$\bb\u00028\t\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014!\u00029p_2\u0004\u0013aB3oC\ndW\rZ\u000b\u0002eB\u0011Af]\u0005\u0003i6\u0012qAQ8pY\u0016\fg.A\u0006f]\u0006\u0014G.\u001a3`I\u0015\fHC\u00016x\u0011\u001dq7\"!AA\u0002I\f\u0001\"\u001a8bE2,G\rI\u0001\u000bG\u0006$8\r[5oOV\u0003\u0018AD2bi\u000eD\u0017N\\4Va~#S-\u001d\u000b\u0003UrDqA\u001c\b\u0002\u0002\u0003\u0007!/A\u0006dCR\u001c\u0007.\u001b8h+B\u0004\u0013!C5t\u000b:\f'\r\\3e\u0003\u0015\u0019H/\u0019:u)\u0005Q\u0017A\u00079sK\u0006\u00138\r[5wK\u000e{W\u000e\u001d7fi\u0016$'+\u001a7fCN,Gc\u00016\u0002\b!9\u0011\u0011\u0002\nA\u0002\u0005-\u0011!B3wK:$\b\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0007KZ,g\u000e^:\u000b\u0007\u0005U1%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u00033\tyAA\u000bSK2,\u0017m]3D_6\u0004H.\u001a;fI\u00163XM\u001c;)\u0007I\ti\u0002\u0005\u0003\u0002 \u0005\rRBAA\u0011\u0015\r\t\tbI\u0005\u0005\u0003K\t\tCA\u0005Tk\n\u001c8M]5cK\u0006A\u0002O]3Be\u000eD\u0017N^3BE>\u0014H/\u001a3SK2,\u0017m]3\u0015\u0007)\fY\u0003C\u0004\u0002\nM\u0001\r!!\f\u0011\t\u00055\u0011qF\u0005\u0005\u0003c\tyAA\nSK2,\u0017m]3BE>\u0014H/\u001a3Fm\u0016tG\u000fK\u0002\u0014\u0003;\t!\u0002\u001d:f\u0003J\u001c\u0007.\u001b<f)\u001dQ\u0017\u0011HA#\u0003\u0013Bq!a\u000f\u0015\u0001\u0004\ti$A\u0004sK2,\u0017m]3\u0011\t\u0005}\u0012\u0011I\u0007\u0003\u0003'IA!a\u0011\u0002\u0014\t9!+\u001a7fCN,\u0007\u0002CA$)A\u0005\t\u0019\u0001:\u0002\u0019\rDWmY6F]\u0006\u0014G.\u001a3\t\u0011\u0005-C\u0003%AA\u0002I\fqB]3d_Z,'/\u00134Fq&\u001cHo\u001d\u0015\u0004)\u0005=\u0003\u0003BA)\u0003?j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u000bC:tw\u000e^1uS>t'\u0002BA-\u00037\nq!\\3ue&\u001c7OC\u0002\u0002^\u001d\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003C\n\u0019FA\u0003US6,G-\u0001\u000bqe\u0016\f%o\u00195jm\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003OR3A]A5W\t\tY\u0007\u0005\u0003\u0002n\u0005UTBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA+[%!\u0011qOA8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0015aJ,\u0017I]2iSZ,G\u0005Z3gCVdG\u000fJ\u001a\u0002MA\u0014X-\u0011:dQ&4X-\u00138bGRLg/\u001a*fY\u0016\f7/Z:J]\n\u000b7m[4s_VtG-\u0001\u000eqe\u0016\f%o\u00195jm\u0016Le.Y2uSZ,'+\u001a7fCN,7\u000fF\u0002k\u0003\u0003C\u0001\"a!\u0019!\u0003\u0005\r!W\u0001\u0005a\u0006<W\rK\u0002\u0019\u0003\u000f\u0003B!!#\u0002\f6\u0011\u00111O\u0005\u0005\u0003\u001b\u000b\u0019HA\u0004uC&d'/Z2\u0002IA\u0014X-\u0011:dQ&4X-\u00138bGRLg/\u001a*fY\u0016\f7/Z:%I\u00164\u0017-\u001e7uIE*\"!a%+\u0007e\u000bI'A\btk\nl\u0017\u000e^,ji\"$U\r\\1z)\u0011\tI*!*\u0015\u0007)\fY\nC\u0004\u0002\u001ej\u0001\r!a(\u0002\u0007)|'\r\u0005\u0003-\u0003CS\u0017bAAR[\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003OS\u0002\u0019AAU\u0003\u0015!W\r\\1z!\u0011\tY+a-\u000e\u0005\u00055&\u0002BAX\u0003c\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003C6JA!!.\u0002.\nqa)\u001b8ji\u0016$UO]1uS>t\u0017AB:vE6LG/\u0006\u0003\u0002<\u0006\u0015Gc\u00016\u0002>\"9\u0011QT\u000eA\u0002\u0005}\u0006#\u0002\u0017\u0002\"\u0006\u0005\u0007\u0003BAb\u0003\u000bd\u0001\u0001B\u0004\u0002Hn\u0011\r!!3\u0003\u0003U\u000bB!a3\u0002RB\u0019A&!4\n\u0007\u0005=WFA\u0004O_RD\u0017N\\4\u0011\u00071\n\u0019.C\u0002\u0002V6\u00121!\u00118z\u0003!\u0011XO\u001c8bE2,W\u0003BAn\u0003c$B!!8\u0002jB!\u0011q\\As\u001b\t\t\tOC\u0002\u0002d\u0012\fA\u0001\\1oO&!\u0011q]Aq\u0005!\u0011VO\u001c8bE2,\u0007bBAv9\u0001\u0007\u0011Q^\u0001\u0005E>$\u0017\u0010E\u0003-\u0003C\u000by\u000f\u0005\u0003\u0002D\u0006EHaBAd9\t\u0007\u0011\u0011Z\u0001\bI&\u001c\u0018M\u00197f)\t\t9\u0010E\u0002-\u0003sL1!a?.\u0005\u0019\te.\u001f,bY\u00061QM\\1cY\u0016\f!b\u0019:fCR,\u0007k\\8mQ\r\u0001!1\u0001\t\u0005\u0005\u000b\u0011\u0019\"\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0005\u001b\u0011y!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\u0011\t\"A\u0002pe\u001eLAA!\u0006\u0003\b\t91+\u001a:wS\u000e,\u0007f\u0001\u0001\u0003\u001aA!\u0011q\u0004B\u000e\u0013\u0011\u0011i\"!\t\u0003\u001b\u00153XM\u001c;MSN$XM\\3s\u0001")
public class PreArchiveService
implements Logging {
    private int maxThreadCount;
    private final XlrConfig xlrConfig;
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivingSettingsManager archivingConfig;
    private ScheduledExecutorService pool;
    private boolean enabled;
    private boolean catchingUp;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private int maxThreadCount$lzycompute() {
        PreArchiveService preArchiveService = this;
        synchronized (preArchiveService) {
            if (!this.bitmap$0) {
                this.maxThreadCount = this.xlrConfig.executors().preArchivingExecutor().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        return this.maxThreadCount;
    }

    private int maxThreadCount() {
        if (!this.bitmap$0) {
            return this.maxThreadCount$lzycompute();
        }
        return this.maxThreadCount;
    }

    private ScheduledExecutorService pool() {
        return this.pool;
    }

    private void pool_$eq(ScheduledExecutorService x$1) {
        this.pool = x$1;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private boolean catchingUp() {
        return this.catchingUp;
    }

    private void catchingUp_$eq(boolean x$1) {
        this.catchingUp = x$1;
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> "Starting PreArchiveService");
        this.logger().trace((Function0 & Serializable)() -> "Setting preArchivingEnabled callback...");
        this.archivingConfig.subscribeToPreArchivingEnabledChanges(becomesEnabled -> {
            PreArchiveService preArchiveService = this;
            synchronized (preArchiveService) {
                if (Predef$.MODULE$.Boolean2boolean(becomesEnabled)) {
                    this.logger().trace((Function0 & Serializable)() -> "disabled -> enabled");
                    this.enabled_$eq(true);
                    this.preArchiveInactiveReleasesInBackground();
                } else {
                    this.logger().trace((Function0 & Serializable)() -> "enabled -> disabled");
                    this.enabled_$eq(false);
                }
            }
        });
        this.enabled_$eq(this.archivingConfig.getPreArchivingEnabled());
        if (this.enabled()) {
            this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
        }
        this.logger().debug((Function0 & Serializable)() -> "PreArchiveService started.");
    }

    @Subscribe
    public void preArchiveCompletedRelease(ReleaseCompletedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Subscribe
    public void preArchiveAbortedRelease(ReleaseAbortedEvent event) {
        this.preArchive(event.release(), this.preArchive$default$2(), this.preArchive$default$3());
    }

    @Timed
    public void preArchive(Release release, boolean checkEnabled, boolean recoverIfExists) {
        if (!checkEnabled || this.enabled() && !this.catchingUp()) {
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    this.logger().info((Function0 & Serializable)() -> "Pre-archiving " + release);
                    $this.archivingService.preArchiveRelease(release);
                    this.logger().debug((Function0 & Serializable)() -> "Pre-archived " + release);
                }
                catch (Exception e) {
                    this.logger().warn((Function0 & Serializable)() -> "Something went wrong while pre-archiving", (Function0 & Serializable)() -> e);
                    if (!recoverIfExists) {
                        throw e;
                    }
                    if ($this.archivingService.exists(release.getId())) {
                        this.logger().debug((Function0 & Serializable)() -> "Removing " + release + " from Archive Database");
                        if ($this.archivingService.deletePreArchiveRelease(release.getId())) {
                            this.logger().debug((Function0 & Serializable)() -> "Pre-archiving again " + release);
                            this.preArchive(release, checkEnabled, false);
                        } else {
                            this.logger().debug((Function0 & Serializable)() -> "Removing failed " + release + " from Archive Database");
                        }
                    }
                    this.logger().debug((Function0 & Serializable)() -> "Release " + release + " does not exist in Archive Database", (Function0 & Serializable)() -> e);
                    throw e;
                }
            });
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Pre-archiving is disabled");
    }

    public boolean preArchive$default$2() {
        return true;
    }

    public boolean preArchive$default$3() {
        return true;
    }

    public synchronized void preArchiveInactiveReleasesInBackground() {
        if (!this.catchingUp()) {
            this.catchingUp_$eq(true);
            this.submit((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                this.preArchiveInactiveReleases(this.preArchiveInactiveReleases$default$1());
                this.catchingUp_$eq(false);
            });
            return;
        }
    }

    private void preArchiveInactiveReleases(int page) {
        while (true) {
            Integer pageSize = this.archivingConfig.getSearchPageSize();
            this.logger().debug((Function0 & Serializable)() -> "Fetching page " + page + " (" + pageSize + " releases) for pre-archiving...");
            Seq<Release> found = this.releaseRepository.findPreArchivableReleases(page, Predef$.MODULE$.Integer2int(pageSize));
            ((IterableOnceOps)found.filter((Function1 & Serializable)release -> BoxesRunTime.boxToBoolean((boolean)this.archivingService.shouldArchive(release)))).foreach((Function1 & Serializable)x$1 -> {
                this.preArchive(x$1, false, this.preArchive$default$3());
                return BoxedUnit.UNIT;
            });
            if (!this.enabled() || !BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)found.size()), (Object)pageSize)) break;
            ++page;
        }
    }

    private int preArchiveInactiveReleases$default$1() {
        return 0;
    }

    private void submitWithDelay(FiniteDuration delay, Function0<BoxedUnit> job) {
        this.pool().schedule(this.runnable(job), delay.toSeconds(), TimeUnit.SECONDS);
    }

    private <U> void submit(Function0<U> job) {
        this.pool().submit(this.runnable(job));
    }

    private <U> Runnable runnable(Function0<U> body) {
        return () -> body.apply();
    }

    public Object disable() {
        Object object;
        try {
            this.pool().shutdown();
            object = BoxesRunTime.boxToBoolean((boolean)this.pool().awaitTermination(10L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> "Unable to disable pre-archive service");
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public void enable() {
        if (this.pool().isShutdown() || this.pool().isTerminated()) {
            this.pool_$eq(this.createPool());
            return;
        }
    }

    private ScheduledExecutorService createPool() {
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(this.maxThreadCount(), new PrefixedThreadFactory("pre-archiving", Predef$.MODULE$.boolean2Boolean(true)));
        if (this.xlrConfig.metrics().enabled()) {
            return new InstrumentedScheduledExecutorService(threadPool, XlrMetricRegistry$.MODULE$.metricRegistry(), "preArchiving");
        }
        return threadPool;
    }

    public PreArchiveService(XlrConfig xlrConfig, ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivingSettingsManager archivingConfig) {
        this.xlrConfig = xlrConfig;
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.pool = this.createPool();
        this.enabled = false;
        this.catchingUp = false;
    }
}

