/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.calendar.ReleaseCalendar;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.param.DateParam;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CalendarService;
import com.xebialabs.xlrelease.service.ReleaseService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/calendar")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CalendarResource {
    private ReleaseService releaseService;
    private CalendarService calendarService;
    private PermissionChecker permissions;

    @Autowired
    public CalendarResource(ReleaseService releaseService, CalendarService calendarService, PermissionChecker permissions) {
        this.releaseService = releaseService;
        this.calendarService = calendarService;
        this.permissions = permissions;
    }

    @GET
    @Timed
    @Path(value="/subscribe/{calendarToken}")
    public Response subscribe(@PathParam(value="calendarToken") String calendarToken) {
        Release release = this.releaseService.findByCalendarToken(calendarToken);
        if (release == null || !release.isCalendarPublished()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String ics = new ReleaseCalendar(release).toString();
        return Response.ok((Object)ics).build();
    }

    @GET
    @Timed
    @Path(value="/specialDays/{specialDayId:.*/Calendar/[0-9^/]{8}}")
    public SpecialDay getSpecialDay(@PathParam(value="specialDayId") String specialDayId) {
        return this.calendarService.getSpecialDay(specialDayId);
    }

    @PUT
    @Timed
    @Path(value="/specialDays/{specialDayId:.*/Calendar/[0-9^/]{8}}")
    public SpecialDay setSpecialDay(@PathParam(value="specialDayId") String specialDayId, SpecialDay specialDay) {
        return this.calendarService.setSpecialDay(specialDayId, specialDay);
    }

    @GET
    @Timed
    @Path(value="/specialDays")
    public List<SpecialDay> getSpecialDays(@QueryParam(value="from") @DateParam Date from, @QueryParam(value="to") @DateParam Date to) {
        return this.calendarService.getSpecialDays(from, to);
    }

    @GET
    @Timed
    @Path(value="/blackouts")
    public List<Blackout> getBlackouts(@QueryParam(value="from") @DateParam Date from, @QueryParam(value="to") @DateParam Date to) {
        return this.calendarService.getBlackouts(from, to);
    }

    @GET
    @Timed
    @Path(value="/blackouts/{blackoutId:.*/Blackout[^/]*}")
    public Blackout getBlackout(@PathParam(value="blackoutId") String blackoutId) {
        return this.calendarService.getBlackout(blackoutId);
    }

    @POST
    @Timed
    @Path(value="/blackouts")
    public Blackout addBlackout(Blackout blackout) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_BLACKOUT);
        return this.calendarService.addBlackout(blackout);
    }

    @PUT
    @Timed
    @Path(value="/blackouts/{blackoutId:.*/Blackout[^/]*}")
    public Blackout updateBlackout(@PathParam(value="blackoutId") String blackoutId, Blackout blackout) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_BLACKOUT);
        blackout.setId(blackoutId);
        return this.calendarService.updateBlackout(blackout);
    }

    @DELETE
    @Timed
    @Path(value="/blackouts/{blackoutId:.*/Blackout[^/]*}")
    public void deleteBlackout(@PathParam(value="blackoutId") String blackoutId) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_BLACKOUT);
        this.calendarService.deleteBlackout(blackoutId);
    }

    @GET
    @Timed
    @Path(value="/blackouts/withinBlackout")
    public boolean withinBlackout() {
        return this.calendarService.isInBlackout(new Date());
    }
}

