/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.authentication.policy.UserGroupMembershipCreationPolicy;
import com.xebialabs.xlrelease.security.authentication.policy.UserProfileCreationPolicy;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u000554A\u0001C\u0005\u0001%!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\"\u0002&\u0001\t\u0003Y\u0005\"B)\u0001\t\u0003\u0012\u0006\"\u0002.\u0001\t\u0013Y\u0006\"B2\u0001\t\u0013!'AI!vi\",g\u000e^5dCRLwN\\*vG\u000e,7o]#wK:$H*[:uK:,'O\u0003\u0002\u000b\u0017\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'B\u0001\u0007\u000e\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u000f\u001f\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002!\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aE\u000e\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00027b]\u001eT\u0011\u0001G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001b+\t1qJ\u00196fGR\u00042\u0001H\u0012&\u001b\u0005i\"B\u0001\u0010 \u0003\u001d\u0019wN\u001c;fqRT!\u0001I\u0011\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AI\u0001\u0004_J<\u0017B\u0001\u0013\u001e\u0005M\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8MSN$XM\\3s!\t1C&D\u0001(\u0015\tA\u0013&A\u0003fm\u0016tGO\u0003\u0002\u000bU)\u00111fH\u0001\tg\u0016\u001cWO]5us&\u0011Qf\n\u0002\u001b\u0003V$\b.\u001a8uS\u000e\fG/[8o'V\u001c7-Z:t\u000bZ,g\u000e^\u0001\u001ckN,'\u000f\u0015:pM&dWm\u0011:fCRLwN\u001c)pY&\u001c\u0017.Z:\u0011\u0007A\u001aT'D\u00012\u0015\t\u0011t#\u0001\u0003vi&d\u0017B\u0001\u001b2\u0005\u0011a\u0015n\u001d;\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014A\u00029pY&\u001c\u0017P\u0003\u0002\u000bu)\u00111fC\u0005\u0003y]\u0012\u0011$V:feB\u0013xNZ5mK\u000e\u0013X-\u0019;j_:\u0004v\u000e\\5ds\u0006\u0019So]3s\u000fJ|W\u000f]'f[\n,'o\u001d5ja\u000e\u0013X-\u0019;j_:\u0004v\u000e\\5dS\u0016\u001c\bc\u0001\u00194\u007fA\u0011a\u0007Q\u0005\u0003\u0003^\u0012\u0011%V:fe\u001e\u0013x.\u001e9NK6\u0014WM]:iSB\u001c%/Z1uS>t\u0007k\u001c7jGf\f!\u0003]3s[&\u001c8/[8o\u000b:4wN]2feB\u0011A\tS\u0007\u0002\u000b*\u00111F\u0012\u0006\u0003\u000f6\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u0013\u0016\u0013!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u00061A(\u001b8jiz\"B\u0001\u0014(P!B\u0011Q\nA\u0007\u0002\u0013!)a\u0006\u0002a\u0001_!)Q\b\u0002a\u0001}!)!\t\u0002a\u0001\u0007\u0006\u0011rN\\!qa2L7-\u0019;j_:,e/\u001a8u)\t\u0019\u0016\f\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVK\u0001\u0003V]&$\b\"\u0002\u0015\u0006\u0001\u0004)\u0013\u0001\t4j]\u0012\f\u0005\u000f\u001d7jG\u0006\u0014G.Z+tKJ\u001c%/Z1uS>t\u0007k\u001c7jGf$\"!\u000e/\t\u000b)1\u0001\u0019A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001T\u0013\u0001B2pe\u0016L!AY0\u0003\u001d\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u0006)c-\u001b8e\u0003B\u0004H.[2bE2,Wk]3s\u000fJ|W\u000f]\"sK\u0006$\u0018n\u001c8Q_2L7-\u001f\u000b\u0003\u007f\u0015DQAC\u0004A\u0002uC#\u0001A4\u0011\u0005!\\W\"A5\u000b\u0005)|\u0012AC:uKJ,w\u000e^=qK&\u0011A.\u001b\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class AuthenticationSuccessEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private final List<UserProfileCreationPolicy> userProfileCreationPolicies;
    private final List<UserGroupMembershipCreationPolicy> userGroupMembershipCreationPolicies;
    private final PermissionEnforcer permissionEnforcer;

    public boolean supportsAsyncExecution() {
        return super.supportsAsyncExecution();
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        if (authentication != null && Strings.isNotEmpty((String)authentication.getName())) {
            boolean hasLoginPermission = this.permissionEnforcer.hasPermission(authentication, new Permission[]{PlatformPermissions.LOGIN});
            if (!hasLoginPermission) {
                throw new DisabledException("The user " + authentication.getName() + " or its group(s) do not have login permission");
            }
            UserProfileCreationPolicy creationPolicy = this.findApplicableUserCreationPolicy(authentication);
            creationPolicy.createProfile(authentication);
            UserGroupMembershipCreationPolicy ugCreationPolicy = this.findApplicableUserGroupCreationPolicy(authentication);
            ugCreationPolicy.updateUserGroupMembership(authentication);
            return;
        }
    }

    private UserProfileCreationPolicy findApplicableUserCreationPolicy(Authentication authentication) {
        return (UserProfileCreationPolicy)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userProfileCreationPolicies).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.policyApplies(authentication))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No UserProfile creation policy applicable for authentication [" + authentication + "]");
        });
    }

    private UserGroupMembershipCreationPolicy findApplicableUserGroupCreationPolicy(Authentication authentication) {
        return (UserGroupMembershipCreationPolicy)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userGroupMembershipCreationPolicies).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.policyApplies(authentication))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No UserGroupMembership creation policy applicable for authentication [" + authentication + "]");
        });
    }

    public AuthenticationSuccessEventListener(List<UserProfileCreationPolicy> userProfileCreationPolicies, List<UserGroupMembershipCreationPolicy> userGroupMembershipCreationPolicies, PermissionEnforcer permissionEnforcer) {
        this.userProfileCreationPolicies = userProfileCreationPolicies;
        this.userGroupMembershipCreationPolicies = userGroupMembershipCreationPolicies;
        this.permissionEnforcer = permissionEnforcer;
    }
}

