/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowdownFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SlowdownFilter.class);
    public static final String MS = "ms";
    private int millisecondsToSlowDown = 0;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.millisecondsToSlowDown = Integer.parseInt(filterConfig.getInitParameter(MS));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Thread.sleep(this.millisecondsToSlowDown);
        }
        catch (InterruptedException e) {
            logger.error("Slowing down the request was interrupted", (Throwable)e);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

