/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.filters.RolePrincipalsFilters;
import com.xebialabs.xlrelease.domain.events.GlobalRolesOrPermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.RolePrincipalEventPublisher;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;

@Path(value="/roles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePrincipalsResource {
    private static final Logger logger = LoggerFactory.getLogger(RolePrincipalsResource.class);
    private final PermissionChecker permissionChecker;
    private final RoleService roleService;
    private final TeamService teamService;
    private final ReleaseRoleService releaseRoleService;
    private final XLReleaseEventBus xlReleaseEventBus;
    private final DtoReader dtoReader = new DtoReader();

    @Autowired
    public RolePrincipalsResource(PermissionChecker permissionChecker, RoleService roleService, TeamService teamService, ReleaseRoleService releaseRoleService, XLReleaseEventBus xlReleaseEventBus) {
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.teamService = teamService;
        this.releaseRoleService = releaseRoleService;
        this.xlReleaseEventBus = xlReleaseEventBus;
    }

    @GET
    @Timed
    @Path(value="names")
    public List<String> readRoleNames() {
        return this.roleService.getRoles().stream().map(Role::getName).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="principals")
    public Page<RolePrincipalsView> readRolePrincipals(@BeanParam RolePrincipalsFilters filters, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{100L});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.readRolePrincipals(filters, (Pageable)pageable);
    }

    @Timed
    @Deprecated(since="24.1")
    public List<RolePrincipalsView> readRolePrincipals() {
        RolePrincipalsFilters filters = new RolePrincipalsFilters(null, null);
        Page<RolePrincipalsView> results = this.readRolePrincipals(filters, Pageable.unpaged());
        return results.getContent();
    }

    @PUT
    @Timed
    @Path(value="principals")
    public void createOrUpdateGlobalRolePermission(RolePrincipalsView rolePrincipalsView) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        RolePrincipals rolePrincipals = rolePrincipalsView.toRolePrincipals();
        this.teamService.generateIdIfNecessary(rolePrincipals.getRole());
        Role role = (Role)this.dtoReader.readRoleAssignments(Collections.singletonList(rolePrincipals)).get(0);
        logger.debug(String.format("createOrUpdateGlobalRolePermission: role := %s / %s", role.getId(), role.getName()));
        Optional<Role> originalRole = this.getRole(role.getId());
        this.roleService.createOrUpdateRole(role);
        RolePrincipalEventPublisher.publishCreateOrUpdate(originalRole, role);
        this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
    }

    @DELETE
    @Timed
    @Path(value="principals/{roleId:.*}")
    public void deleteGlobalRolePermission(@PathParam(value="roleId") String roleId) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        Optional<Role> role = this.getRole(roleId);
        if (role.isPresent()) {
            this.roleService.deleteById(roleId);
            RolePrincipalEventPublisher.publishDelete(role);
            this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
        }
    }

    private Page<RolePrincipalsView> readRolePrincipals(RolePrincipalsFilters filters, Pageable pageable) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        return this.releaseRoleService.getGlobalRolePrincipalViews(filters, pageable);
    }

    private Optional<Role> getRole(String roleId) {
        try {
            Role role = this.roleService.getRoleForRoleId(roleId);
            return Optional.of(role);
        }
        catch (NotFoundException nfe) {
            logger.trace(nfe.getMessage());
            return Optional.empty();
        }
    }
}

