/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.JobConfirmationActor;
import com.xebialabs.xlrelease.actors.JobConfirmed;
import com.xebialabs.xlrelease.actors.MonitorJobConfirmation;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.features.JobSchedulerFeature$;
import com.xebialabs.xlrelease.features.settings.JobSchedulerStrategySettings;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.DefaultJobQueue;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobProvider;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRunnerQueue;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.strategies.LimitParallelJobSchedulerStrategySettings;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Primary
@Component
@ScalaSignature(bytes="\u0006\u0005\t\u001de\u0001B\u0012%\u00015B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011)\u0019!C\u0001\u0017\"A!\u000b\u0001B\u0001B\u0003%A\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"B3\u0001\t\u00031\u0007\u0002\u00037\u0001\u0011\u000b\u0007I\u0011B7\t\u000fe\u0004!\u0019!C\u0005u\"9\u0011\u0011\t\u0001!\u0002\u0013Y\bbBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003;\u0002A\u0011IA0\u0011\u001d\tI\u0007\u0001C#\u0003WBq!a#\u0001\t\u0013\ti\tC\u0004\u00026\u0002!I!a.\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAu\u0001\u0011\u0005\u00131\u001e\u0005\b\u0003s\u0004A\u0011BA~\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqAa\u0005\u0001\t\u0003\u0012)\u0002C\u0004\u0003\u001a\u0001!\tEa\u0007\t\u000f\t}\u0001\u0001\"\u0011\u0003\"!9!Q\u0005\u0001\u0005B\t\u001d\u0002b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005c\u0001A\u0011\tB\u001a\u0011\u001d\u00119\u0004\u0001C!\u0005sAqAa\u000f\u0001\t\u0003\u0012I\u0004C\u0004\u0003>\u0001!\tEa\u0010\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D!9!1\n\u0001\u0005\n\te\u0002b\u0002B'\u0001\u0011%!q\n\u0005\b\u0005'\u0002A\u0011\u0002B+\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057BqAa\u0018\u0001\t\u0003\u0012\tGA\fDCB\f'-\u001b7jif\fu/\u0019:f\u0015>\u0014\u0017+^3vK*\u0011QEJ\u0001\ng\u000eDW\rZ;mKJT!a\n\u0015\u0002\u0013ad'/\u001a7fCN,'BA\u0015+\u0003%AXMY5bY\u0006\u00147OC\u0001,\u0003\r\u0019w.\\\u0002\u0001'\u0019\u0001a\u0006\u000e\u001d<}A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001c\u000e\u0003\u0011J!a\u000e\u0013\u0003\u0011){'-U;fk\u0016\u0004\"!N\u001d\n\u0005i\"#A\u0004*v]:,'OU3hSN$(/\u001f\t\u0003kqJ!!\u0010\u0013\u0003\u0017){'\r\u0015:pm&$WM\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQa\u001d7gi)T\u0011aQ\u0001\tOJL'P\u001f7fI&\u0011Q\t\u0011\u0002\b\u0019><w-\u001b8h\u0003!QwNY)vKV,\u0007CA\u001bI\u0013\tIEEA\bEK\u001a\fW\u000f\u001c;K_\n\fV/Z;f\u0003MQwN\u0019*v]:,'OU3q_NLGo\u001c:z+\u0005a\u0005CA'Q\u001b\u0005q%BA('\u0003)\u0011X\r]8tSR|'/_\u0005\u0003#:\u00131CS8c%Vtg.\u001a:SKB|7/\u001b;pef\fAC[8c%Vtg.\u001a:SKB|7/\u001b;pef\u0004\u0013a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007CA+Y\u001b\u00051&BA,'\u0003\u0019\t7\r^8sg&\u0011\u0011L\u0016\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0010gB\u0014\u0018N\\4FqR,gn]5p]B\u0011AlY\u0007\u0002;*\u0011alX\u0001\u0007gB\u0014\u0018N\\4\u000b\u0005\u0001\f\u0017!\u00029fW.|'B\u00012'\u0003\u001d\u0019X\u000f\u001d9peRL!\u0001Z/\u0003\u001fM\u0003(/\u001b8h\u000bb$XM\\:j_:\fa\u0001P5oSRtD#B4iS*\\\u0007CA\u001b\u0001\u0011\u00151e\u00011\u0001H\u0011\u0015Qe\u00011\u0001M\u0011\u0015\u0019f\u00011\u0001U\u0011\u0015Qf\u00011\u0001\\\u0003!\t7\r^8s%\u00164W#\u00018\u0011\u0005=<X\"\u00019\u000b\u0005E\u0014\u0018!B1di>\u0014(B\u00011t\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\n\u0005a\u0004(\u0001C!di>\u0014(+\u001a4\u0002\u0019I,hN\\3s#V,W/Z:\u0016\u0003m\u0004r\u0001`A\u0004\u0003\u0017\tY$D\u0001~\u0015\tqx0\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0001\u0002\u0004\u0005!Q\u000f^5m\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005{\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\t\u00055\u0011Q\u0007\b\u0005\u0003\u001f\tyC\u0004\u0003\u0002\u0012\u0005%b\u0002BA\n\u0003KqA!!\u0006\u0002$9!\u0011qCA\u0011\u001d\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fY\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0007\u0005\u001db%\u0001\u0004sk:tWM]\u0005\u0005\u0003W\ti#\u0001\u0004e_6\f\u0017N\u001c\u0006\u0004\u0003O1\u0013\u0002BA\u0019\u0003g\tq\u0001]1dW\u0006<WM\u0003\u0003\u0002,\u00055\u0012\u0002BA\u001c\u0003s\u0011\u0001BU;o]\u0016\u0014\u0018\n\u001a\u0006\u0005\u0003c\t\u0019\u0004E\u00026\u0003{I1!a\u0010%\u00059QuN\u0019*v]:,'/U;fk\u0016\fQB];o]\u0016\u0014\u0018+^3vKN\u0004\u0013!\u0005:fO&\u001cH/\u001a:K_\n\u0014VO\u001c8feR!\u0011qIA'!\ry\u0013\u0011J\u0005\u0004\u0003\u0017\u0002$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001fR\u0001\u0019AA)\u0003%QwN\u0019*v]:,'\u000f\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9#a\u0016\u000b\u0007\u0005-b%\u0003\u0003\u0002\\\u0005U#!\u0003&pEJ+hN\\3s\u0003M)hN]3hSN$XM\u001d&pEJ+hN\\3s)\u0011\t\t'a\u001a\u0011\u0007=\n\u0019'C\u0002\u0002fA\u0012A!\u00168ji\"9\u0011qJ\u0006A\u0002\u0005E\u0013aA4fiR!\u0011QNA=!\u0015y\u0013qNA:\u0013\r\t\t\b\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007U\n)(C\u0002\u0002x\u0011\u00121AS8c\u0011\u001d\tY\b\u0004a\u0001\u0003\u0017\t\u0001B];o]\u0016\u0014\u0018\n\u001a\u0015\u0004\u0019\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015\u0005'\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0004\n9A/Y5me\u0016\u001c\u0017A\u00043fY\u0006LxJ\u001d*fg\u0016\u0014h/\u001a\u000b\u0007\u0003[\ny)a-\t\u000f\u0005EU\u00021\u0001\u0002\u0014\u00069A/Y:l\u0015>\u0014\u0007\u0007BAK\u0003?\u0003R!NAL\u00037K1!!'%\u0005\u001d!\u0016m]6K_\n\u0004B!!(\u0002 2\u0001A\u0001DAQ\u0003\u001f\u000b\t\u0011!A\u0003\u0002\u0005\r&aA0%cE!\u0011QUAV!\ry\u0013qU\u0005\u0004\u0003S\u0003$a\u0002(pi\"Lgn\u001a\t\u0005\u0003[\u000by+\u0004\u0002\u0002X%!\u0011\u0011WA,\u0005\u0011!\u0016m]6\t\u000f\u0005mT\u00021\u0001\u0002\f\u0005AA-\u001a7bs*{'\r\u0006\u0003\u0002b\u0005e\u0006bBA^\u001d\u0001\u0007\u0011QX\u0001\u0004U>\u0014\u0007\u0003BA`\u0003#tA!!1\u0002L:!\u00111YAd\u001d\u0011\t\u0019\"!2\n\u0005\u00152\u0013bAAeI\u0005Q1\u000f\u001e:bi\u0016<\u0017.Z:\n\t\u00055\u0017qZ\u0001\u0015\u0015>\u00147k\u00195fIVdWM]*ue\u0006$XmZ=\u000b\u0007\u0005%G%\u0003\u0003\u0002T\u0006U'A\u0003#fY\u0006LX\r\u001a&pE*!\u0011QZAh\u0003)\u0011Xm]3sm\u0016TuN\u0019\u000b\u0007\u0003[\nY.a8\t\u000f\u0005uw\u00021\u0001\u0002t\u0005Y\u0001o\\:tS\ndWMS8c\u0011\u001d\tYh\u0004a\u0001\u0003\u0017\tqA]3tKJ4X\r\u0006\u0004\u0002t\u0005\u0015\u0018q\u001d\u0005\b\u0003;\u0004\u0002\u0019AA:\u0011\u001d\tY\b\u0005a\u0001\u0003\u0017\tqaY8oM&\u0014X\u000e\u0006\u0004\u0002H\u00055\u0018q\u001e\u0005\b\u0003w\n\u0002\u0019AA\u0006\u0011\u001d\t\t0\u0005a\u0001\u0003g\fQA[8c\u0013\u0012\u0004B!!\u0004\u0002v&!\u0011q_A\u001d\u0005\u0015QuNY%e\u0003YygMZ3s)>TuN\u0019*v]:,'/U;fk\u0016\u001cH\u0003BA1\u0003{Dq!a/\u0013\u0001\u0004\t\u0019(A\rsK6|g/\u001a$s_6TuN\u0019*v]:,'/U;fk\u0016\u001cH\u0003BA1\u0005\u0007AqA!\u0002\u0014\u0001\u0004\u00119!A\u0005qe\u0016$\u0017nY1uKB1!\u0011\u0002B\b\u0003gj!Aa\u0003\u000b\u0007\t5q0\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u0011\tBa\u0003\u0003\u0013A\u0013X\rZ5dCR,\u0017AB:vE6LG\u000f\u0006\u0003\u0002b\t]\u0001bBA^)\u0001\u0007\u00111O\u0001\u000fgV\u0014W.\u001b;Fq&\u001cH/\u001b8h)\u0011\t\tG!\b\t\u000f\u0005mV\u00031\u0001\u0002t\u0005\t2/\u001e2nSR\u0014%o\\1eG\u0006\u001cH/\u001a3\u0015\t\u0005\u0005$1\u0005\u0005\b\u0003w3\u0002\u0019AA:\u0003\u001d\u0011X\r\u001d7bG\u0016$B!!\u0019\u0003*!9\u00111X\fA\u0002\u0005M\u0014A\u00024j]&\u001c\b\u000e\u0006\u0003\u0002b\t=\u0002bBAy1\u0001\u0007\u00111_\u0001\tG\u0006t7-\u001a7JMR!\u0011\u0011\rB\u001b\u0011\u001d\u0011)!\u0007a\u0001\u0005\u000f\tQa\u001d;beR$\"!!\u0019\u0002\tM$x\u000e]\u0001\nSN\u0014VO\u001c8j]\u001e$\"!a\u0012\u0002\tML'0\u001a\u000b\u0003\u0005\u000b\u00022a\fB$\u0013\r\u0011I\u0005\r\u0002\u0004\u0013:$\u0018A\u0005:fO&\u001cH/\u001a:K_\n\u0014VO\u001c8feN\f\u0011c\u0019:fCR,'+\u001e8oKJ\fV/Z;f)\u0011\t\tG!\u0015\t\u000f\u0005\u001dr\u00041\u0001\u0002R\u0005\t\"/Z7pm\u0016\u0014VO\u001c8feF+X-^3\u0015\t\u0005\u0005$q\u000b\u0005\b\u0003O\u0001\u0003\u0019AA)\u0003Q)\b\u000fZ1uKR\u000b7o[*uCR,8\u000fT5oKR!\u0011\u0011\rB/\u0011\u001d\tY,\ta\u0001\u0003g\n\u0011\"\u001e8SKN,'O^3\u0015\t\u0005\u0005$1\r\u0005\b\u0003w\u0013\u0003\u0019AA:Q\r\u0001!q\r\t\u0005\u0005S\u0012)(\u0004\u0002\u0003l)!\u0011Q\u0011B7\u0015\u0011\u0011yG!\u001d\u0002\u000f\r|g\u000e^3yi*\u0019!1O;\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.LAAa\u001e\u0003l\t9\u0001K]5nCJL\bf\u0001\u0001\u0003|A!!Q\u0010BB\u001b\t\u0011yH\u0003\u0003\u0003\u0002\nE\u0014AC:uKJ,w\u000e^=qK&!!Q\u0011B@\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class CapabilityAwareJobQueue
implements JobQueue,
RunnerRegistry,
JobProvider,
Logging {
    private ActorRef actorRef;
    private final DefaultJobQueue jobQueue;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final SpringExtension springExtension;
    private final ConcurrentHashMap<String, JobRunnerQueue> runnerQueues;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    private ActorRef actorRef$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$0) {
                this.actorRef = this.springExtension.actorOf(JobConfirmationActor.class, this.springExtension.actorOf$default$2(), this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private ConcurrentHashMap<String, JobRunnerQueue> runnerQueues() {
        return this.runnerQueues;
    }

    @Override
    public boolean registerJobRunner(JobRunner jobRunner) {
        boolean updateInQueue;
        Option runnerQueue = Option$.MODULE$.apply((Object)this.runnerQueues().get(jobRunner.getId()));
        boolean bl = updateInQueue = runnerQueue.isEmpty() || runnerQueue.nonEmpty() && ((JobRunnerQueue)runnerQueue.get()).isOutdated(jobRunner);
        if (updateInQueue) {
            this.logger().debug((Function0 & Serializable)() -> "Going to register runner[" + jobRunner.getId() + "]");
            this.createRunnerQueue(jobRunner);
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Runner already in queue, skipping registration for runner[" + jobRunner.getId() + "]");
        }
        return updateInQueue;
    }

    @Override
    public void unregisterJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to un-register runner[" + jobRunner.getId() + "]");
        this.removeRunnerQueue(jobRunner);
    }

    @Override
    public final Option<Job> get(String runnerId) {
        Option s;
        Option option;
        while ((option = (s = Option$.MODULE$.apply((Object)this.runnerQueues().get(runnerId)))) instanceof Some) {
            Some some = (Some)option;
            JobRunnerQueue runnerQueue = (JobRunnerQueue)some.value();
            Option option2 = Option$.MODULE$.apply((Object)runnerQueue.poll());
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Job possibleJob = (Job)some2.value();
                Job job = possibleJob;
                if (job instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job;
                    return new Some((Object)stopWorkerThread);
                }
                if (job instanceof FailJob) {
                    FailJob failJob = (FailJob)job;
                    return new Some((Object)failJob);
                }
                if (job instanceof TaskJob) {
                    TaskJob taskJob = (TaskJob)job;
                    Option<Job> reservedJob = this.delayOrReserve(taskJob, runnerId);
                    Option<Job> option3 = reservedJob;
                    if (None$.MODULE$.equals(option3)) continue;
                    return option3;
                }
                throw new MatchError((Object)job);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "No runner queue found for " + runnerId;
            this.logger().warn((Function0 & Serializable)() -> msg);
            throw new NotFoundException(msg, new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    private Option<Job> delayOrReserve(TaskJob<? extends Task> taskJob, String runnerId) {
        Either<Job, Job> maybeDelayed = JobSchedulerFeature$.MODULE$.strategy().schedule(taskJob);
        Either<Job, Job> either = maybeDelayed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Job delayedTaskJob = (Job)left.value();
            this.delayJob(delayedTaskJob);
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Job job = (Job)right.value();
            Option<Job> maybeReservedJob = this.reserveJob(job, runnerId);
            if (maybeReservedJob.isEmpty()) {
                JobSchedulerFeature$.MODULE$.strategy().unlock(taskJob.id(), (Option<String>)Option$.MODULE$.apply((Object)taskJob.taskId()));
            }
            return maybeReservedJob;
        }
        throw new MatchError(either);
    }

    private void delayJob(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "delaying job " + job.id());
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JobSchedulerStrategySettings jobSchedulerStrategySettings = JobSchedulerFeature$.MODULE$.strategy();
            if (jobSchedulerStrategySettings instanceof LimitParallelJobSchedulerStrategySettings) {
                this.submitBroadcasted(job);
                return;
            }
            this.replace(job);
        }).recover((PartialFunction)new Serializable(this, job){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CapabilityAwareJobQueue $outer;
            private final Job job$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().error((Function0 & Serializable)() -> "Unable to delay job " + $this.job$1, (Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.job$1 = job$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.CapabilityAwareJobQueue$$anonfun$delayJob$3 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Option<Job> reserveJob(Job possibleJob, String runnerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.reserve(possibleJob, runnerId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> "giving " + reservedJob);
            this.updateTaskStatusLine(reservedJob);
            return new Some((Object)reservedJob);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof OptimisticLockingFailureException) {
                this.logger().debug((Function0 & Serializable)() -> "Unable to reserve job " + possibleJob);
                return None$.MODULE$;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                FailJob failJob = new FailJob(possibleJob, (Option<String>)new Some((Object)throwable2.getMessage()));
                this.runnerQueues().get(LocalJobRunner$.MODULE$.getId()).offer(failJob);
                return None$.MODULE$;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    private Job reserve(Job possibleJob, String runnerId) {
        Job job = this.jobQueue.reserve(possibleJob, runnerId);
        this.removeFromJobRunnerQueues(x$1 -> x$1.id() == possibleJob.id());
        MonitorJobConfirmation x$12 = new MonitorJobConfirmation(job);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$12);
        this.actorRef().$bang((Object)x$12, x$2);
        return job;
    }

    @Override
    public boolean confirm(String runnerId, long jobId) {
        boolean result;
        block1: {
            JobConfirmed x$1 = new JobConfirmed(jobId);
            ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
            this.actorRef().$bang((Object)x$1, x$2);
            Tuple2<Object, Option<TaskJob<?>>> tuple2 = this.jobQueue.confirm(runnerId, jobId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            Option taskJob = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)result2), (Object)taskJob);
            result = tuple22._1$mcZ$sp();
            Option taskJob2 = (Option)tuple22._2();
            if (!result || !taskJob2.isDefined()) break block1;
            this.updateTaskStatusLine((Job)taskJob2.get());
        }
        return result;
    }

    private void offerToJobRunnerQueues(Job job) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeFromJobRunnerQueues(Predicate<Job> predicate) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.cancelIf(predicate);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void submit(Job job) {
        this.jobQueue.submit(job);
        this.updateTaskStatusLine(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.jobQueue.submitExisting(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitBroadcasted(Job job) {
        this.jobQueue.submitBroadcasted(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void replace(Job job) {
        this.jobQueue.replace(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void finish(long jobId) {
        Option<JobRow> maybeJobRow = this.jobQueue.finish(jobId);
        maybeJobRow.foreach((Function1 & Serializable)jobRow -> {
            CapabilityAwareJobQueue.$anonfun$finish$1(jobRow);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.jobQueue.cancelIf(predicate);
        this.removeFromJobRunnerQueues(predicate);
    }

    @Override
    public void start() {
        this.registerJobRunners();
        this.jobQueue.start();
    }

    @Override
    public void stop() {
        this.jobQueue.stop();
    }

    @Override
    public boolean isRunning() {
        return this.jobQueue.isRunning();
    }

    @Override
    public int size() {
        return this.jobQueue.size();
    }

    private void registerJobRunners() {
        List<? extends JobRunner> jobRunners = this.jobRunnerRepository().findAll();
        jobRunners.forEach(runner -> this.createRunnerQueue((JobRunner)runner));
    }

    private void createRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
        JobRunnerQueue runnerQueue = new JobRunnerQueue((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(runner.getCapabilities()).asScala().toSet(), runner.capacity(), runner.evictionTime(), runner.idleTimeToLive());
        this.runnerQueues().put(runner.getId(), runnerQueue);
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.jobQueue.localJobs().iterator()).asScala().foreach((Function1 & Serializable)job -> {
            runnerQueue.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
    }

    private void updateTaskStatusLine(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            taskJob.jobStatusLine().foreach((Function1 & Serializable)statusLine -> {
                this.releaseActorService.updateTaskStatusLine(taskJob.taskId(), statusLine);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void unReserve(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobSchedulerFeature$.MODULE$.strategy().unlock(taskJob.id(), (Option<String>)Option$.MODULE$.apply((Object)taskJob.taskId()));
        }
        Job unReservedJob = this.jobQueue.unReserve(job);
        this.updateTaskStatusLine(unReservedJob);
        this.replace(unReservedJob);
    }

    public static final /* synthetic */ void $anonfun$finish$1(JobRow jobRow) {
        JobSchedulerFeature$.MODULE$.strategy().unlock(jobRow.id(), (Option<String>)Option$.MODULE$.apply((Object)jobRow.taskId()));
    }

    public CapabilityAwareJobQueue(DefaultJobQueue jobQueue, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, SpringExtension springExtension) {
        this.jobQueue = jobQueue;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.springExtension = springExtension;
        Logging.$init$((Logging)this);
        this.runnerQueues = new ConcurrentHashMap();
        this.createRunnerQueue(LocalJobRunner$.MODULE$);
    }
}

