/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.service.TaskConcurrencyService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t%f\u0001B\u0015+\u0001MB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003U\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"AA\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005n\u0001\t\u0015\r\u0011\"\u0001o\u0011!\u0011\bA!A!\u0002\u0013y\u0007\u0002C:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011a\u0004!\u0011!Q\u0001\nUD\u0001\"\u001f\u0001\u0003\u0006\u0004%\tA\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005w\"Iq\u0010\u0001BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u0013\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\u0006\u0001\t\u0015\r\u0011\"\u0001\u0002\u000e!Q\u0011Q\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!I\u0011q\n\u0001C\u0002\u0013\u0005\u0011\u0011\u000b\u0005\t\u0003w\u0002\u0001\u0015!\u0003\u0002T!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003g\u0003A\u0011AAi\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!a=\u0001\t\u0003\t)\u0010C\u0004\u0003\n\u0001!\tAa\u0003\t\u000f\t\r\u0002\u0001\"\u0001\u0003&!9!Q\u0006\u0001\u0005\u0002\t=\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013BqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003h\u0001!\tA!\u001b\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!Q\u0010\u0001\u0005\n\t}\u0004b\u0002BD\u0001\u0011E!\u0011\u0012\u0005\b\u0005\u001f\u0003A\u0011\u0003BI\u0005E!U\r]3oI\u0016t7-_*feZL7-\u001a\u0006\u0003W1\nqa]3sm&\u001cWM\u0003\u0002.]\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003_A\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\n1aY8n\u0007\u0001\u0019R\u0001\u0001\u001b;}\u0005\u0003\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e=\u001b\u0005Q\u0013BA\u001f+\u0005I\u0011V\r\\3bg\u0016$&/Z3Ck&dG-\u001a:\u0011\u0005mz\u0014B\u0001!+\u0005q!U\r]3oI\u0016t7-_\"b]\u0012LG-\u0019;f\u0007>dG.Z2u_J\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u000bMdg\r\u000e6\u000b\u0003\u0019\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u0011\u000e\u0013q\u0001T8hO&tw-A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d2\n!B]3q_NLGo\u001c:z\u0013\t\u0001VJA\tSK2,\u0017m]3SKB|7/\u001b;pef\f!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA\u0005!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016,\u0012\u0001\u0016\t\u0003wUK!A\u0016\u0016\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0002\n!\u0003\u001d7b]&#X-\u001c*fa>\u001c\u0018\u000e^8ssV\t!\f\u0005\u0002M7&\u0011A,\u0014\u0002\u0013!2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u00180A\nqY\u0006t\u0017\n^3n%\u0016\u0004xn]5u_JL\b%\u0001\u000beKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u000b\u0002AB\u0011A*Y\u0005\u0003E6\u0013A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\u0018!\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\tKZ,g\u000e\u001e\"vgV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002jY\u00051QM^3oiNL!a\u001b5\u0003\u0011\u00153XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssV\tq\u000e\u0005\u0002Ma&\u0011\u0011/\u0014\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003=!\u0018m]6SKB|7/\u001b;pef\u0004\u0013a\u00049iCN,'+\u001a9pg&$xN]=\u0016\u0003U\u0004\"\u0001\u0014<\n\u0005]l%a\u0004)iCN,'+\u001a9pg&$xN]=\u0002!AD\u0017m]3SKB|7/\u001b;pef\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012a\u001f\t\u0003wqL!! \u0016\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\"!a\u0001\u0011\u0007m\n)!C\u0002\u0002\b)\u0012\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007%\u0001\fuCN\\7i\u001c8dkJ\u0014XM\\2z'\u0016\u0014h/[2f+\t\ty\u0001E\u0002<\u0003#I1!a\u0005+\u0005Y!\u0016m]6D_:\u001cWO\u001d:f]\u000eL8+\u001a:wS\u000e,\u0017a\u0006;bg.\u001cuN\\2veJ,gnY=TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q1\u00121DA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty\u0003\u0005\u0002<\u0001!)\u0011*\u0006a\u0001\u0017\")!+\u0006a\u0001)\")\u0001,\u0006a\u00015\")a,\u0006a\u0001A\")A-\u0006a\u0001M\")Q.\u0006a\u0001_\")1/\u0006a\u0001k\")\u00110\u0006a\u0001w\"1q0\u0006a\u0001\u0003\u0007Aq!a\u0003\u0016\u0001\u0004\ty\u0001K\u0002\u0016\u0003g\u0001B!!\u000e\u0002L5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0006b]:|G/\u0019;j_:TA!!\u0010\u0002@\u00059a-Y2u_JL(\u0002BA!\u0003\u0007\nQAY3b]NTA!!\u0012\u0002H\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002J\u0005\u0019qN]4\n\t\u00055\u0013q\u0007\u0002\n\u0003V$xn^5sK\u0012\f\u0001$Y2uSZ,G)\u001a9f]\u0012,gnY=Ti\u0006$Xo]3t+\t\t\u0019\u0006\u0005\u0004\u0002V\u0005\u0015\u00141\u000e\b\u0005\u0003/\n\tG\u0004\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFM\u0001\u0007yI|w\u000e\u001e \n\u0003]J1!a\u00197\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\t\u00191+Z9\u000b\u0007\u0005\rd\u0007\u0005\u0003\u0002n\u0005Ud\u0002BA8\u0003c\u00022!!\u00177\u0013\r\t\u0019HN\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0014\u0011\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Md'A\rbGRLg/\u001a#fa\u0016tG-\u001a8dsN#\u0018\r^;tKN\u0004\u0013AB2sK\u0006$X\r\u0006\u0004\u0002\u0002\u00065\u0015q\u0013\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\u0017\u0002\r\u0011|W.Y5o\u0013\u0011\tY)!\"\u0003\u0015\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010C\u0004\u0002\u0010b\u0001\r!!%\u0002\t\u001d\fG/\u001a\t\u0005\u0003\u0007\u000b\u0019*\u0003\u0003\u0002\u0016\u0006\u0015%\u0001C$bi\u0016$\u0016m]6\t\u000f\u0005e\u0005\u00041\u0001\u0002l\u0005\u0011B/\u0019:hKRLEm\u0014:WCJL\u0017M\u00197fQ\rA\u0012Q\u0014\t\u0005\u0003?\u000by+\u0004\u0002\u0002\"*!\u0011\u0011HAR\u0015\u0011\t)+a*\u0002\t\r|'/\u001a\u0006\u0005\u0003S\u000bY+\u0001\u0006nS\u000e\u0014x.\\3uKJT!!!,\u0002\u0005%|\u0017\u0002BAY\u0003C\u0013Q\u0001V5nK\u0012\fA\"\u001e9eCR,G+\u0019:hKR$\u0002\"!!\u00028\u0006m\u0016Q\u0018\u0005\b\u0003sK\u0002\u0019AA6\u00031!W\r]3oI\u0016t7-_%e\u0011\u001d\tI*\u0007a\u0001\u0003WBq!a0\u001a\u0001\u0004\t\t-\u0001\u0006n_\u0012Lg-[3e\u0003R\u0004B!a1\u0002N6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fI-\u0001\u0003uS6,'\u0002BAf\u0003\u000f\nAA[8eC&!\u0011qZAc\u0005!!\u0015\r^3US6,GCBAA\u0003'\f)\u000eC\u0004\u0002:j\u0001\r!a\u001b\t\u000f\u0005e%\u00041\u0001\u0002l!\u001a!$!(\u0002\r\u0011,G.\u001a;f)\u0019\ti.a9\u0002nB\u0019Q'a8\n\u0007\u0005\u0005hG\u0001\u0003V]&$\bbBAs7\u0001\u0007\u0011q]\u0001\be\u0016dW-Y:f!\u0011\t\u0019)!;\n\t\u0005-\u0018Q\u0011\u0002\b%\u0016dW-Y:f\u0011\u001d\tyo\u0007a\u0001\u0003W\n!!\u001b3)\u0007m\ti*A\u000bhKR\u001cu.\u001c9mKR\f'\r\\3HCR,\u0017\nZ:\u0015\t\u0005M\u0013q\u001f\u0005\b\u0003sd\u0002\u0019AA~\u0003\u001d!\u0018M]4fiN\u0004b!!\u001c\u0002~\n\u0005\u0011\u0002BA\u0000\u0003s\u00121aU3u!\u0011\t\u0019Ia\u0001\n\t\t\u0015\u0011Q\u0011\u0002\t!2\fg.\u0013;f[\"\u001aA$!(\u00023\u0019Lg\u000eZ!di&4X-\u00138d_6LgnZ$bi\u0016LEm\u001d\u000b\u0005\u0005\u001b\u0011i\u0002\u0005\u0004\u0003\u0010\te\u00111N\u0007\u0003\u0005#QAAa\u0005\u0003\u0016\u0005!Q\u000f^5m\u0015\t\u00119\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\u000e\u0005#\u0011A\u0001T5ti\"9!qD\u000fA\u0002\u0005-\u0014!\u0003:fY\u0016\f7/Z%eQ\ri\u0012QT\u0001\u001fM&tG-Q2uSZ,\u0017J\\2p[&tw\rR3qK:$WM\\2jKN$BAa\n\u0003*A1\u0011QKA3\u0003\u0003CqAa\u000b\u001f\u0001\u0004\tY'\u0001\u0005qCJ,g\u000e^%e\u0003I9W\r\u001e$bS2\f'\r\\3HCR,\u0017\nZ:\u0015\t\u0005M#\u0011\u0007\u0005\b\u0005gy\u0002\u0019AA~\u00039\t'm\u001c:uK\u0012$\u0016M]4fiND3aHAO\u0003m1\u0017N\u001c3BGRLg/Z(vi\u001e|\u0017N\\4UCJ<W\r^%egR!!Q\u0002B\u001e\u0011\u001d\u0011y\u0002\ta\u0001\u0003WB3\u0001IAO\u0003e1\u0017N\u001c3BGRLg/Z(vi\u001e|\u0017N\\4UCJ<W\r^:\u0015\t\t\r#Q\t\t\u0007\u0003+\n)G!\u0001\t\u000f\t}\u0011\u00051\u0001\u0002l\u0005qq-\u001a;SK2,\u0017m]3Ue\u0016,G\u0003\u0002B&\u0005/\u0002BA!\u0014\u0003T5\u0011!q\n\u0006\u0004\u0005#b\u0013!\u0002<jK^\u001c\u0018\u0002\u0002B+\u0005\u001f\u00121BU3mK\u0006\u001cX\r\u0016:fK\"9!q\u0004\u0012A\u0002\u0005-\u0004f\u0001\u0012\u0002\u001e\u0006\u0019\u0012M]2iSZ,G)\u001a9f]\u0012,gnY5fgR1\u0011Q\u001cB0\u0005CBqAa\b$\u0001\u0004\tY\u0007C\u0004\u0003d\r\u0002\r!a\u0015\u0002\u001b\u0011,\u0007/\u001a8eK:\u001c\u00170\u00133tQ\r\u0019\u0013QT\u0001\u001fM&tG\rR3qK:$WM\\2z)\u0006\u0014x-\u001a;CsR\u000b'oZ3u\u0013\u0012$BAa\u001b\u0003rA\u00191H!\u001c\n\u0007\t=$FA\u0006JI\u0006sGm\u0015;biV\u001c\bb\u0002B:I\u0001\u0007\u00111N\u0001\ti\u0006\u0014x-\u001a;JI\"\u001aA%!(\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003BA6\u0005wBqAa\u001d&\u0001\u0004\tY'\u0001\fva\u0012\fG/\u001a+be\u001e,G\u000fR3qK:$WM\\2z)!\t\tI!!\u0003\u0004\n\u0015\u0005bBA]M\u0001\u0007\u00111\u000e\u0005\b\u000333\u0003\u0019AA6\u0011\u001d\tyI\na\u0001\u0003#\u000bQDZ5oI&s\u0007K]8he\u0016\u001c8/\u00138d_6LgnZ$bi\u0016LEm\u001d\u000b\u0005\u0003'\u0012Y\tC\u0004\u0003\u000e\u001e\u0002\r!a\u0015\u0002\u0013Q\f'oZ3u\u0013\u0012\u001c\u0018AC5t)\u0016l\u0007\u000f\\1uKR!!1\u0013BM!\r)$QS\u0005\u0004\u0005/3$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003sC\u0003\u0019AA6Q\r\u0001!Q\u0014\t\u0005\u0005?\u0013)+\u0004\u0002\u0003\"*!!1UA\"\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005O\u0013\tKA\u0004TKJ4\u0018nY3")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final EventBus eventBus;
    private final TaskRepository taskRepository;
    private final PhaseRepository phaseRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final TaskConcurrencyService taskConcurrencyService;
    private final scala.collection.immutable.Seq<String> activeDependencyStatuses;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public java.util.List<Dependency> findByReleaseId(String releaseId) {
        return DependencyCandidateCollector.findByReleaseId$(this, releaseId);
    }

    @Override
    @Timed
    public java.util.List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public scala.collection.immutable.Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, scala.collection.immutable.Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public TaskConcurrencyService taskConcurrencyService() {
        return this.taskConcurrencyService;
    }

    public scala.collection.immutable.Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't add a dependency to a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return dependency;
    }

    public Dependency updateTarget(String dependencyId, String targetIdOrVariable, DateTime modifiedAt) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        this.taskConcurrencyService().checkConcurrentModification((Task)gate, modifiedAt);
        return this.updateTargetDependency(dependencyId, targetIdOrVariable, gate);
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        return this.updateTargetDependency(dependencyId, targetIdOrVariable, gate);
    }

    @Timed
    public void delete(Release release, String id) {
        Option maybeDependency = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllGates()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.getDependencies()).asScala())).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$delete$2(id, x$3)));
        Dependency dependency = (Dependency)maybeDependency.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [" + id + "] not found", new Object[0]);
        });
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public scala.collection.immutable.Seq<String> getCompletableGateIds(Set<PlanItem> targets) {
        scala.collection.immutable.Seq doneTargetIds = ((IterableOnceOps)((IterableOps)targets.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDone()))).map((Function1 & Serializable)x$5 -> x$5.getId())).toSeq();
        this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds doneTargetIds: " + doneTargetIds.mkString(", "));
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)doneTargetIds).map((Function1 & Serializable)id -> {
            GateTask item = (GateTask)this.taskRepository().findById((String)id);
            this.logger().trace((Function0 & Serializable)() -> "getCompletableGateIds item " + item.getId() + ": hasConditions = " + item.hasConditions() + ", hasDependencies = " + item.hasDependencies() + ", isOpen = " + item.isOpen() + ", status = " + item.getStatus());
            return item;
        })).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isCompletable()))).map((Function1 & Serializable)x$7 -> x$7.getId());
    }

    @Timed
    public java.util.List<String> findActiveIncomingGateIds(String releaseId) {
        Seq seq;
        if (this.releaseRepository().exists(releaseId)) {
            seq = (Seq)((SeqOps)this.findActiveIncomingDependencies(releaseId).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Release " + releaseId + " not found. It is either archived, or does not exist. Returning no dependencies");
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(seq).asJava();
    }

    public scala.collection.immutable.Seq<Dependency> findActiveIncomingDependencies(String parentId) {
        return this.dependencyRepository().findAllIncomingDependencies((scala.collection.immutable.Seq<String>)new .colon.colon((Object)parentId, (List)Nil$.MODULE$), this.activeDependencyStatuses(), true, false);
    }

    @Timed
    public scala.collection.immutable.Seq<String> getFailableGateIds(Set<PlanItem> abortedTargets) {
        return this.findInProgressIncomingGateIds((scala.collection.immutable.Seq<String>)((IterableOnceOps)abortedTargets.map((Function1 & Serializable)x$8 -> x$8.getId())).toSeq());
    }

    @Timed
    public java.util.List<String> findActiveOutgoingTargetIds(String releaseId) {
        java.util.List targetIds = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.findActiveOutgoingTargets(releaseId).map((Function1 & Serializable)x$9 -> x$9.getId())).asJava();
        return targetIds;
    }

    private scala.collection.immutable.Seq<PlanItem> findActiveOutgoingTargets(String releaseId) {
        java.util.List<Dependency> dependencies = this.findByReleaseId(releaseId);
        scala.collection.immutable.Seq targets = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dependencies).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Dependency, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).hasResolvedTarget() && !A1.isDone()) {
                    return (B1)A1.getTarget();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Dependency x1) {
                Dependency dependency;
                Dependency dependency2 = x1;
                return dependency2 != null && (dependency = dependency2).hasResolvedTarget() && !dependency.isDone();
            }
        })).toSeq();
        return targets;
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        if (this.archivingService().exists(releaseId)) {
            return new ReleaseTree();
        }
        Map dependentReleases = (Map)Map$.MODULE$.empty();
        Release release = this.releaseRepository().findById(releaseId);
        this.toTreeItem(releaseId, (Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
        ReleaseTree tree = new ReleaseTree();
        tree.releaseId_$eq(releaseId);
        tree.dependentReleases_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)dependentReleases.values().toList()).asJava());
        return tree;
    }

    @Timed
    public void archiveDependencies(String releaseId, scala.collection.immutable.Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(referencingRelease.getAllGates()).asScala().flatMap((Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.ListHasAsScala(x$10.getDependencies()).asScala())).filter((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable)x$11 -> {
            x$11.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (scala.collection.immutable.Seq<Dependency>)dependenciesToArchive.toSeq());
    }

    @Timed
    public IdAndStatus findDependencyTargetByTargetId(String targetId) {
        return new IdAndStatus(targetId, this.getStatus(targetId));
    }

    private String getStatus(String targetId) {
        Option option;
        Option option2;
        Option option3;
        String string = targetId;
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.releaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getRelease(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Release [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.phaseRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getPhase(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Phase [" + targetId + "] not found", new Object[0]);
            });
        }
        if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> this.taskRepository().getStatus(targetId).toString()).recover((PartialFunction)new Serializable(this, targetId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ DependencyService $outer;
                private final String targetId$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 != null) {
                        return (B1)this.$outer.archivingService().getTask(this.targetId$1).getStatus().toString();
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Throwable x3) {
                    Throwable throwable = x3;
                    return throwable != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetId$1 = targetId$1;
                }
            }).getOrElse((Function0 & Serializable)() -> {
                throw new LogFriendlyNotFoundException("Task [" + targetId + "] not found", new Object[0]);
            });
        }
        throw new NotFoundException("Target is not plan item, targetId= " + targetId, new Object[0]);
    }

    private Dependency updateTargetDependency(String dependencyId, String targetIdOrVariable, GateTask gate) {
        Checks.checkArgument((boolean)gate.isUpdatable(), (String)"You can't edit a dependency on a finished gate", (Object[])new Object[0]);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        this.taskConcurrencyService().updateLastModifiedDetails((Task)gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    public scala.collection.immutable.Seq<String> findInProgressIncomingGateIds(scala.collection.immutable.Seq<String> targetIds) {
        return (scala.collection.immutable.Seq)((SeqOps)this.dependencyRepository().findAllIncomingDependencies(targetIds, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)TaskStatus.IN_PROGRESS.name(), (List)Nil$.MODULE$), false, this.dependencyRepository().findAllIncomingDependencies$default$4()).map((Function1 & Serializable)dep -> Ids.getParentId((String)dep.getId()))).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(String id$1, Dependency x$3) {
        String string = x$3.getId();
        String string2 = Ids.normalizeId((String)id$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, EventBus eventBus, TaskRepository taskRepository, PhaseRepository phaseRepository, CiIdService ciIdService, ArchivingService archivingService, TaskConcurrencyService taskConcurrencyService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.phaseRepository = phaseRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        this.taskConcurrencyService = taskConcurrencyService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).$colon$plus((Object)TaskStatus.PLANNED)).map((Function1 & Serializable)x$1 -> x$1.name());
    }
}

