/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.FacetConfiguredFacetsCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FacetUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseVariableRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FacetConfigurationService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Collections;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\r\u001a\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003u\u0001\u0011\u0005Q\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!!)\u0001\t\u0003\t\u0019\u000bC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u000511\u0015mY3u'\u0016\u0014h/[2f\u0015\tQ2$A\u0004tKJ4\u0018nY3\u000b\u0005qi\u0012!\u0003=me\u0016dW-Y:f\u0015\tqr$A\u0005yK\nL\u0017\r\\1cg*\t\u0001%A\u0002d_6\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0013\u0001C4sSjTH.\u001a3\n\u0005AZ#a\u0002'pO\u001eLgnZ\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000f\u0005\u00024m5\tAG\u0003\u000267\u0005Q!/\u001a9pg&$xN]=\n\u0005]\"$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\fa\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00024u%\u00111\b\u000e\u0002\u000f)\u0006\u001c8NU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001 B\u001b\u0005y$B\u0001!\u001c\u0003\u0019)g/\u001a8ug&\u0011!i\u0010\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\t)e)D\u0001\u001a\u0013\t9\u0015D\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005MR\u0015BA&5\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002F\u001d&\u0011q*\u0007\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\nwCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\bCA\u001aS\u0013\t\u0019FGA\rSK2,\u0017m]3WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\u0018a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007C\u0001,Z\u001b\u00059&B\u0001-\u001c\u0003\u0019\t7\r^8sg&\u0011!l\u0016\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0012i\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0007CA#^\u0013\tq\u0016DA\tUCN\\\u0017iY2fgN\u001cVM\u001d<jG\u0016\f\u0011DZ1dKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKB\u0011Q)Y\u0005\u0003Ef\u0011\u0011DR1dKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\"\"!\u0002\u001a:t!\t)\u0007/D\u0001g\u0015\t9\u0007.\u0001\u0006b]:|G/\u0019;j_:T!!\u001b6\u0002\u000f\u0019\f7\r^8ss*\u00111\u000e\\\u0001\u0006E\u0016\fgn\u001d\u0006\u0003[:\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002_\u0006\u0019qN]4\n\u0005E4'!C!vi><\u0018N]3e\u0003!\u0011X-];je\u0016$\u0017$\u0001\u0001\u0002\rqJg.\u001b;?)11x\u000f_={wrlhp`A\u0001!\t)\u0005\u0001C\u00032\u0017\u0001\u0007!\u0007C\u00039\u0017\u0001\u0007\u0011\bC\u0003=\u0017\u0001\u0007Q\bC\u0003D\u0017\u0001\u0007A\tC\u0003I\u0017\u0001\u0007\u0011\nC\u0003M\u0017\u0001\u0007Q\nC\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003U\u0017\u0001\u0007Q\u000bC\u0003\\\u0017\u0001\u0007A\fC\u0003`\u0017\u0001\u0007\u0001\rK\u0003\u0002\u0002\u0011\u00148\u000f\u000b\u0002\fI\u0006\u0019q-\u001a;\u0015\t\u0005-\u00111\u0004\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u00151\u0017mY3u\u0015\r\t)bG\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u0011q\u0002\u0002\u0006\r\u0006\u001cW\r\u001e\u0005\b\u0003;a\u0001\u0019AA\u0010\u0003\u001d1\u0017mY3u\u0013\u0012\u0004B!!\t\u000209!\u00111EA\u0016!\r\t)#J\u0007\u0003\u0003OQ1!!\u000b\"\u0003\u0019a$o\\8u}%\u0019\u0011QF\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t$a\r\u0003\rM#(/\u001b8h\u0015\r\ti#\n\u0015\u0004\u0019\u0005]\u0002\u0003BA\u001d\u0003\u0013j!!a\u000f\u000b\u0007\u001d\fiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001B2pe\u0016TA!a\u0011\u0002F\u0005QQ.[2s_6,G/\u001a:\u000b\u0005\u0005\u001d\u0013AA5p\u0013\u0011\tY%a\u000f\u0003\u000bQKW.\u001a3\u0002-\u0005$G\rV1tWJ+\u0007o\u001c:uS:<'+Z2pe\u0012$b!!\u0015\u0002h\u0005-\u0004CBA*\u0003;\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003\u0011)H/\u001b7\u000b\u0005\u0005m\u0013\u0001\u00026bm\u0006LA!a\u0018\u0002V\t!A*[:u!\u0011\ti!a\u0019\n\t\u0005\u0015\u0014q\u0002\u0002\u0014)\u0006\u001c8NU3q_J$\u0018N\\4SK\u000e|'\u000f\u001a\u0005\b\u0003Sj\u0001\u0019AA1\u0003\u0019\u0011XmY8sI\"9\u0011QN\u0007A\u0002\u0005=\u0014aE1qa2LH+Y:l\u0003R$(/\u001b2vi\u0016\u001c\bc\u0001\u0013\u0002r%\u0019\u00111O\u0013\u0003\u000f\t{w\u000e\\3b]\"\u001aQ\"a\u000e\u0002\r\r\u0014X-\u0019;f)\u0011\tY!a\u001f\t\u000f\u0005Ea\u00021\u0001\u0002\f!\u001aa\"a\u000e\u00027\r\u0014X-\u0019;f\u0003B\u0004H._5oO\u000e{gNZ5hkJ\fG/[8o)\u0019\t\t&a!\u0002\u0006\"9\u0011\u0011C\bA\u0002\u0005\u0005\u0004bBAD\u001f\u0001\u0007\u0011qN\u0001\u0013GJ,\u0017\r^3V]\u000e|gNZ5hkJ,G\rK\u0002\u0010\u0003o\ta\u0001Z3mKR,G\u0003BAH\u0003+\u00032\u0001JAI\u0013\r\t\u0019*\n\u0002\u0005+:LG\u000fC\u0004\u0002\u001eA\u0001\r!a\b)\u0007A\t9$\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003\u0017\ti\nC\u0004\u0002\u0012E\u0001\r!a\u0003)\u0007E\t9$A\u0006jg&kW.\u001e;bE2,G\u0003BA8\u0003KCq!!\u0005\u0013\u0001\u0004\tY\u0001K\u0002\u0013\u0003o\taa]3be\u000eDG\u0003BAW\u0003_\u0003b!a\u0015\u0002^\u0005-\u0001bBAY'\u0001\u0007\u00111W\u0001\bM&dG/\u001a:t!\u0011\t),a1\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bQAZ8s[NTA!!0\u0002@\u0006\u0011a/\r\u0006\u0004\u0003\u0003\\\u0012aA1qS&!\u0011QYA\\\u000511\u0015mY3u\r&dG/\u001a:tQ\r\u0019\u0012qG\u0001\u0007KbL7\u000f^:\u0015\t\u0005=\u0014Q\u001a\u0005\b\u0003;!\u0002\u0019AA\u0010Q\r!\u0012qG\u0001\u0013GJ,\u0017\r^3OK^4\u0016M]5bE2,7\u000f\u0006\u0004\u0002\u0010\u0006U\u0017\u0011\u001d\u0005\b\u0003/,\u0002\u0019AAm\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a7\u0002^6\u0011\u00111C\u0005\u0005\u0003?\f\u0019BA\u0004SK2,\u0017m]3\t\u000f\u0005EQ\u00031\u0001\u0002\f\u0005iq-\u001a;GC\u000e,G\u000fV=qKN$B!a:\u0002\u0000B1\u00111KA/\u0003S\u0004B!a;\u0002|6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0A\u0004sK\u001adWm\u0019;\u000b\t\u0005\u0005\u00171\u001f\u0006\u0005\u0003k\f90\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0003sl\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\u0005u\u0018Q\u001e\u0002\u000b\t\u0016\u001c8M]5qi>\u0014\bb\u0002B\u0001-\u0001\u0007\u0011qD\u0001\tE\u0006\u001cX\rV=qK\"\u001aa#a\u000e\u0002\u0011Y\fG.\u001b3bi\u0016$B!a$\u0003\n!9\u0011\u0011C\fA\u0002\u0005-\u0001f\u0001\u0001\u0003\u000eA!!q\u0002B\u000b\u001b\t\u0011\tBC\u0002\u0003\u00141\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119B!\u0005\u0003\u000fM+'O^5dK\u0002")
public class FacetService
implements Logging {
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final ReleaseActorService releaseActorService;
    private final TaskAccessService taskAccessService;
    @Autowired(required=false)
    private final FacetConfigurationService facetConfigurationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FacetService facetService = this;
        synchronized (facetService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Facet get(String facetId) {
        return this.facetRepositoryDispatcher.get(facetId, this.facetRepositoryDispatcher.get$default$2());
    }

    @Timed
    public java.util.List<TaskReportingRecord> addTaskReportingRecord(TaskReportingRecord record, boolean applyTaskAttributes) {
        if (applyTaskAttributes) {
            return this.createApplyingConfiguration(record, true);
        }
        return Collections.singletonList((TaskReportingRecord)this.create((Facet)record));
    }

    @Timed
    public Facet create(Facet facet) {
        this.validate(facet);
        Object task = this.taskRepository.findById(facet.getTargetId(), ResolveOptions$.MODULE$.WITH_DECORATORS());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        facet.setId(Ids.getName((String)this.ciIdService.getUniqueId(Type.valueOf(Facet.class), "")));
        Facet createdFacet = this.facetRepositoryDispatcher.create(facet);
        this.createNewVariables(task.getRelease(), createdFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetCreatedEvent(createdFacet));
        return createdFacet;
    }

    @Timed
    public java.util.List<TaskReportingRecord> createApplyingConfiguration(TaskReportingRecord facet2, boolean createUnconfigured) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = this.facetConfigurationService != null ? this.facetConfigurationService.configureFacet(facet2) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)new .colon.colon((Object)facet2, (List)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean hasConfiguration = tuple2._1$mcZ$sp();
        scala.collection.immutable.Seq facets = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasConfiguration), (Object)facets);
        boolean hasConfiguration2 = tuple23._1$mcZ$sp();
        scala.collection.immutable.Seq facets2 = (scala.collection.immutable.Seq)tuple23._2();
        if (createUnconfigured || hasConfiguration2) {
            facets2.foreach((Function1 & Serializable)facet -> this.create((Facet)facet));
            this.eventBus.publish((XLReleaseEvent)new FacetConfiguredFacetsCreatedEvent(facet2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets2).asJava(), hasConfiguration2));
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets2).asJava();
        }
        return Collections.emptyList();
    }

    @Timed
    public void delete(String facetId) {
        Facet facet = this.facetRepositoryDispatcher.get(facetId, this.facetRepositoryDispatcher.get$default$2());
        TaskBasicData taskBasicData = this.taskRepository.findTaskBasicData(facet.getTargetId());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTaskType(taskBasicData.taskType());
        this.facetRepositoryDispatcher.delete(facetId, this.facetRepositoryDispatcher.delete$default$2());
        this.eventBus.publish((XLReleaseEvent)new FacetDeletedEvent(facet));
    }

    @Timed
    public Facet update(Facet facet) {
        this.validate(facet);
        Object task = this.taskRepository.findById(facet.getTargetId(), ResolveOptions$.MODULE$.WITH_DECORATORS());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        Facet originalFacet = this.facetRepositoryDispatcher.get(facet.getId(), this.facetRepositoryDispatcher.get$default$2());
        Facet updatedFacet = this.facetRepositoryDispatcher.update(facet);
        this.createNewVariables(task.getRelease(), updatedFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetUpdatedEvent(originalFacet, updatedFacet));
        return updatedFacet;
    }

    @Timed
    public boolean isImmutable(Facet facet) {
        return facet.getType().instanceOf(Type.valueOf(TaskReportingRecord.class));
    }

    @Timed
    public java.util.List<Facet> search(FacetFilters filters) {
        String containerId;
        filters.setTypes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Option$.MODULE$.apply((Object)filters.getTypes()).map((Function1 & Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().flatMap((Function1 & Serializable)ciType -> TypeHelper$.MODULE$.getAllSubtypesOf(ciType))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).asJava());
        String string = containerId = filters.getParentId() != null ? filters.getParentId() : filters.getTargetId();
        if (this.archivingService.exists(Ids.releaseIdFrom((String)containerId))) {
            this.logger().debug((Function0 & Serializable)() -> "Search in ARCHIVE for " + filters.getParentId() + "/" + filters.getTargetId() + "/" + filters.getTypes());
            return CollectionConverters$.MODULE$.SeqHasAsJava(((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.archiveRepository())).search(filters)).asJava();
        }
        this.logger().debug((Function0 & Serializable)() -> "Search in LIVE for " + filters.getParentId() + "/" + filters.getTargetId() + "/" + filters.getTypes());
        return CollectionConverters$.MODULE$.SeqHasAsJava(((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).search(filters)).asJava();
    }

    @Timed
    public boolean exists(String facetId) {
        return this.facetRepositoryDispatcher.exists(facetId, this.facetRepositoryDispatcher.exists$default$2());
    }

    private void createNewVariables(Release release, Facet facet) {
        Buffer newVariables = CollectionConverters$.MODULE$.ListHasAsScala(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)facet, this.ciIdService)).asScala();
        if (newVariables.nonEmpty()) {
            newVariables.foreach((Function1 & Serializable)v -> $this.releaseActorService.createVariable((Variable)v, release.getId()));
            return;
        }
    }

    @Timed
    public java.util.List<Descriptor> getFacetTypes(String baseType) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf((String)baseType))).asScala().map((Function1 & Serializable)x$3 -> x$3.getDescriptor())).filter((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$2(desc)))).filterNot((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$3(desc)))).toList().sortBy((Function1 & Serializable)x$4 -> x$4.getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    public void validate(Facet facet) {
        FacetScope facetScope = facet.getScope();
        if (FacetScope.TASK.equals(facetScope)) {
            Checks.checkArgument((boolean)Ids.isTaskId((String)facet.getTargetId()), (String)"Target ID is not a valid task ID.", (Object[])new Object[0]);
            Checks.checkArgument((boolean)this.taskRepository.exists(facet.getTargetId()), (String)("Task with the ID '" + facet.getTargetId() + "' does not exist or has been archived."), (Object[])new Object[0]);
            return;
        }
        throw new IllegalArgumentException("Target type " + facet.getScope() + " is not supported.");
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$2(Descriptor desc) {
        return !desc.isVirtual();
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$3(Descriptor desc) {
        return desc.getType().instanceOf(Type.valueOf(TaskReportingRecord.class));
    }

    @Autowired
    public FacetService(FacetRepositoryDispatcher facetRepositoryDispatcher, TaskRepository taskRepository, XLReleaseEventBus eventBus, ArchivingService archivingService, ReleaseRepository releaseRepository, CiIdService ciIdService, ReleaseVariableRepository variableRepository, ReleaseActorService releaseActorService, TaskAccessService taskAccessService, @Autowired(required=false) FacetConfigurationService facetConfigurationService) {
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.facetConfigurationService = facetConfigurationService;
        Logging.$init$((Logging)this);
    }
}

