/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService$FolderAndEvents$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011\re\u0001\u0002*T\u0001qC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005g\"Aq\u000f\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011%y\bA!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u001a\u0001\t\u0005\t\u0015!\u0003\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002\"CA+\u0001\t\u0007I\u0011AA,\u0011!\tI\u0007\u0001Q\u0001\n\u0005e\u0003\"CA6\u0001\t\u0007I\u0011AA,\u0011!\ti\u0007\u0001Q\u0001\n\u0005e\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!1\u0001\t\u0003\t\u0019\rC\u0005\u0002d\u0002\t\n\u0011\"\u0001\u0002f\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\b\"\u0003B\u0004\u0001E\u0005I\u0011AAs\u0011%\u0011I\u0001AI\u0001\n\u0003\u0011Y\u0001C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u0013\t\u0005\u0002!%A\u0005\u0002\t\r\u0002b\u0002B\u0014\u0001\u0011\u0005!\u0011\u0006\u0005\n\u0005\u001b\u0002\u0011\u0013!C\u0001\u0005\u0017A\u0011Ba\u0014\u0001#\u0003%\tAa\u0003\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!Q\f\u0001\u0005\u0002\t}\u0003b\u0002B5\u0001\u0011\u0005!1\u000e\u0005\n\u0005\u0013\u0003\u0011\u0013!C\u0001\u0005\u0017AqAa#\u0001\t\u0003\u0011i\tC\u0005\u0003:\u0002\t\n\u0011\"\u0001\u0003<\"9!q\u0018\u0001\u0005\u0002\t\u0005\u0007\"\u0003Bh\u0001E\u0005I\u0011\u0001B\u0006\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'DqA!5\u0001\t\u0003\u0011Y\u000eC\u0004\u0003h\u0002!IA!;\t\u000f\t=\b\u0001\"\u0003\u0003r\"91q\u0001\u0001\u0005\n\r%aABB\u0006\u0001\u0001\u001bi\u0001\u0003\u0006\u0002L*\u0012)\u001a!C\u0001\u0007OA!b!\u000b+\u0005#\u0005\u000b\u0011BAc\u0011)\tiC\u000bBK\u0002\u0013\u000511\u0006\u0005\u000b\u0007{Q#\u0011#Q\u0001\n\r5\u0002bBA\u001eU\u0011\u00051q\b\u0005\n\u0007\u0013R\u0013\u0011!C\u0001\u0007\u0017B\u0011b!\u0015+#\u0003%\taa\u0015\t\u0013\r]#&%A\u0005\u0002\re\u0003\"CB/U\u0005\u0005I\u0011IA,\u0011%\u0019yFKA\u0001\n\u0003\u0019\t\u0007C\u0005\u0004d)\n\t\u0011\"\u0001\u0004f!I1\u0011\u000f\u0016\u0002\u0002\u0013\u000531\u000f\u0005\n\u0007\u0003S\u0013\u0011!C\u0001\u0007\u0007C\u0011ba\"+\u0003\u0003%\te!#\t\u0013\r5%&!A\u0005B\r=\u0005\"CBIU\u0005\u0005I\u0011IBJ\u0011%\u0019)JKA\u0001\n\u0003\u001a9jB\u0005\u0004\u001c\u0002\t\t\u0011#\u0001\u0004\u001e\u001aI11\u0002\u0001\u0002\u0002#\u00051q\u0014\u0005\b\u0003wiD\u0011AB[\u0011%\u0019\t*PA\u0001\n\u000b\u001a\u0019\nC\u0005\u00048v\n\t\u0011\"!\u0004:\"I1qX\u001f\u0012\u0002\u0013\u00051\u0011\f\u0005\n\u0007\u0003l\u0014\u0011!CA\u0007\u0007D\u0011b!6>#\u0003%\ta!\u0017\t\u000f\r]\u0007\u0001\"\u0001\u0004Z\"91\u0011\u001d\u0001\u0005\u0002\r\r\bbBBu\u0001\u0011%11\u001e\u0005\b\u0007k\u0004A\u0011BB|\u0011\u001d!I\u0001\u0001C\u0005\t\u0017Aq\u0001\"\u0005\u0001\t\u0013!\u0019\u0002C\u0004\u0005\u001c\u0001!I\u0001\"\b\t\u000f\u0011\u0005\u0002\u0001\"\u0003\u0005$!9AQ\u0006\u0001\u0005\u0002\u0011=\u0002b\u0002C%\u0001\u0011%A1\n\u0005\b\t3\u0002A\u0011\u0002C.\u0011\u001d!y\u0007\u0001C\u0005\tcBq\u0001b\u001e\u0001\t\u0013!I\bC\u0004\u0005~\u0001!I\u0001b \u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0015\t!V+A\u0004tKJ4\u0018nY3\u000b\u0005Y;\u0016!\u0003=me\u0016dW-Y:f\u0015\tA\u0016,A\u0005yK\nL\u0017\r\\1cg*\t!,A\u0002d_6\u001c\u0001aE\u0002\u0001;\u000e\u0004\"AX1\u000e\u0003}S\u0011\u0001Y\u0001\u0006g\u000e\fG.Y\u0005\u0003E~\u0013a!\u00118z%\u00164\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0017\u0001C4sSjTH.\u001a3\n\u0005),'a\u0002'pO\u001eLgnZ\u0001\bM>dG-\u001a:t!\ti\u0007/D\u0001o\u0015\tyW+\u0001\u0006sKB|7/\u001b;pefL!!\u001d8\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018a\u0003;fC6\u001cVM\u001d<jG\u0016\u0004\"\u0001^;\u000e\u0003MK!A^*\u0003\u0017Q+\u0017-\\*feZL7-Z\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bCA7z\u0013\tQhNA\tSK2,\u0017m]3SKB|7/\u001b;pef\f1\u0002^1tWN+'O^5dKB\u0011A/`\u0005\u0003}N\u00131\u0002V1tWN+'O^5dK\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0004[\u0006\r\u0011bAA\u0003]\n92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\rE\u0002u\u0003\u0017I1!!\u0004T\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f!\r!\u00181C\u0005\u0004\u0003+\u0019&\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u0006qKJl\u0017n]:j_:\u001c\b\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}Q+\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\u0019#!\b\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0005fm\u0016tGOQ;t!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017+\u00061QM^3oiNLA!!\r\u0002,\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007c\u0001;\u00028%\u0019\u0011\u0011H*\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\f\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*!\t!\b\u0001C\u0003l\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u00071\u000fC\u0003x\u0017\u0001\u0007\u0001\u0010C\u0003|\u0017\u0001\u0007A\u0010\u0003\u0004\u0000\u0017\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u000fY\u0001\u0019AA\u0005\u0011\u001d\tya\u0003a\u0001\u0003#Aq!a\u0006\f\u0001\u0004\tI\u0002C\u0004\u0002&-\u0001\r!a\n\t\u000f\u0005M2\u00021\u0001\u00026\u0005)1\u000bT!T\u0011V\u0011\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002^\t11\u000b\u001e:j]\u001e\faa\u0015'B'\"\u0003\u0013\u0001D*M\u0003NCuLR(M\t\u0016\u0013\u0016!D*M\u0003NCuLR(M\t\u0016\u0013\u0006%A\tdQ\u0016\u001c7NR8mI\u0016\u0014X\t_5tiN$B!a\u001d\u0002zA\u0019a,!\u001e\n\u0007\u0005]tL\u0001\u0003V]&$\bbBA>!\u0001\u0007\u0011QP\u0001\tM>dG-\u001a:JIB!\u0011qPAG\u001d\u0011\t\t)!#\u0011\u0007\u0005\ru,\u0004\u0002\u0002\u0006*\u0019\u0011qQ.\u0002\rq\u0012xn\u001c;?\u0013\r\tYiX\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0014q\u0012\u0006\u0004\u0003\u0017{\u0006f\u0001\t\u0002\u0014B!\u0011QSAT\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015AC1o]>$\u0018\r^5p]*!\u0011QTAP\u0003\u0011\u0019wN]3\u000b\t\u0005\u0005\u00161U\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAAS\u0003\tIw.\u0003\u0003\u0002*\u0006]%!\u0002+j[\u0016$\u0017AB3ySN$8\u000f\u0006\u0003\u00020\u0006U\u0006c\u00010\u00022&\u0019\u00111W0\u0003\u000f\t{w\u000e\\3b]\"9\u00111P\tA\u0002\u0005u\u0004fA\t\u0002\u0014\u0006Aq-\u001a;USRdW\r\u0006\u0003\u0002~\u0005u\u0006bBA>%\u0001\u0007\u0011Q\u0010\u0015\u0004%\u0005M\u0015\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\r\u0005\u0015\u0017Q[Al!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\faAZ8mI\u0016\u0014(bAAh+\u00061Am\\7bS:LA!a5\u0002J\n1ai\u001c7eKJDq!a\u001f\u0014\u0001\u0004\ti\bC\u0005\u0002ZN\u0001\n\u00111\u0001\u0002\\\u0006)A-\u001a9uQB!\u00111LAo\u0013\u0011\ty.!\u0018\u0003\u000f%sG/Z4fe\"\u001a1#a%\u0002%\u0019Lg\u000e\u001a\"z\u0013\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003OTC!a7\u0002j.\u0012\u00111\u001e\t\u0005\u0003[\f)0\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001a~KA!a>\u0002p\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\u0019Lg\u000e\u001a,jK^\f'\r\\3G_2$WM]:Cs&#G\u0003CAc\u0003{\fyP!\u0001\t\u000f\u0005mT\u00031\u0001\u0002~!I\u0011\u0011\\\u000b\u0011\u0002\u0003\u0007\u00111\u001c\u0005\n\u0005\u0007)\u0002\u0013!a\u0001\u0003_\u000b\u0011#\u001a8g_J\u001cW\rU3s[&\u001c8/[8oQ\r)\u00121S\u0001\"M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$C-\u001a4bk2$HEM\u0001\"M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001bQC!a,\u0002j\u0006Qa-\u001b8e\u0005f\u0004\u0016\r\u001e5\u0015\r\u0005\u0015'1\u0003B\f\u0011\u001d\u0011)\u0002\u0007a\u0001\u0003{\nA\u0001]1uQ\"I\u0011\u0011\u001c\r\u0011\u0002\u0003\u0007!\u0011\u0004\t\u0004=\nm\u0011b\u0001B\u000f?\n\u0019\u0011J\u001c;)\u0007a\t\u0019*\u0001\u000bgS:$')\u001f)bi\"$C-\u001a4bk2$HEM\u000b\u0003\u0005KQCA!\u0007\u0002j\u0006\u0019B.[:u-&,w/\u00192mK\u001a{G\u000eZ3sgRQ!1\u0006B\u001c\u0005w\u0011)E!\u0013\u0011\r\t5\"1GAc\u001b\t\u0011yC\u0003\u0003\u00032\u0005\u0005\u0014\u0001B;uS2LAA!\u000e\u00030\t!A*[:u\u0011\u001d\u0011ID\u0007a\u0001\u0003{\n\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0005{Q\u0002\u0019\u0001B \u0003\u0011\u0001\u0018mZ3\u0011\u00075\u0014\t%C\u0002\u0003D9\u0014A\u0001U1hK\"I!q\t\u000e\u0011\u0002\u0003\u0007\u0011qV\u0001\u0018I\u0016\u001cwN]1uK^KG\u000f\u001b)fe6L7o]5p]ND\u0011Ba\u0001\u001b!\u0003\u0005\r!a,)\u0007i\t\u0019*A\u000fmSN$h+[3xC\ndWMR8mI\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003ua\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:tI\u0011,g-Y;mi\u0012\"\u0014\u0001B7pm\u0016$b!!2\u0003V\t]\u0003bBA>;\u0001\u0007\u0011Q\u0010\u0005\b\u00053j\u0002\u0019AA?\u0003-qWm\u001e)be\u0016tG/\u00133)\u0007u\t\u0019*\u0001\u0004sK:\fW.\u001a\u000b\u0007\u0003\u000b\u0014\tGa\u0019\t\u000f\u0005md\u00041\u0001\u0002~!9!Q\r\u0010A\u0002\u0005u\u0014a\u00028fo:\u000bW.\u001a\u0015\u0004=\u0005M\u0015aD:fCJ\u001c\u0007\u000eV3na2\fG/Z:\u0015\u0015\t5$q\u000fB=\u0005\u0007\u0013)\t\u0005\u0004\u0003.\tM\"q\u000e\t\u0005\u0005c\u0012\u0019(\u0004\u0002\u0002N&!!QOAg\u0005\u001d\u0011V\r\\3bg\u0016Dq!a\u001f \u0001\u0004\ti\bC\u0004\u0003|}\u0001\rA! \u0002\u0017I,G.Z1tK.Kg\u000e\u001a\t\u0005\u0005c\u0012y(\u0003\u0003\u0003\u0002\u00065'a\u0003*fY\u0016\f7/Z&j]\u0012DqA!\u0010 \u0001\u0004\u0011y\u0004C\u0005\u0003\u0004}\u0001\n\u00111\u0001\u00020\"\u001aq$a%\u00023M,\u0017M]2i)\u0016l\u0007\u000f\\1uKN$C-\u001a4bk2$H\u0005N\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)!\u0011yIa'\u0003\u001e\nU\u0006\u0003\u0002BI\u0005/k!Aa%\u000b\u0007\tUU+\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u00053\u0013\u0019JA\nSK2,\u0017m]3TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u0002|\u0005\u0002\r!! \t\u000f\t}\u0015\u00051\u0001\u0003\"\u00069a-\u001b7uKJ\u001c\b\u0003\u0002BR\u0005ck!A!*\u000b\t\t\u001d&\u0011V\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0005W\u0013i+\u0001\u0002wc)\u0019!qV+\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00034\n\u0015&a\u0004*fY\u0016\f7/Z:GS2$XM]:\t\u0013\tu\u0012\u0005%AA\u0002\t}\u0002fA\u0011\u0002\u0014\u0006A2/Z1sG\"\u0014V\r\\3bg\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu&\u0006\u0002B \u0003S\fA\"\\8wKR+W\u000e\u001d7bi\u0016$\u0002\"! \u0003D\n\u0015'\u0011\u001a\u0005\b\u0003w\u001a\u0003\u0019AA?\u0011\u001d\u00119m\ta\u0001\u0003{\n!\u0002^3na2\fG/Z%e\u0011%\u0011Ym\tI\u0001\u0002\u0004\ty+\u0001\ttQ>,H\u000eZ'fe\u001e,G+Z1ng\"\u001a1%a%\u0002-5|g/\u001a+f[Bd\u0017\r^3%I\u00164\u0017-\u001e7uIM\naa\u0019:fCR,GCBAc\u0005+\u00149\u000eC\u0004\u0003:\u0015\u0002\r!! \t\u000f\u0005-W\u00051\u0001\u0002F\"\u001aQ%a%\u0015\u0011\u0005\u0015'Q\u001cBp\u0005CDqA!\u000f'\u0001\u0004\ti\bC\u0004\u0002L\u001a\u0002\r!!2\t\u000f\t\rh\u00051\u0001\u00020\u0006\u00112M]3bi\u0016$UMZ1vYR$V-Y7tQ\r1\u00131S\u0001\fG\",7m\u001b'j[&$8\u000f\u0006\u0004\u0002t\t-(Q\u001e\u0005\b\u0003w:\u0003\u0019AA?\u0011\u001d\u0011If\na\u0001\u0003{\n\u0001c\u00195fG.4u\u000e\u001c3fe\u0012+\u0007\u000f\u001e5\u0015\u0011\u0005M$1\u001fB{\u0005oDq!a\u001f)\u0001\u0004\ti\bC\u0004\u0003Z!\u0002\r!! \t\u000f\te\b\u00061\u0001\u0003|\u0006qA.[7jiN\u001cV\r\u001e;j]\u001e\u001c\b\u0003\u0002B\u007f\u0007\u0007i!Aa@\u000b\u0007\r\u0005Q+A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0007\u000b\u0011yPA\bGK\u0006$XO]3TKR$\u0018N\\4t\u0003E9W\r\u001e'j[&$8oU3ui&twm]\u000b\u0003\u0005w\u0014qBR8mI\u0016\u0014\u0018I\u001c3Fm\u0016tGo]\n\u0007Uu\u001bya!\u0006\u0011\u0007y\u001b\t\"C\u0002\u0004\u0014}\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0004\u0018\r\u0005b\u0002BB\r\u0007;qA!a!\u0004\u001c%\t\u0001-C\u0002\u0004 }\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0004$\r\u0015\"\u0001D*fe&\fG.\u001b>bE2,'bAB\u0010?V\u0011\u0011QY\u0001\bM>dG-\u001a:!+\t\u0019i\u0003\u0005\u0004\u0004\u0018\r=21G\u0005\u0005\u0007c\u0019)CA\u0002TKF\u0004Ba!\u000e\u0004:5\u00111q\u0007\u0006\u0005\u0003[\ti-\u0003\u0003\u0004<\r]\"A\u0004-M%\u0016dW-Y:f\u000bZ,g\u000e^\u0001\bKZ,g\u000e^:!)\u0019\u0019\te!\u0012\u0004HA\u001911\t\u0016\u000e\u0003\u0001Aq!a30\u0001\u0004\t)\rC\u0005\u0002.=\u0002\n\u00111\u0001\u0004.\u0005!1m\u001c9z)\u0019\u0019\te!\u0014\u0004P!I\u00111\u001a\u0019\u0011\u0002\u0003\u0007\u0011Q\u0019\u0005\n\u0003[\u0001\u0004\u0013!a\u0001\u0007[\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004V)\"\u0011QYAu\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"aa\u0017+\t\r5\u0012\u0011^\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\te\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007O\u001ai\u0007E\u0002_\u0007SJ1aa\u001b`\u0005\r\te.\u001f\u0005\n\u0007_*\u0014\u0011!a\u0001\u00053\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB;!\u0019\u00199h! \u0004h5\u00111\u0011\u0010\u0006\u0004\u0007wz\u0016AC2pY2,7\r^5p]&!1qPB=\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=6Q\u0011\u0005\n\u0007_:\u0014\u0011!a\u0001\u0007O\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011LBF\u0011%\u0019y\u0007OA\u0001\u0002\u0004\u0011I\"\u0001\u0005iCND7i\u001c3f)\t\u0011I\"\u0001\u0005u_N#(/\u001b8h)\t\tI&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\u001bI\nC\u0005\u0004pm\n\t\u00111\u0001\u0004h\u0005yai\u001c7eKJ\fe\u000eZ#wK:$8\u000fE\u0002\u0004Du\u001aR!PBQ\u0007[\u0003\"ba)\u0004*\u0006\u00157QFB!\u001b\t\u0019)KC\u0002\u0004(~\u000bqA];oi&lW-\u0003\u0003\u0004,\u000e\u0015&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!1qVBZ\u001b\t\u0019\tL\u0003\u0003\u0002&\u0006\u0005\u0014\u0002BB\u0012\u0007c#\"a!(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\r\u000531XB_\u0011\u001d\tY\r\u0011a\u0001\u0003\u000bD\u0011\"!\fA!\u0003\u0005\ra!\f\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004F\u000eE\u0007#\u00020\u0004H\u000e-\u0017bABe?\n1q\n\u001d;j_:\u0004rAXBg\u0003\u000b\u001ci#C\u0002\u0004P~\u0013a\u0001V;qY\u0016\u0014\u0004\"CBj\u0005\u0006\u0005\t\u0019AB!\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002/\r\u0014X-\u0019;f/&$\bn\\;u!V\u0014G.[:iS:<G\u0003CB!\u00077\u001cina8\t\u000f\teB\t1\u0001\u0002~!9\u00111\u001a#A\u0002\u0005\u0015\u0007b\u0002Br\t\u0002\u0007\u0011qV\u0001\u0007I\u0016dW\r^3\u0015\t\u0005M4Q\u001d\u0005\b\u0003w*\u0005\u0019AA?Q\r)\u00151S\u0001\u0010CJ\u001c\u0007.\u001b<f\u001fJ$U\r\\3uKR1\u00111OBw\u0007cDqaa<G\u0001\u0004\u0011I\"A\u0005g_2$WM]+jI\"911\u001f$A\u0002\u0005u\u0014!\u0003:fY\u0016\f7/Z%e\u0003)iWM]4f)\u0016\fWn\u001d\u000b\t\u0003g\u001aIpa?\u0004~\"9\u00111P$A\u0002\u0005u\u0004b\u0002Bd\u000f\u0002\u0007\u0011Q\u0010\u0005\b\u0007\u007f<\u0005\u0019\u0001C\u0001\u00035!X-\u001c9mCR,G+Z1ngB11qCB\u0018\t\u0007\u0001BA!\u001d\u0005\u0006%!AqAAg\u0005\u0011!V-Y7\u0002\u0019I,\u0007\u000f\\1dKR+\u0017-\\:\u0015\r\u0005MDQ\u0002C\b\u0011\u001d\tY\b\u0013a\u0001\u0003{BqAa2I\u0001\u0004\ti(A\u000enKJ<W\rV3na2\fG/Z!oI\u001a{G\u000eZ3s)\u0016\fWn\u001d\u000b\u0007\t\u0003!)\u0002\"\u0007\t\u000f\u0011]\u0011\n1\u0001\u0005\u0002\u0005Yam\u001c7eKJ$V-Y7t\u0011\u001d\u0019y0\u0013a\u0001\t\u0003\tQB]3tKR$\u0016m]6UK\u0006lG\u0003BA:\t?AqAa2K\u0001\u0004\ti(\u0001\u0010de\u0016\fG/\u001a#fM\u0006,H\u000e\u001e+fC6\u001chi\u001c:UQ\u00164u\u000e\u001c3feR1AQ\u0005C\u0015\tW\u0001baa\u0006\u0005(\rM\u0012\u0002\u0002B\u001b\u0007KAq!a3L\u0001\u0004\t)\rC\u0004\u0003:-\u0003\r!! \u0002?\u001d,GOT8o\u0013:DWM]5uK\u00124u\u000e\u001c3feJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u00052\u0011\rCQ\t\t\u0007\tg!I\u0004\"\u0010\u000e\u0005\u0011U\"\u0002\u0002C\u001c\u0007s\nq!\\;uC\ndW-\u0003\u0003\u0005<\u0011U\"aA*fiB!!\u0011\u000fC \u0013\u0011!\t%!4\u0003#\t\u000b7/Z\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002|1\u0003\r!! \t\u000f\u0011\u001dC\n1\u0001\u0002~\u0005Ya.Z<g_2$WM]%e\u0003U\u0019\u0007.Z2l\r>dG-\u001a:DC:\u0014U-T8wK\u0012$\u0002\"a\u001d\u0005N\u0011=CQ\u000b\u0005\b\u0003wj\u0005\u0019AA?\u0011\u001d!\t&\u0014a\u0001\t'\n\u0011C\\3xM>dG-\u001a:JI>\u0003H/[8o!\u0015q6qYA?\u0011\u001d!9&\u0014a\u0001\u0003{\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002\u001b\r\u0014X-\u0019;f\t\u0016$\u0018-\u001b7t)!\tI\u0006\"\u0018\u0005d\u0011\u001d\u0004b\u0002C0\u001d\u0002\u0007A\u0011M\u0001\u000fC\u000e$\u0018N^3SK2,\u0017m]3t!\u0019\u00199ba\f\u0003p!9AQ\r(A\u0002\u0011\u0005\u0014\u0001G1vi>\u001cF/\u0019:u!\u0016tG-\u001b8h%\u0016dW-Y:fg\"9A\u0011\u000e(A\u0002\u0011-\u0014aC5om\u0006d\u0017\u000e\u001a*fMN\u0004baa\u001e\u0005n\u0011u\u0012\u0002\u0002C\u001e\u0007s\nqc\u00195fG.$V-\u001c9mCR,7)\u00198CK6{g/\u001a3\u0015\r\u0005MD1\u000fC;\u0011\u001d\u00119m\u0014a\u0001\u0003{Bq!a\u001fP\u0001\u0004\ti(\u0001\nhKR\u0014VO\u001c8j]\u001e\u0014V\r\\3bg\u0016\u001cH\u0003\u0002C1\twBq!a\u001fQ\u0001\u0004\ti(A\u000ehKR\fU\u000f^8Ti\u0006\u0014H\u000fU3oI&twMU3mK\u0006\u001cXm\u001d\u000b\u0005\tC\"\t\tC\u0004\u0002|E\u0003\r!! ")
public class FolderService
implements Logging {
    private volatile FolderService$FolderAndEvents$ FolderAndEvents$module;
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final String SLASH;
    private final String SLASH_FOLDER;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public FolderService$FolderAndEvents$ FolderAndEvents() {
        if (this.FolderAndEvents$module == null) {
            this.FolderAndEvents$lzycompute$1();
        }
        return this.FolderAndEvents$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String SLASH() {
        return this.SLASH;
    }

    public String SLASH_FOLDER() {
        return this.SLASH_FOLDER;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException("Folder " + Ids.ROOT_FOLDER_ID + " cannot be found", new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findViewableFoldersById(String folderId, Integer depth, boolean enforcePermission) {
        return (Folder)this.folders.findViewableFoldersById(folderId, depth, enforcePermission).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    public Integer findViewableFoldersById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public Folder findByPath(String path, int depth) {
        return this.folders.findByPath(path, depth);
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public java.util.List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        block0: {
            if (!enforcePermission) break block0;
            this.permissions.checkViewFolder(parentId);
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folders.listViewableFolders(parentId, page, decorateWithPermissions, enforcePermission)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkLimits(folderId, newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public java.util.List<Release> searchTemplates(String folderId, ReleaseKind releaseKind, Page page, boolean enforcePermission) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        filters.setKind(releaseKind);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), enforcePermission).getReleases();
    }

    public boolean searchTemplates$default$4() {
        return true;
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String newTemplateId = folderId + "/" + Ids.getName((String)templateId);
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string = Ids.getParentId((String)templateId);
        String string2 = folderId;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logger().info((Function0 & Serializable)() -> "Attempted to move template " + templateId + " to same folder " + folderId + ". Will be ignored.");
            return templateId;
        }
        scala.collection.immutable.Seq templateTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getStoredTeams(templateId)).asScala().toSeq();
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
        this.releaseRepository.move(templateId, newTemplateId);
        if (shouldMergeTeams) {
            this.mergeTeams(folderId, newTemplateId, (scala.collection.immutable.Seq<Team>)templateTeams);
        } else {
            this.replaceTeams(folderId, newTemplateId);
        }
        this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
        return newTemplateId;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        int allowedFolderDepth;
        String[] folderDepth = parentId.split(this.SLASH_FOLDER());
        FeatureSettings limitsSettings = this.getLimitsSettings();
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limitsSettings.getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled && folderDepth.length - 1 > (allowedFolderDepth = BoxesRunTime.unboxToInt((Object)limitsSettings.getProperty(Limits$.MODULE$.MAX_FOLDER_DEPTH())))) {
            throw new IllegalArgumentException("Creating Folder exceeds allowed sub-folder depth " + allowedFolderDepth);
        }
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        FolderAndEvents result = this.createWithoutPublishing(parentId, folder, createDefaultTeams);
        result.events().foreach((Function1 & Serializable)event -> {
            this.eventBus.publish(event);
            return BoxedUnit.UNIT;
        });
        return result.folder();
    }

    private void checkLimits(String folderId, String newParentId) {
        FeatureSettings limitsSettings = this.getLimitsSettings();
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)this.getLimitsSettings().getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled) {
            this.checkFolderDepth(folderId, newParentId, limitsSettings);
            return;
        }
    }

    private void checkFolderDepth(String folderId, String newParentId, FeatureSettings limitsSettings) {
        int newFolderIdSplitLength;
        int allowedFolderDepth = BoxesRunTime.unboxToInt((Object)limitsSettings.getProperty(Limits$.MODULE$.MAX_FOLDER_DEPTH()));
        int newParentIdFolderDepth = newParentId.split(this.SLASH_FOLDER()).length - 1;
        if (newParentIdFolderDepth > allowedFolderDepth) {
            throw new IllegalArgumentException("Moving folder/folders is not within the allowed sub-folder depth " + allowedFolderDepth);
        }
        String[] newFolderIdSplit = folderId.split(this.SLASH());
        String newFolderIdInDb = newFolderIdSplit[(newFolderIdSplitLength = newFolderIdSplit.length) - 1];
        int findChildrenOfNewFolder = this.folders.findNumberOfChildrenForAFolder(newFolderIdInDb);
        int newToBeFolderLength = newParentIdFolderDepth + findChildrenOfNewFolder;
        if (newToBeFolderLength > allowedFolderDepth) {
            throw new IllegalArgumentException("Moving folder/folders is not within the allowed sub-folder depth " + allowedFolderDepth);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FeatureSettings getLimitsSettings() {
        void var1_1;
        Optional<void> optional = this.configurationRepository.findFirstByType(Type.valueOf((String)Limits$.MODULE$.TYPE_LIMITS()));
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)Limits$.MODULE$.TYPE_LIMITS()).getDescriptor().newInstance("");
        feature.generateId();
        return (FeatureSettings)optional.orElse(var1_1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public FolderAndEvents createWithoutPublishing(String parentId, Folder folder, boolean createDefaultTeams) {
        Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
        this.checkFolderExists(parentId);
        this.folders.checkNameIsUnique(parentId, folder.getTitle());
        if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
            folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
        } else {
            folder.setId(parentId + "/" + Ids.getName((String)folder.getId()));
        }
        this.logger().info((Function0 & Serializable)() -> "Creating folder " + folder.getTitle() + " with id " + folder.getId());
        Folder saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
        .colon.colon events = new .colon.colon((Object)new FolderCreatedEvent(folder), (List)Nil$.MODULE$);
        if (createDefaultTeams) {
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                events = (scala.collection.immutable.Seq)events.$plus$plus(this.createDefaultTeamsForTheFolder(saved, parentId));
                return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
            }
        }
        events = (scala.collection.immutable.Seq)events.$colon$plus((Object)new TeamsUpdatedEvent(folder.getId()));
        return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable)() -> "Deleting folder " + folderId);
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable)() -> "archiveOrDelete(" + folderUid + ", " + releaseId + "): status=" + status + " [inactive? " + status.isInactive() + "]");
        if (status.isInactive()) {
            Release release = this.releaseRepository.findById(releaseId);
            if (this.archivingService.shouldArchive(release)) {
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable)() -> "archiveRelease(" + releaseId + ")");
            this.archivingService.archiveRelease(releaseId);
            return;
        }
        this.logger().trace((Function0 & Serializable)() -> "deleteRelease(" + releaseId + ")");
        this.releaseRepository.delete(releaseId);
    }

    private void mergeTeams(String folderId, String templateId, scala.collection.immutable.Seq<Team> templateTeams) {
        if (templateTeams.nonEmpty()) {
            scala.collection.immutable.Seq folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(folderId)).asScala().toSeq();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable)() -> folderId);
            scala.collection.immutable.Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((scala.collection.immutable.Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, CollectionConverters$.MODULE$.SeqHasAsJava(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
            return;
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private scala.collection.immutable.Seq<Team> mergeTemplateAndFolderTeams(scala.collection.immutable.Seq<Team> folderTeams, scala.collection.immutable.Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)folderTeams.map((Function1 & Serializable)team -> new Tuple2((Object)team.getTeamName(), team))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq());
        templateTeams.foreach((Function1 & Serializable)templateTeam -> {
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                return folderTeamsMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getMembers()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getMembers()).asScala().toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getRoles()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getRoles()).asScala().toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getPermissions()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getPermissions()).asScala().toSet());
                folderTeam.setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)memberSet.toSeq()).asJava());
                folderTeam.setRoles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roleSet.toSeq()).asJava());
                folderTeam.setPermissions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)permissionSet.toSeq()).asJava());
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        if (!template.isWorkflow()) {
            template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
            return;
        }
    }

    private List<XLReleaseEvent> createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getFolderPermissions()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getAppPipelinesPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_APP_PIPELINES.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getReleasePermissions()).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getTriggerPermissions()).asScala())).concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getWorkflowExecutionPermissions()).asScala())).concat((IterableOnce)new .colon.colon((Object)XLReleasePermissions.VIEW_FOLDER.getPermissionName(), (List)new .colon.colon((Object)XLReleasePermissions.VIEW_APP_PIPELINES.getPermissionName(), (List)Nil$.MODULE$)));
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        Tuple2<java.util.List<Team>, java.util.List<XLReleaseEvent>> result = this.teamService.saveTeamsToPlatformWithoutPublishing(folder.getId(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)folderOwner, (List)new .colon.colon((Object)templateOwner, (List)new .colon.colon((Object)releaseAdmin, (List)Nil$.MODULE$)))).asJava(), true);
        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result._2()).asScala().toList();
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        Buffer releases = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        scala.collection.immutable.Seq<Release> activeReleases = this.getRunningReleases(folderId);
        scala.collection.immutable.Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable)() -> "Tried to " + operation + " folder " + folderId + ", which has active releases " + ((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$2 -> x$2.getId())).mkString(", ") + " or pending releases with auto start option enabled: " + ((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$3 -> x$3.getId())).mkString(", "));
            String details = this.createDetails(activeReleases, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException("You cannot " + operation + " this folder. The folder or its subfolders contain " + details, new Object[0]);
        }
    }

    private String createDetails(scala.collection.immutable.Seq<Release> activeReleases, scala.collection.immutable.Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        Object details;
        block2: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = (String)details + "active releases: " + ((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$4 -> x$4.getTitle())).mkString("\"", "\", \"", "\"");
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = (String)details + "pending releases with auto start: " + ((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$5 -> x$5.getTitle())).mkString("\"", "\", \"", "\"");
            }
            if (!invalidRefs.nonEmpty()) break block2;
            details = (String)details + "configuration references not inherited by the destination folder: " + ((IterableOnceOps)invalidRefs.map((Function1 & Serializable)x$6 -> x$6.getTitle())).mkString("\"", "\", \"", "\"");
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).forall((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private scala.collection.immutable.Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala().toSeq();
    }

    private scala.collection.immutable.Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, true))).asScala().toSeq();
    }

    private final void FolderAndEvents$lzycompute$1() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (this.FolderAndEvents$module == null) {
                this.FolderAndEvents$module = new FolderService$FolderAndEvents$(this);
            }
        }
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$7, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).foreach((Function1 & Serializable)c -> {
            if (c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$7)) {
                return BoxesRunTime.boxToBoolean((boolean)res$1.add(c));
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$9, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$9.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
        this.SLASH = "/";
        this.SLASH_FOLDER = "/Folder";
    }

    public class FolderAndEvents
    implements Product,
    Serializable {
        private final Folder folder;
        private final scala.collection.immutable.Seq<XLReleaseEvent> events;
        public final /* synthetic */ FolderService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Folder folder() {
            return this.folder;
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> events() {
            return this.events;
        }

        public FolderAndEvents copy(Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            return new FolderAndEvents(this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer(), folder, events);
        }

        public Folder copy$default$1() {
            return this.folder();
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FolderAndEvents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.folder();
                }
                case 1: {
                    return this.events();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FolderAndEvents;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "folder";
                }
                case 1: {
                    return "events";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FolderAndEvents)) return false;
            if (((FolderAndEvents)object).com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() != this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FolderAndEvents folderAndEvents = (FolderAndEvents)x$1;
            Folder folder = this.folder();
            Folder folder2 = folderAndEvents.folder();
            if (folder == null) {
                if (folder2 != null) {
                    return false;
                }
            } else if (!folder.equals(folder2)) return false;
            scala.collection.immutable.Seq<XLReleaseEvent> seq = this.events();
            scala.collection.immutable.Seq<XLReleaseEvent> seq2 = folderAndEvents.events();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!folderAndEvents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FolderService com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() {
            return this.$outer;
        }

        public FolderAndEvents(FolderService $outer, Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            this.folder = folder;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

