/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support.report;

import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlplatform.support.report.ReportDataProvider;
import com.xebialabs.xlrelease.support.report.LicenseUsageStatistics;
import com.xebialabs.xlrelease.support.report.repository.DataStatisticsRepository;
import com.xebialabs.xlrelease.views.LicenseView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005Y4AAC\u0006\u0001-!AQ\u0005\u0001BC\u0002\u0013\u0005a\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000ba\u0002A\u0011A\u001d\t\u000f5\u0003!\u0019!C!\u001d\"1!\f\u0001Q\u0001\n=CQa\u0017\u0001\u0005BqCQa\u0019\u0001\u0005\n\u0011\u00141\u0003T5dK:\u001cX\rR1uCB\u0013xN^5eKJT!\u0001D\u0007\u0002\rI,\u0007o\u001c:u\u0015\tqq\"A\u0004tkB\u0004xN\u001d;\u000b\u0005A\t\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u00112#A\u0005yK\nL\u0017\r\\1cg*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010$\u001b\u0005y\"B\u0001\u0007!\u0015\tq\u0011E\u0003\u0002##\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u0005\u0011z\"A\u0005*fa>\u0014H\u000fR1uCB\u0013xN^5eKJ\fa\u0002\\5dK:\u001cXmU3sm&\u001cW-F\u0001(!\tAS&D\u0001*\u0015\tQ3&A\u0004tKJ4\u0018nY3\u000b\u00051\n\u0012a\u00027jG\u0016t7/Z\u0005\u0003]%\u0012a\u0002T5dK:\u001cXmU3sm&\u001cW-A\bmS\u000e,gn]3TKJ4\u0018nY3!\u0003)\u0011X\r]8tSR|'/_\u000b\u0002eA\u00111'N\u0007\u0002i)\u0011\u0001gC\u0005\u0003mQ\u0012\u0001\u0004R1uCN#\u0018\r^5ti&\u001c7OU3q_NLGo\u001c:z\u0003-\u0011X\r]8tSR|'/\u001f\u0011\u0002\rqJg.\u001b;?)\rQD(\u0010\t\u0003w\u0001i\u0011a\u0003\u0005\u0006K\u0015\u0001\ra\n\u0005\u0006a\u0015\u0001\rA\r\u0015\u0003\u000b}\u0002\"\u0001Q&\u000e\u0003\u0005S!AQ\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002E\u000b\u00069a-Y2u_JL(B\u0001$H\u0003\u0015\u0011W-\u00198t\u0015\tA\u0015*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Q\u0015aA8sO&\u0011A*\u0011\u0002\n\u0003V$xn^5sK\u0012\fAA\\1nKV\tq\n\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%fi\u0011a\u0015\u0006\u0003)V\ta\u0001\u0010:p_Rt\u0014B\u0001,\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005YK\u0012!\u00028b[\u0016\u0004\u0013!E2pY2,7\r^*uCRL7\u000f^5dgV\tQ\f\u0005\u0003Q=>\u0003\u0017BA0Z\u0005\ri\u0015\r\u001d\t\u00031\u0005L!AY\r\u0003\u0007\u0005s\u00170\u0001\rdC2\u001cW\u000f\\1uKV#\u0018\u000e\\5{CRLwN\u001c*bi\u0016$2!\u001a5n!\tAb-\u0003\u0002h3\t)a\t\\8bi\")\u0011.\u0003a\u0001U\u0006AQ.\u0019=Vg\u0016\u00148\u000f\u0005\u0002\u0019W&\u0011A.\u0007\u0002\u0004\u0013:$\b\"\u00028\n\u0001\u0004Q\u0017\u0001D2veJ,g\u000e^+tKJ\u001c\bF\u0001\u0001q!\t\tH/D\u0001s\u0015\t\u0019x)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!!\u001e:\u0003\u0013\r{W\u000e]8oK:$\b")
public class LicenseDataProvider
implements ReportDataProvider {
    private final LicenseService licenseService;
    private final DataStatisticsRepository repository;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LicenseDataProvider licenseDataProvider = this;
        synchronized (licenseDataProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public LicenseService licenseService() {
        return this.licenseService;
    }

    public DataStatisticsRepository repository() {
        return this.repository;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> collectStatistics() {
        LicenseUsageStatistics statistics = new LicenseUsageStatistics();
        LicenseView licenseView = new LicenseView(this.licenseService().getLicense());
        statistics.setLicenseVersion(licenseView.getVersion());
        statistics.setLicensedProduct(licenseView.getProduct());
        statistics.setLicensedEdition(licenseView.getEdition());
        statistics.setLicensedTo(licenseView.getLicensedTo());
        statistics.setLicenseExpiresAfter(licenseView.getExpiresAfter());
        statistics.setLicenseRemainingDays(this.licenseService().getValidPeriod().getDays());
        statistics.setLicensedMaxUsers(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)licenseView.getMaxNumberOfUsers()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)));
        statistics.setLicenseCurrentUsers(this.repository().countEnabledUsers());
        statistics.setLicenseUtilizationRate(this.calculateUtilizationRate(statistics.getLicensedMaxUsers(), statistics.getLicenseCurrentUsers()));
        statistics.setLicensedRepositoryId(licenseView.getRepositoryId());
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"license"), (Object)statistics)}));
    }

    private float calculateUtilizationRate(int maxUsers, int currentUsers) {
        if (maxUsers <= 0 || currentUsers < 0) {
            return 0.0f;
        }
        return package$.MODULE$.BigDecimal().apply(currentUsers).$div(package$.MODULE$.BigDecimal().apply(maxUsers)).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).floatValue();
    }

    @Autowired
    public LicenseDataProvider(LicenseService licenseService, DataStatisticsRepository repository) {
        this.licenseService = licenseService;
        this.repository = repository;
        Logging.$init$((Logging)this);
        this.name = "license";
    }
}

