/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.json;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.variables.reference.ReleasePropertyVariableKey;
import com.xebialabs.xlrelease.upgrade.JsonUpgrade;
import com.xebialabs.xlrelease.upgrade.UpgradeResult;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001B\b\u0011\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005B\u0015BQ!\r\u0001\u0005BIBqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004P\u0001\u0001\u0006I!\u0012\u0005\u0006!\u0002!I!\u0015\u0005\u0006S\u0002!IA\u001b\u0005\u0006Y\u0002!I!\u001c\u0005\u0006Y\u0002!IA\u001d\u0005\u0006k\u0002!IA\u001e\u0005\u0007\u007f\u0002!I!!\u0001\t\u0011\u0005\u0015\u0001\u0001\"\u0001\u0011\u0003\u000fAq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002\u001c\u0001!I!!\b\u0003Oac%+\u001a7fCN,G\u0007\u000f\u0019SK:\fW.\u001a*fg\u0016\u0014h/\u001a3WCJL\u0017M\u00197fg*\u001bxN\u001c\u0006\u0003#I\tAA[:p]*\u00111\u0003F\u0001\bkB<'/\u00193f\u0015\t)b#A\u0005yYJ,G.Z1tK*\u0011q\u0003G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!G\u0001\u0004G>l7\u0001A\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u0003II!a\b\n\u0003\u0017)\u001bxN\\+qOJ\fG-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003A\ta\"\u001e9he\u0006$WMV3sg&|g\u000eF\u0001'!\t9s&D\u0001)\u0015\t\u0019\u0012F\u0003\u0002+W\u0005\u0019\u0011\r]5\u000b\u00051j\u0013AB:feZ,'O\u0003\u0002/-\u0005AA-\u001a9m_fLG/\u0003\u00021Q\t9a+\u001a:tS>t\u0017A\u00049fe\u001a|'/\\+qOJ\fG-\u001a\u000b\u0003gY\u0002\"!\b\u001b\n\u0005U\u0012\"!D+qOJ\fG-\u001a*fgVdG\u000fC\u00038\u0007\u0001\u0007\u0001(A\u0006sK2,\u0017m]3Kg>t\u0007CA\u001dB\u001b\u0005Q$BA\t<\u0015\taT(\u0001\u0005kKR$\u0018n]8o\u0015\tqt(\u0001\u0005d_\u0012,\u0007.Y;t\u0015\u0005\u0001\u0015aA8sO&\u0011!I\u000f\u0002\u000b\u0015N{ej\u00142kK\u000e$\u0018\u0001H7bs\n,'+Z:feZ,GMV1sS\u0006\u0014G.\u001a)biR,'O\\\u000b\u0002\u000bB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0006e\u0016<W\r\u001f\u0006\u0003\u0015.\u000bA!\u001e;jY*\tA*\u0001\u0003kCZ\f\u0017B\u0001(H\u0005\u001d\u0001\u0016\r\u001e;fe:\fQ$\\1zE\u0016\u0014Vm]3sm\u0016$g+\u0019:jC\ndW\rU1ui\u0016\u0014h\u000eI\u0001\u0018e\u0016\u0004H.Y2f\u0013:4\u0016M]5bE2,7/\u0011:sCf$\"A\u00155\u0011\u0007Mk\u0006M\u0004\u0002U5:\u0011Q\u000bW\u0007\u0002-*\u0011qKG\u0001\u0007yI|w\u000e\u001e \n\u0003e\u000bQa]2bY\u0006L!a\u0017/\u0002\u000fA\f7m[1hK*\t\u0011,\u0003\u0002_?\n\u00191+Z9\u000b\u0005mc\u0006CA1f\u001d\t\u00117\r\u0005\u0002V9&\u0011A\rX\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e9\")qG\u0002a\u0001q\u0005\t\"/\u001a9mC\u000e,\u0017J\u001c+sS\u001e<WM]:\u0015\u0005I[\u0007\"B\u001c\b\u0001\u0004A\u0014!\u0006:fa2\f7-Z%o-\u0006\u0014\u0018.\u00192mKNl\u0015\r\u001d\u000b\u0004%:\u0004\b\"B8\t\u0001\u0004A\u0014A\u00036t_:|%M[3di\")\u0011\u000f\u0003a\u0001A\u0006A\u0001O]8qKJ$\u0018\u0010\u0006\u0002Sg\")A/\u0003a\u0001q\u0005Ia/\u00197vKNl\u0015\r]\u0001\u0013e\u0016\u0004H.Y2f-\u0006\u0014\u0018.\u00192mK.+\u0017\u0010F\u0002xwv\u00042\u0001_=a\u001b\u0005a\u0016B\u0001>]\u0005\u0019y\u0005\u000f^5p]\")AP\u0003a\u0001q\u0005Aa/\u0019:jC\ndW\rC\u0003\u007f\u0015\u0001\u0007\u0001-A\u0005sK2,\u0017m]3JI\u0006\u0019#/\u001a9mC\u000e,'+Z:feZ,GMV1sS\u0006\u0014G.Z:SK\u000e,(o]5wK2LHc\u0001\u001d\u0002\u0004!)qn\u0003a\u0001q\u0005y!/\u001a9mC\u000e,'+Z:feZ,G\r\u0006\u0003\u0002\n\u0005=\u0001c\u0001=\u0002\f%\u0019\u0011Q\u0002/\u0003\r\u0005s\u0017PU3g\u0011\u001d\t\t\u0002\u0004a\u0001\u0003\u0013\t\u0011b]8nKRD\u0017N\\4\u0002\u001bI,\u0007\u000f\\1dKN#(/\u001b8h)\r\u0001\u0017q\u0003\u0005\u0007\u00033i\u0001\u0019\u00011\u0002\u000bY\fG.^3\u0002!-,\u0017PT3fIN\u0014VM\\1nS:<G\u0003BA\u0010\u0003K\u00012\u0001_A\u0011\u0013\r\t\u0019\u0003\u0018\u0002\b\u0005>|G.Z1o\u0011\u0019\t9C\u0004a\u0001A\u0006\t2.Z=NCf\u0014WMR8s[\u0006$H/\u001a3)\u0007\u0001\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0015M$XM]3pif\u0004XMC\u0002\u00026}\nqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003s\tyCA\u0005D_6\u0004xN\\3oi\u0002")
public class XLRelease480RenameReservedVariablesJson
extends JsonUpgrade {
    private final Pattern maybeReservedVariablePattern = Pattern.compile("\\$\\{(\\w+\\.[^\\}]*)\\}", 2);

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-release", (String)"4.8.0#7");
    }

    @Override
    public UpgradeResult performUpgrade(JSONObject releaseJson) {
        this.replaceReservedVariablesRecursively(releaseJson);
        HashSet replacedKeys = new HashSet();
        replacedKeys.$plus$plus$eq(this.replaceInVariablesArray(releaseJson));
        replacedKeys.$plus$plus$eq(this.replaceInVariablesMap(releaseJson, "variableValues"));
        replacedKeys.$plus$plus$eq(this.replaceInVariablesMap(releaseJson, "passwordVariableValues"));
        replacedKeys.$plus$plus$eq(this.replaceInTriggers(releaseJson));
        List warnings = replacedKeys.toList().map((Function1 & Serializable)key -> {
            String oldKey = VariableHelper$.MODULE$.withVariableSyntax(key);
            String newKey = VariableHelper$.MODULE$.withVariableSyntax("_" + key);
            return "Replaced variable " + oldKey + " with " + newKey + ". Note that statements such as releaseVariables['" + key + "'] in script tasks in this template will no longer work";
        });
        return new UpgradeResult(true, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)warnings).asJava());
    }

    private Pattern maybeReservedVariablePattern() {
        return this.maybeReservedVariablePattern;
    }

    private scala.collection.immutable.Seq<String> replaceInVariablesArray(JSONObject releaseJson) {
        String releaseId = releaseJson.getString("id");
        return (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)releaseJson.optJSONArray("variables")).map((Function1 & Serializable)variables -> (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), variables.length()).flatMap((Function1 & Serializable)i -> XLRelease480RenameReservedVariablesJson.$anonfun$replaceInVariablesArray$2(this, variables, releaseId, BoxesRunTime.unboxToInt((Object)i)))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
    }

    private scala.collection.immutable.Seq<String> replaceInTriggers(JSONObject releaseJson) {
        scala.collection.immutable.Seq triggers2 = (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)releaseJson.optJSONArray("releaseTriggers")).map((Function1 & Serializable)triggers -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), triggers.length()).map((Function1 & Serializable)i -> triggers.getJSONObject(BoxesRunTime.unboxToInt((Object)i)))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
        return (scala.collection.immutable.Seq)triggers2.flatMap((Function1 & Serializable)triggerJson -> (scala.collection.immutable.Seq)this.replaceInVariablesMap((JSONObject)triggerJson, "templateVariables").$plus$plus(this.replaceInVariablesMap((JSONObject)triggerJson, "templatePasswordVariables")));
    }

    private scala.collection.immutable.Seq<String> replaceInVariablesMap(JSONObject jsonObject, String property) {
        return (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)jsonObject.optJSONObject(property)).map((Function1 & Serializable)valuesMap -> this.replaceInVariablesMap((JSONObject)valuesMap)).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    private scala.collection.immutable.Seq<String> replaceInVariablesMap(JSONObject valuesMap) {
        List keysToReplace = CollectionConverters$.MODULE$.IteratorHasAsScala(valuesMap.keys()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof String && this.keyNeedsRenaming(string = (String)object)) {
                return new Some((Object)string);
            }
            return None$.MODULE$;
        }).toList();
        keysToReplace.foreach((Function1 & Serializable)key -> {
            String newKey = VariableHelper$.MODULE$.containsOnlyVariable(key) ? VariableHelper$.MODULE$.withVariableSyntax("_" + VariableHelper$.MODULE$.withoutVariableSyntax(key)) : "_" + key;
            Object valueAtKey = valuesMap.get(key);
            valuesMap.put(newKey, valueAtKey);
            return valuesMap.remove(key);
        });
        Iterator keysIterator = valuesMap.keys();
        keysIterator.forEachRemaining(x0$2 -> {
            String string;
            Object object = x0$2;
            if (object instanceof String && ReleasePropertyVariableKey.isReleasePropertyVariableKey((String)(string = (String)object))) {
                keysIterator.remove();
                return;
            }
        });
        return keysToReplace.map((Function1 & Serializable)variableKey -> VariableHelper$.MODULE$.withoutVariableSyntax(variableKey));
    }

    private Option<String> replaceVariableKey(JSONObject variable, String releaseId) {
        String name = variable.getString("key");
        if (VariableHelper$.MODULE$.isGlobalVariable(name)) {
            String newName = "_" + name;
            variable.put("key", (Object)newName);
            return new Some((Object)name);
        }
        return None$.MODULE$;
    }

    private JSONObject replaceReservedVariablesRecursively(JSONObject jsonObject) {
        jsonObject.keys().forEachRemaining(x0$1 -> {
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                Object replaced = this.replaceReserved(jsonObject.get(string));
                jsonObject.put(string, replaced);
                return;
            }
        });
        return jsonObject;
    }

    public Object replaceReserved(Object something) {
        Object object = something;
        if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            return this.replaceReservedVariablesRecursively(jSONObject);
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.replaceString(string);
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), jSONArray.length()).foreach((Function1 & Serializable)i -> XLRelease480RenameReservedVariablesJson.$anonfun$replaceReserved$1(this, jSONArray, BoxesRunTime.unboxToInt((Object)i)));
            return jSONArray;
        }
        return object;
    }

    private String replaceString(String value) {
        PasswordEncrypter encrypter = PasswordEncrypter.getInstance();
        if (encrypter.isEncoded(value)) {
            return (String)Try$.MODULE$.apply((Function0 & Serializable)() -> encrypter.decrypt(value)).map((Function1 & Serializable)decrypted -> encrypter.encrypt(this.replacePattern$1((String)decrypted))).getOrElse((Function0 & Serializable)() -> value);
        }
        return this.replacePattern$1(value);
    }

    private boolean keyNeedsRenaming(String keyMaybeFormatted) {
        String key = VariableHelper$.MODULE$.formatVariableIfNeeded(keyMaybeFormatted);
        return key.toLowerCase().startsWith("${global.") || key.toLowerCase().startsWith("${release.") && !ReleasePropertyVariableKey.isReleasePropertyVariableKey((String)key);
    }

    public static final /* synthetic */ Option $anonfun$replaceInVariablesArray$2(XLRelease480RenameReservedVariablesJson $this, JSONArray variables$1, String releaseId$1, int i) {
        return Option$.MODULE$.apply((Object)variables$1.optJSONObject(i)).flatMap((Function1 & Serializable)x$1 -> $this.replaceVariableKey((JSONObject)x$1, releaseId$1));
    }

    public static final /* synthetic */ JSONArray $anonfun$replaceReserved$1(XLRelease480RenameReservedVariablesJson $this, JSONArray x4$1, int i) {
        Object item = x4$1.get(i);
        return x4$1.put(i, $this.replaceReserved(item));
    }

    private final String replacePattern$1(String text) {
        Matcher matcher = this.maybeReservedVariablePattern().matcher(text);
        Set keysToReplace = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        while (matcher.find()) {
            String key2 = matcher.group(1);
            Object object = this.keyNeedsRenaming(key2) ? keysToReplace.$plus$eq((Object)key2) : BoxedUnit.UNIT;
        }
        return (String)keysToReplace.foldLeft((Object)text, (Function2 & Serializable)(replacedText, key) -> replacedText.replace("${" + key + "}", "${_" + key + "}"));
    }
}

