/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.List;
import java.util.Map;

public class TaskReleaseView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private ReleaseStatus status;
    private boolean archived;
    private EffectiveSecurity security;
    private Map<String, String> variables;

    public TaskReleaseView(Task task, Release release) {
        this.id = release.getId();
        this.status = release.getStatus();
        this.archived = release.isArchived();
        this.security = (EffectiveSecurity)release.get$metadata().get(EffectiveSecurityDecorator.EFFECTIVE_SECURITY());
        this.variables = VariableHelper.getVariableValuesAsStrings((List)task.getInputVariables());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public EffectiveSecurity getSecurity() {
        return this.security;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }
}

