/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.service;

import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.converters.TaskJobConverter;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskId;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskIdAndExecutionId;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.UpdateJobStatus;
import com.xebialabs.xlrelease.scheduler.repository.UpdateNodeAndStatus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\u0006\r\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)A\u0007\u0001C\u0001k!)!\b\u0001C\u0001w!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002h\u0001!\t!!\u001b\u0003\u0015){'mU3sm&\u001cWM\u0003\u0002\u000e\u001d\u000591/\u001a:wS\u000e,'BA\b\u0011\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0012%\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003'Q\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003U\t1aY8n\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0006g24GG\u001b\u0006\u0002G\u0005AqM]5{u2,G-\u0003\u0002&A\t9Aj\\4hS:<\u0017!\u00046pEJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002)W5\t\u0011F\u0003\u0002+\u001d\u0005Q!/\u001a9pg&$xN]=\n\u00051J#!\u0004&pEJ+\u0007o\\:ji>\u0014\u00180\u0001\tuCN\\'j\u001c2D_:4XM\u001d;feB\u0011qFM\u0007\u0002a)\u0011\u0011GD\u0001\u000bG>tg/\u001a:uKJ\u001c\u0018BA\u001a1\u0005A!\u0016m]6K_\n\u001cuN\u001c<feR,'/\u0001\u0004=S:LGO\u0010\u000b\u0004maJ\u0004CA\u001c\u0001\u001b\u0005a\u0001\"\u0002\u0014\u0004\u0001\u00049\u0003\"B\u0017\u0004\u0001\u0004q\u0013a\u00044j]\u0012\fE\u000e\u001c+bg.TuNY:\u0015\tqB\u0006M\u001c\t\u0004{\u0015CeB\u0001 D\u001d\ty$)D\u0001A\u0015\t\te#\u0001\u0004=e>|GOP\u0005\u00027%\u0011AIG\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0003MSN$(B\u0001#\u001ba\tIu\nE\u0002K\u00176k\u0011AD\u0005\u0003\u0019:\u0011q\u0001V1tW*{'\r\u0005\u0002O\u001f2\u0001A!\u0003)\u0005\u0003\u0003\u0005\tQ!\u0001R\u0005\ryF%M\t\u0003%V\u0003\"!G*\n\u0005QS\"a\u0002(pi\"Lgn\u001a\t\u00033YK!a\u0016\u000e\u0003\u0007\u0005s\u0017\u0010C\u0003Z\t\u0001\u0007!,\u0001\u0006k_\n4\u0015\u000e\u001c;feN\u0004\"a\u00170\u000e\u0003qS!!\u0018\b\u0002\u000f\u0019LG\u000e^3sg&\u0011q\f\u0018\u0002\u000b\u0015>\u0014g)\u001b7uKJ\u001c\b\"B1\u0005\u0001\u0004\u0011\u0017\u0001\u00039bO\u0016\f'\r\\3\u0011\u0005\rdW\"\u00013\u000b\u0005\u00154\u0017A\u00023p[\u0006LgN\u0003\u0002hQ\u0006!A-\u0019;b\u0015\tI'.A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Y\u0017aA8sO&\u0011Q\u000e\u001a\u0002\t!\u0006<W-\u00192mK\")q\u000e\u0002a\u0001a\u0006\t\u0012n\u001a8pe\u0016,fn\u001b8po:$\u0016\u0010]3\u0011\u0005e\t\u0018B\u0001:\u001b\u0005\u001d\u0011un\u001c7fC:D#\u0001\u0002;\u0011\u0005UtX\"\u0001<\u000b\u0005]D\u0018AC1o]>$\u0018\r^5p]*\u0011\u0011P_\u0001\u0005G>\u0014XM\u0003\u0002|y\u0006QQ.[2s_6,G/\u001a:\u000b\u0003u\f!![8\n\u0005}4(!\u0002+j[\u0016$\u0017\u0001\u00044j]\u0012\u0014\u0015\u0010V1tW&#G\u0003BA\u0003\u0003#\u0001R!GA\u0004\u0003\u0017I1!!\u0003\u001b\u0005\u0019y\u0005\u000f^5p]B\u0019!*!\u0004\n\u0007\u0005=aB\u0001\u0004K_\n\u0014vn\u001e\u0005\b\u0003')\u0001\u0019AA\u000b\u0003\u0019!\u0018m]6JIB!\u0011qCA\u0010\u001d\u0011\tI\"a\u0007\u0011\u0005}R\u0012bAA\u000f5\u00051\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\b\u001bQ\t)A/A\ngS:$G)[:uS:\u001cGOT8eK&#7\u000f\u0006\u0002\u0002,A1\u0011qCA\u0017\u0003+IA!a\f\u0002$\t\u00191+\u001a;)\u0005\u0019!\u0018A\u00043fY\u0016$XMQ=UCN\\\u0017\n\u001a\u000b\u0005\u0003o\ti\u0004E\u0002\u001a\u0003sI1!a\u000f\u001b\u0005\u0011)f.\u001b;\t\u000f\u0005Mq\u00011\u0001\u0002\u0016!\u0012q\u0001^\u0001\u001dI\u0016dW\r^3CsR\u000b7o[%e\u0003:$W\t_3dkRLwN\\%e)\u0019\t9$!\u0012\u0002H!9\u00111\u0003\u0005A\u0002\u0005U\u0001bBA%\u0011\u0001\u0007\u0011QC\u0001\fKb,7-\u001e;j_:LE\r\u000b\u0002\ti\u0006yQ\u000f\u001d3bi\u0016TuNY*uCR,8\u000f\u0006\u0004\u0002\u0006\u0005E\u00131\f\u0005\b\u0003'J\u0001\u0019AA+\u0003\rQwN\u0019\t\u0004\u0015\u0006]\u0013bAA-\u001d\t\u0019!j\u001c2\t\u000f\u0005u\u0013\u00021\u0001\u0002`\u0005I!n\u001c2Ti\u0006$Xo\u001d\t\u0004\u0015\u0006\u0005\u0014bAA2\u001d\tI!j\u001c2Ti\u0006$Xo\u001d\u0015\u0003\u0013Q\fa#\u001e9eCR,'j\u001c2O_\u0012,\u0017I\u001c3Ti\u0006$Xo\u001d\u000b\t\u0003\u000b\tY'!\u001c\u0002r!9\u00111\u000b\u0006A\u0002\u0005U\u0003bBA8\u0015\u0001\u0007\u0011QC\u0001\u0005]>$W\rC\u0004\u0002^)\u0001\r!a\u0018)\u0005)!\bf\u0001\u0001\u0002xA!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~!\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t)a\u001f\u0003\u000fM+'O^5dK\u0002")
public class JobService
implements Logging {
    private final JobRepository jobRepository;
    private final TaskJobConverter taskJobConverter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobService jobService = this;
        synchronized (jobService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<TaskJob<?>> findAllTaskJobs(JobFilters jobFilters, Pageable pageable, boolean ignoreUnknownType) {
        List foundJobs = CollectionConverters$.MODULE$.ListHasAsScala(this.jobRepository.findAll(jobFilters, pageable).toList()).asScala().toList();
        return foundJobs.map((Function1 & Serializable)jobRow -> {
            TaskJob<?> taskJob;
            try {
                taskJob = $this.taskJobConverter.fromJobRow((JobRow)jobRow, $this.taskJobConverter.fromJobRow$default$2());
            }
            catch (Throwable t) {
                if (ignoreUnknownType) {
                    this.logger().error((Function0 & Serializable)() -> t.getMessage(), (Function0 & Serializable)() -> t);
                    taskJob = null;
                }
                throw t;
            }
            return taskJob;
        }).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobService.$anonfun$findAllTaskJobs$4(x$1)));
    }

    @Timed
    public Option<JobRow> findByTaskId(String taskId) {
        return this.jobRepository.findByTaskId(taskId);
    }

    @Timed
    public Set<String> findDistinctNodeIds() {
        return this.jobRepository.findDistinctNodeIds();
    }

    @Timed
    public void deleteByTaskId(String taskId) {
        this.jobRepository.delete(new DeleteByTaskId(taskId));
    }

    @Timed
    public void deleteByTaskIdAndExecutionId(String taskId, String executionId) {
        this.jobRepository.delete(new DeleteByTaskIdAndExecutionId(taskId, executionId));
    }

    @Timed
    public Option<JobRow> updateJobStatus(Job job, JobStatus jobStatus) {
        return this.jobRepository.update(new UpdateJobStatus(JobRow$.MODULE$.apply(job), jobStatus)).toOption();
    }

    @Timed
    public Option<JobRow> updateJobNodeAndStatus(Job job, String node, JobStatus jobStatus) {
        return this.jobRepository.update(new UpdateNodeAndStatus(JobRow$.MODULE$.apply(job), node, jobStatus)).toOption();
    }

    public static final /* synthetic */ boolean $anonfun$findAllTaskJobs$4(TaskJob x$1) {
        return x$1 == null;
    }

    public JobService(JobRepository jobRepository, TaskJobConverter taskJobConverter) {
        this.jobRepository = jobRepository;
        this.taskJobConverter = taskJobConverter;
        Logging.$init$((Logging)this);
    }
}

