/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableMappingUsagePoint;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.script.VariablesHolderForScriptContext;
import com.xebialabs.xlrelease.security.UsernamePassword;
import com.xebialabs.xlrelease.security.authentication.OwnerAuthenticationToken;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;

@Component
public class AuthenticationService {
    private AuthenticationManager authenticationManager;
    private UserLastActiveActorService userLastActiveActorService;
    private ThreadLocal<Authentication> authenticationThreadLocal = new ThreadLocal();
    private ThreadLocal<Task> currentScriptTask = new ThreadLocal();
    private ThreadLocal<Release> currentScriptRelease = new ThreadLocal();
    private ThreadLocal<VariablesHolderForScriptContext> currentVariables = new ThreadLocal();

    @Autowired
    public AuthenticationService(@Qualifier(value="authenticationManager") AuthenticationManager authenticationManager, UserLastActiveActorService userLastActiveActorService) {
        this.authenticationManager = authenticationManager;
        this.userLastActiveActorService = userLastActiveActorService;
    }

    public UsernamePassword loginScriptUser(Task task) {
        Release release = task.getRelease();
        this.currentScriptTask.set(task);
        return this.loginScriptUser(release);
    }

    public UsernamePassword loginScriptUser(Task task, VariablesHolderForScriptContext variablesHolderForScriptContext) {
        UsernamePassword usernamePass = this.loginScriptUser(task);
        this.currentVariables.set(variablesHolderForScriptContext);
        return usernamePass;
    }

    public UsernamePassword loginScriptUser(Release release) {
        this.currentScriptRelease.set(release);
        String scriptUser = (String)VariableHelper.replaceAll((Object)release.getScriptUsername(), (Map)release.getAllStringVariableValues(), new HashSet(), (boolean)false);
        String scriptUserPassword = this.resolveUserScriptPassword(release);
        this.authenticationThreadLocal.set(SecurityContextHolder.getContext().getAuthentication());
        if (release.isWorkflow() && Strings.isNullOrEmpty((String)scriptUser) && Strings.isNullOrEmpty((String)scriptUserPassword)) {
            this.authenticateScriptUser(new OwnerAuthenticationToken((Serializable)((Object)release.getOwner()), null));
        } else if (Strings.isNullOrEmpty((String)scriptUser) && !Strings.isNullOrEmpty((String)scriptUserPassword)) {
            this.authenticateScriptUser((Authentication)new PersonalAuthenticationToken(scriptUserPassword));
        } else if (!Strings.isNullOrEmpty((String)scriptUser)) {
            if (Strings.isNullOrEmpty((String)scriptUserPassword)) {
                throw new IllegalArgumentException(String.format("'Password' property has to be set to run automated tasks as '%s'", scriptUser));
            }
            this.authenticateScriptUser((Authentication)new UsernamePasswordAuthenticationToken((Object)scriptUser, (Object)scriptUserPassword));
        }
        this.currentVariables.remove();
        return UsernamePassword.apply(scriptUser, scriptUserPassword);
    }

    private void authenticateScriptUser(Authentication token) {
        Authentication authentication = this.authenticationManager.authenticate(token);
        this.userLastActiveActorService.updateLastActive(authentication.getName());
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    public void logoutScriptUser() {
        SecurityContextHolder.getContext().setAuthentication(this.authenticationThreadLocal.get());
        this.authenticationThreadLocal.remove();
        this.currentScriptRelease.remove();
        this.currentScriptTask.remove();
        this.currentVariables.remove();
    }

    public boolean isInScriptTask() {
        return this.currentScriptRelease.get() != null;
    }

    public boolean hasScriptTask() {
        return this.currentScriptTask.get() != null;
    }

    @NonNull
    public Task getCurrentScriptTask() {
        if (!this.isInScriptTask()) {
            throw new IllegalStateException("Current authentication context is not a script task");
        }
        if (this.currentScriptTask.get() == null) {
            throw new IllegalStateException("Script task not available in this context");
        }
        return this.currentScriptTask.get();
    }

    @NonNull
    public Release getCurrentScriptRelease() {
        if (!this.isInScriptTask()) {
            throw new IllegalStateException("Current authentication context is not a script task");
        }
        return this.currentScriptRelease.get();
    }

    public boolean hasVariablesHolderForScriptContext() {
        return this.currentVariables.get() != null;
    }

    @NonNull
    public VariablesHolderForScriptContext getCurrentVariablesHolderForScriptContext() {
        if (!this.hasVariablesHolderForScriptContext()) {
            throw new IllegalStateException("Current VariablesHolderForScriptContext is null");
        }
        return this.currentVariables.get();
    }

    private String resolveUserScriptPassword(Release release) {
        Map variableMapping = release.getVariableMapping();
        String propName = "scriptUserPassword";
        if (variableMapping != null && variableMapping.containsKey(propName)) {
            String scriptUserPass = release.getScriptUserPassword();
            HashMap variableMappingCopy = new HashMap(variableMapping);
            release.setVariableMapping(variableMappingCopy);
            String varKey = (String)variableMappingCopy.get(propName);
            VariableMappingUsagePoint usagePoint = CiProperty.of((ConfigurationItem)release, (String)propName).map(ciProperty -> new VariableMappingUsagePoint((ConfigurationItem)release, propName, ciProperty)).orElseThrow();
            ConfigurationVariableService.replaceFromUsagePoint(VariableHelper.withoutVariableSyntax((String)varKey), (UsagePoint)usagePoint, (Seq<Variable>)CollectionConverters.asScala(VariableHelper.getAllReleaseVariablesByKeys((Release)release).values()).toSeq());
            String resolvedPass = PasswordEncrypter.getInstance().ensureDecrypted(release.getScriptUserPassword());
            release.setScriptUserPassword(scriptUserPass);
            release.setVariableMapping(variableMapping);
            return resolvedPass;
        }
        return PasswordEncrypter.getInstance().ensureDecrypted(release.getScriptUserPassword());
    }
}

