/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.xlrelease.db.sql.DatabaseInfo;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.jdbc.Db2JdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.MySqlJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.OracleJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.PostgreSqlJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.SqlServerJdbcIndexedSessionRepositoryCustomizer;

@Configuration
class SessionRegistryConfiguration {
    SessionRegistryConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(value={"xl.server.session.storage.enabled"}, havingValue="false")
    public SessionRegistry sessionRegistry() {
        return new SessionRegistryImpl();
    }

    @Bean
    @ConditionalOnProperty(value={"xl.server.session.storage.enabled"}, havingValue="true")
    public SessionRepositoryCustomizer<JdbcIndexedSessionRepository> sessionRepositoryCustomizer(@Qualifier(value="xlrDbInfo") DatabaseInfo dbInfo) {
        if (dbInfo instanceof DatabaseInfo.Db2) {
            return new Db2JdbcIndexedSessionRepositoryCustomizer();
        }
        if (dbInfo instanceof DatabaseInfo.Oracle) {
            return new OracleJdbcIndexedSessionRepositoryCustomizer();
        }
        if (dbInfo instanceof DatabaseInfo.MsSqlServer) {
            return new SqlServerJdbcIndexedSessionRepositoryCustomizer();
        }
        if (dbInfo instanceof DatabaseInfo.MySql) {
            return new MySqlJdbcIndexedSessionRepositoryCustomizer();
        }
        if (dbInfo instanceof DatabaseInfo.PostgreSql) {
            return new PostgreSqlJdbcIndexedSessionRepositoryCustomizer();
        }
        return null;
    }
}

