/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.customscript;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.CustomScriptTaskBuilder;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.variable.VariableViewHelper;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Tuple2;

@Component
public class CustomScriptTaskViewConverter
extends BaseTaskViewConverter<CustomScriptTask> {
    private final ConfigurationRepository configurationRepository;

    @Autowired
    public CustomScriptTaskViewConverter(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    @Override
    protected Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public TaskFullView toFullView(CustomScriptTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView customTaskView;
        if (task.getPythonScript() != null) {
            customTaskView = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
            PythonScript pythonScript = task.getPythonScript();
            customTaskView.setScriptDefinitionType(pythonScript.getType().toString());
            Map variableMapping = task.getVariableMapping();
            pythonScript.getInputProperties().forEach(pd -> customTaskView.getInputProperties().put(pd.getName(), this.getViewValue((PropertyDescriptor)pd, pythonScript, variableMapping, false)));
            pythonScript.getOutputProperties().forEach(pd -> customTaskView.getOutputProperties().put(pd.getName(), this.getViewValue((PropertyDescriptor)pd, pythonScript, variableMapping, true)));
            customTaskView.setTypeDisplayGroup(TaskDefinition.getDisplayGroup((Type)pythonScript.getType()));
            customTaskView.setTypeDisplayName(TaskDefinition.getDisplayName((Type)pythonScript.getType()));
            customTaskView.setOutputVarHelpText(pythonScript.getOutputVarHelpText());
            customTaskView.setColor(pythonScript.getTaskColor());
            customTaskView.setCustomIconLocation(pythonScript.getIconLocation());
            customTaskView.setCustomIconClass(pythonScript.getIconClass());
            customTaskView.setDocumentationPage(pythonScript.getDocumentationPage());
            customTaskView.setConfigurationUri(pythonScript.getConfigurationUri());
            customTaskView.setStatusLine(task.getStatusLine());
            customTaskView.setKeepPreviousOutputPropertiesOnRetry(task.isKeepPreviousOutputPropertiesOnRetry());
        } else {
            customTaskView = new TaskFullView();
            customTaskView.setId(task.getId());
            customTaskView.setType(task.getType().toString());
        }
        return customTaskView;
    }

    @Override
    protected CustomScriptTask fromView(TaskFullView view) {
        CustomScriptTask customScriptTask = ((CustomScriptTaskBuilder)TaskBuilder.newCustomScript((String)view.getScriptDefinitionType()).withId(view.getId())).withStatusLine(view.getStatusLine()).withKeepPreviousOutputPropertiesOnRetry(view.isKeepPreviousOutputPropertiesOnRetry()).build();
        PythonScript pythonScript = customScriptTask.getPythonScript();
        this.fillProperties(view.getInputProperties(), pythonScript.getInputProperties(), pythonScript);
        this.fillProperties(view.getOutputProperties(), pythonScript.getOutputProperties(), pythonScript);
        pythonScript.setConfigurationUri(view.getConfigurationUri());
        return customScriptTask;
    }

    @Override
    protected void fillVariableMappings(TaskFullView view, CustomScriptTask task) {
    }

    private void fillProperties(Map<String, Object> viewProperties, Collection<PropertyDescriptor> propertyDescriptors, PythonScript pythonScript) {
        propertyDescriptors.forEach(pd -> {
            String propertyName = pd.getName();
            Object viewValue = viewProperties.get(propertyName);
            if (viewValue == null) {
                pythonScript.setProperty(propertyName, null);
            } else {
                Tuple2<String, Object> variableAndValue = VariableViewHelper.fromView(pd, viewValue, this.configurationRepository);
                String variable = (String)variableAndValue._1();
                AbstractCollection value = variableAndValue._2();
                if (value != null) {
                    switch (pd.getKind()) {
                        case SET_OF_STRING: 
                        case SET_OF_CI: {
                            value = new HashSet(value);
                            break;
                        }
                        case LIST_OF_CI: 
                        case LIST_OF_STRING: {
                            value = new ArrayList(value);
                            break;
                        }
                    }
                }
                pythonScript.setProperty(propertyName, (Object)value);
                this.updateVariableMappingOfProperty(pythonScript, propertyName, variable);
            }
        });
    }

    private void updateVariableMappingOfProperty(PythonScript pythonScript, String propertyName, String variableName) {
        String fqPropertyName = "pythonScript." + propertyName;
        Map variableMapping = pythonScript.getCustomScriptTask().getVariableMapping();
        if (Strings.isNotEmpty((String)variableName)) {
            variableMapping.put(fqPropertyName, variableName);
        } else {
            variableMapping.remove(fqPropertyName);
        }
    }

    private Object getViewValue(PropertyDescriptor pd, PythonScript pythonScript, Map<String, String> variableMapping, boolean useViewForStrings) {
        return VariableViewHelper.toView(pd, variableMapping.get("pythonScript." + pd.getName()), pythonScript.getProperty(pd.getName()), useViewForStrings);
    }
}

