/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.CSPFilter;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.MaintenanceModeAccessControlFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.JettyEmbeddedErrorHandler;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jetty12.server.TimedHandler;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.SessionTrackingMode;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\u0010 \u0001)B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005y!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011U\u0003!\u0011!Q\u0001\nYCQA\u0019\u0001\u0005\u0002\rDQA\u001b\u0001\u0005B-DQA\u001d\u0001\u0005RMDq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c!9\u00111\n\u0001\u0005\n\u00055\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003/\u0002A\u0011BA-\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0006bBAc\u0001\u0011%\u0011q\u0019\u0002$%\u0016dW-Y:f\u0015\u0016$H/_*feZdW\r^,fEN+'O^3s\r\u0006\u001cGo\u001c:z\u0015\t\u0001\u0013%A\u0003kKR$\u0018P\u0003\u0002#G\u000511/\u001a:wKJT!\u0001J\u0013\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0014(\u0003%AXMY5bY\u0006\u00147OC\u0001)\u0003\r\u0019w.\\\u0002\u0001'\t\u00011\u0006\u0005\u0002-q5\tQF\u0003\u0002!])\u0011q\u0006M\u0001\tK6\u0014W\r\u001a3fI*\u0011\u0011GM\u0001\u0004o\u0016\u0014'BA\u001a5\u0003\u0011\u0011wn\u001c;\u000b\u0005U2\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003]\n1a\u001c:h\u0013\tITF\u0001\u000fKKR$\u0018pU3sm2,GoV3c'\u0016\u0014h/\u001a:GC\u000e$xN]=\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003q\u0002\"!\u0010!\u000e\u0003yR!aP\u0013\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\u0011 \u0003'M+'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u0003%AHN]\"p]\u001aLw-F\u0001F!\t1\u0015*D\u0001H\u0015\tA5%\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0015\u001e\u0013\u0011\u0002\u00177s\u0007>tg-[4\u0002\u0015ad'oQ8oM&<\u0007%\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Es\u0014\u0001C:fGV\u0014\u0018\u000e^=\n\u0005M\u0003&A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJ\f1\u0003]3s[&\u001c8/[8o\u000b:4wN]2fe\u0002\nQ\"\\3uKJ\u0014VmZ5tiJL\bCA,a\u001b\u0005A&BA-[\u0003)Ign\u001d;sk6,g\u000e\u001e\u0006\u00037r\u000bAaY8sK*\u0011QLX\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(\"A0\u0002\u0005%|\u0017BA1Y\u00055iU\r^3s%\u0016<\u0017n\u001d;ss\u00061A(\u001b8jiz\"R\u0001\u001a4hQ&\u0004\"!\u001a\u0001\u000e\u0003}AQA\u000f\u0005A\u0002qBQa\u0011\u0005A\u0002\u0015CQ\u0001\u0014\u0005A\u00029CQ!\u0016\u0005A\u0002Y\u000b\u0001$[:SK\u001eL7\u000f^3s\t\u00164\u0017-\u001e7u'\u0016\u0014h\u000f\\3u)\u0005a\u0007CA7q\u001b\u0005q'\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005Et'a\u0002\"p_2,\u0017M\\\u0001\u0019a>\u001cH\u000f\u0015:pG\u0016\u001c8oV3c\u0003B\u00048i\u001c8uKb$HC\u0001;x!\tiW/\u0003\u0002w]\n!QK\\5u\u0011\u0015A(\u00021\u0001z\u0003-\u0019wN\u001c;fqR\u0014vn\u001c;\u0011\u0007i\f)!D\u0001|\u0015\taX0\u0001\u0004xK\n\f\u0007\u000f\u001d\u0006\u0003}~\fA!Z32a)\u0019\u0001%!\u0001\u000b\u0007\u0005\ra'A\u0004fG2L\u0007o]3\n\u0007\u0005\u001d1PA\u0007XK\n\f\u0005\u000f]\"p]R,\u0007\u0010^\u0001\u000bg\u0016$X\u000f\u001d&fiRLHc\u0001;\u0002\u000e!)\u0001p\u0003a\u0001s\u0006Ir-\u001a;FeJ|'\u000fU1hK\u000e{gNZ5hkJ\fG/[8o)\t\t\u0019\u0002E\u0002{\u0003+I1!a\u0006|\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\u0011\u0012\r\u001a3KKR$\u00180\u0012:s_J\u0004\u0016mZ3t)\u0015!\u0018QDA\u0017\u0011\u001d\ty\"\u0004a\u0001\u0003C\tA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003Oi\u0018aB:feZdW\r^\u0005\u0005\u0003W\t)C\u0001\u0007FeJ|'\u000fS1oI2,'\u000fC\u0004\u000205\u0001\r!!\r\u0002\u0015\u0015\u0014(o\u001c:QC\u001e,7\u000f\u0005\u0004\u00024\u0005u\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005!Q\u000f^5m\u0015\t\tY$\u0001\u0003kCZ\f\u0017\u0002BA \u0003k\u0011!bQ8mY\u0016\u001cG/[8o!\u0011\t\u0019%a\u0012\u000e\u0005\u0005\u0015#B\u0001\u00121\u0013\u0011\tI%!\u0012\u0003\u0013\u0015\u0013(o\u001c:QC\u001e,\u0017AE:fiV\u0004Hj\\4cC\u000e\\g)\u001b7uKJ$2\u0001^A(\u0011\u0015Ah\u00021\u0001z\u0003-\u0019X\r^;q'B\u0014\u0018N\\4\u0015\u0007Q\f)\u0006C\u0003y\u001f\u0001\u0007\u00110A\btKR,\boQ8sg\u001aKG\u000e^3s)\r!\u00181\f\u0005\u0006qB\u0001\r!_\u0001\u001eg\u0016$X\u000f\u001d-tgN+7-\u001e:jifDU-\u00193feN4\u0015\u000e\u001c;feR\u0019A/!\u0019\t\u000ba\f\u0002\u0019A=\u0002\u001dM,G/\u001e9Ve24\u0015\u000e\u001c;feR\u0019A/a\u001a\t\u000ba\u0014\u0002\u0019A=\u0002'M,G/\u001e9TY><Hm\\<o\r&dG/\u001a:\u0015\u0007Q\fi\u0007C\u0003y'\u0001\u0007\u00110\u0001\btKR,\boQ*Q\r&dG/\u001a:\u0015\u0007Q\f\u0019\bC\u0003y)\u0001\u0007\u00110A\ttKR,\b/\u0012=uK:\u001c\u0018n\u001c8Ba&$2\u0001^A=\u0011\u0015AX\u00031\u0001z\u0003Q\u0019X\r^;q-\u0016\u00148/[8o\u000b:4wN]2feR\u0019A/a \t\u000ba4\u0002\u0019A=\u0002#M,G/\u001e9SKF,Xm\u001d;M_\u000e\fG\u000eF\u0002u\u0003\u000bCQ\u0001_\fA\u0002e\fA#\u001a8bE2,'+Z:pkJ\u001cWm]\"bG\",Gc\u0001;\u0002\f\")\u0001\u0010\u0007a\u0001s\u0006\tRM\\1cY\u0016<%0\u001b9IC:$G.\u001a:\u0015\u0007Q\f\t\nC\u0003y3\u0001\u0007\u00110A\toK^\u001cVm]:j_:D\u0015M\u001c3mKJ,\"!a&\u0011\t\u0005\r\u0012\u0011T\u0005\u0005\u00037\u000b)C\u0001\bTKN\u001c\u0018n\u001c8IC:$G.\u001a:\u00023\u0015t\u0017M\u00197f\u0013:\u001cHO];nK:$X\r\u001a%b]\u0012dWM\u001d\u000b\u0004i\u0006\u0005\u0006\"\u0002=\u001c\u0001\u0004I\u0018!E:fiB\u0013x\u000e]3sifLeMT;mYR)A/a*\u0002B\"9\u0011\u0011\u0016\u000fA\u0002\u0005-\u0016aA6fsB!\u0011QVA^\u001d\u0011\ty+a.\u0011\u0007\u0005Ef.\u0004\u0002\u00024*\u0019\u0011QW\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\tIL\\\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0016q\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ef\u000eC\u0004\u0002Dr\u0001\r!a+\u0002\u000bY\fG.^3\u0002OM,G/\u001e9NC&tG/\u001a8b]\u000e,Wj\u001c3f\u0003\u000e\u001cWm]:D_:$(o\u001c7GS2$XM\u001d\u000b\u0004i\u0006%\u0007\"\u0002=\u001e\u0001\u0004I\b")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;
    private final MeterRegistry meterRegistry;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupMaintenanceModeAccessControlFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.setSessionHandler(this.newSessionHandler());
        contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
        contextRoot.addConfiguration(new Configuration[]{this.getErrorPageConfiguration()});
        if (this.xlrConfig().metrics().enabled()) {
            this.enableInstrumentedHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_gzip_enabled()) {
            this.enableGzipHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_cache_enabled() && Environment.isProduction()) {
            this.enableResourcesCache(contextRoot);
            return;
        }
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(this){
            private final /* synthetic */ ReleaseJettyServletWebServerFactory $outer;

            public void configure(WebAppContext context) {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                errorHandler.setShowServlet(false);
                errorHandler.setShowStacks(false);
                errorHandler.setShowMessageInTitle(false);
                context.setErrorHandler((Request.Handler)errorHandler);
                this.$outer.com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages((ErrorHandler)errorHandler, this.$outer.getErrorPages());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new AbstractConfiguration.Builder());
            }
        };
    }

    public void com$xebialabs$xlrelease$server$jetty$ReleaseJettyServletWebServerFactory$$addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        ErrorHandler errorHandler2 = errorHandler;
        if (errorHandler2 instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler errorPageErrorHandler = (ErrorPageErrorHandler)errorHandler2;
            CollectionConverters$.MODULE$.CollectionHasAsScala(errorPages).asScala().foreach((Function1 & Serializable)errorPage -> {
                ReleaseJettyServletWebServerFactory.$anonfun$addJettyErrorPages$1(errorPageErrorHandler, errorPage);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        filter.setAsyncSupported(true);
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        encodingFilter.setAsyncSupported(true);
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        ResourceFactory resourceFactory = contextRoot.getResourceFactory();
        URI path = Path.of(".", new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toUri();
        Resource baseResource = resourceFactory.newResource(path);
        contextRoot.setBaseResource(baseResource);
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
            return;
        }
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "x-requested-with, accept, origin, content-type");
            holder.setInitParameter("Access-Control-Max-Age", "3600");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        if (Environment.isDevelopment()) {
            long slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis();
            if (slowDownInMs > 0L) {
                this.logger.warn((Object)("Configuring slow down filter with " + slowDownInMs + " milliseconds."));
                FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
                slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
                slowdownFilter.setAsyncSupported(true);
                contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                return;
            }
            return;
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().server_http_csp_enabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.xlrConfig().server_http_csp_policyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(PekkoStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        if (!Environment.isDevelopment()) {
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
            return;
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, this.xlrConfig().server_http_gzip_compression(), true));
        contextRoot.insertHandler((Handler.Singleton)gzipHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)("Setting up Secure Cookie Enabled to - " + this.serverConfiguration().isSecureCookieEnabled()));
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return sessionHandler;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        TimedHandler handler = new TimedHandler(this.meterRegistry, (Iterable)Tags.empty());
        contextRoot.insertHandler((Handler.Singleton)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting system property - " + key));
                }
                System.setProperty(key, value);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not overriding already specified system property - " + key));
                return;
            }
            return;
        }
    }

    private void setupMaintenanceModeAccessControlFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().maintenanceModeEnabled()) {
            boolean restrictApiAccess = this.xlrConfig().maintenanceModeRestrictApiAccess();
            FilterHolder filterHolder = new FilterHolder((Filter)new MaintenanceModeAccessControlFilter(this.permissionEnforcer(), restrictApiAccess));
            contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addJettyErrorPages$1(ErrorPageErrorHandler x2$1, ErrorPage errorPage) {
        if (errorPage.isGlobal()) {
            x2$1.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
            return;
        }
        if (errorPage.getExceptionName() != null) {
            x2$1.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
            return;
        }
        x2$1.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer, MeterRegistry meterRegistry) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
        this.meterRegistry = meterRegistry;
    }
}

