/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.container;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.ContainerTaskDefinition;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ContainerTaskUpdater
extends DefaultTaskUpdater {
    @Override
    public Class<? extends Task> getTaskClass() {
        return ContainerTask.class;
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        if (this.hasDirectiveToUpdateAllProperties(original, updateDirectives)) {
            this.updateTaskConfiguration((ContainerTask)original, (ContainerTask)updated);
            ((ContainerTask)original).setKeepPreviousOutputPropertiesOnRetry(((ContainerTask)updated).isKeepPreviousOutputPropertiesOnRetry());
            changes.update((ConfigurationItem)original);
        } else if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_TASK_CONFIGURATION)) {
            this.updateTaskConfiguration((ContainerTask)original, (ContainerTask)updated);
            changes.update((ConfigurationItem)original);
        }
        return changes;
    }

    private void updateTaskConfiguration(ContainerTask original, ContainerTask updated) {
        this.updateInputProperties(original, updated);
        this.updateOutputProperties(original, updated);
        this.taskConcurrencyService.updateLastModifiedDetails((Task)original);
    }

    private void updateInputProperties(ContainerTask original, ContainerTask updated) {
        ContainerTaskDefinition containerTaskDefinition = new ContainerTaskDefinition(original.getType());
        for (PropertyDescriptor propertyDescriptor : containerTaskDefinition.getInputProperties()) {
            String name = propertyDescriptor.getName();
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                Configuration configuration = (Configuration)updated.getProperty(name);
                if (configuration != null) {
                    Preconditions.checkArgument((boolean)configuration.getType().getDescriptor().isAssignableTo(propertyDescriptor.getReferencedType()), (Object)("Type of CI must be " + propertyDescriptor.getReferencedType().getName() + " got " + configuration.getType().getName()));
                }
                original.setProperty(propertyDescriptor.getName(), (Object)configuration);
                continue;
            }
            if (propertyDescriptor.isPassword() && propertyDescriptor.getKind() == PropertyKind.STRING) {
                original.setProperty(propertyDescriptor.getName(), (Object)PasswordVerificationUtils.replacePasswordIfNeeded((String)original.getProperty(name), (String)updated.getProperty(name)));
                continue;
            }
            original.setProperty(propertyDescriptor.getName(), updated.getProperty(name));
        }
    }

    private void updateOutputProperties(ContainerTask original, ContainerTask updated) {
        ContainerTaskDefinition containerTaskDefinition = new ContainerTaskDefinition(original.getType());
        for (PropertyDescriptor propertyDescriptor : containerTaskDefinition.getTransitionalAndOutputProperties()) {
            String name = propertyDescriptor.getName();
            Object value = updated.getProperty(name);
            if (propertyDescriptor.getKind() == PropertyKind.STRING && "output".equals(propertyDescriptor.getCategory())) {
                value = VariableHelper.formatVariableIfNeeded((String)((String)value));
            }
            original.setProperty(name, value);
        }
    }
}

