/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderOperationValidator;
import com.xebialabs.xlrelease.service.FolderService$FolderAndEvents$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011Md\u0001B)S\u0001mC\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"Aa\u000f\u0001B\u0001B\u0003%q\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003|\u0011!q\bA!A!\u0002\u0013y\bBCA\u0003\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u0015\u0005U\u0001A!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002$\u0001\u0011\t\u0011)A\u0005\u0003KA!\"!\r\u0001\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\tI\u0004\u0001B\u0001B\u0003%\u00111\b\u0005\b\u0003W\u0002A\u0011AA7\u0011%\ty\t\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAJ\u0011%\t)\u000b\u0001b\u0001\n\u0003\t\t\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAJ\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011q \u0001\u0005\u0002\t\u0005\u0001\"\u0003B\u0011\u0001E\u0005I\u0011\u0001B\u0012\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sA\u0011B!\u0012\u0001#\u0003%\tAa\t\t\u0013\t\u001d\u0003!%A\u0005\u0002\t%\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0005\n\u0005?\u0002\u0011\u0013!C\u0001\u0005CBqA!\u001a\u0001\t\u0003\u00119\u0007C\u0005\u0003\f\u0002\t\n\u0011\"\u0001\u0003J!I!Q\u0012\u0001\u0012\u0002\u0013\u0005!\u0011\n\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa*\u0001\t\u0003\u0011I\u000bC\u0005\u0003H\u0002\t\n\u0011\"\u0001\u0003J!9!\u0011\u001a\u0001\u0005\u0002\t-\u0007\"\u0003B|\u0001E\u0005I\u0011\u0001B}\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005\u007fD\u0011b!\u0004\u0001#\u0003%\tA!\u0013\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012!91q\u0002\u0001\u0005\u0002\re\u0001bBB\u0013\u0001\u0011%1q\u0005\u0005\b\u0007[\u0001A\u0011BB\u0018\u0011\u001d\u0019)\u0005\u0001C\u0005\u0007\u000f2aa!\u0013\u0001\u0001\u000e-\u0003B\u0003B\u0005Y\tU\r\u0011\"\u0001\u0004Z!Q11\f\u0017\u0003\u0012\u0003\u0006IAa\u0001\t\u0015\u0005-BF!f\u0001\n\u0003\u0019i\u0006\u0003\u0006\u0004l1\u0012\t\u0012)A\u0005\u0007?Bq!a\u001b-\t\u0003\u0019i\u0007C\u0005\u0004x1\n\t\u0011\"\u0001\u0004z!I1q\u0010\u0017\u0012\u0002\u0013\u00051\u0011\u0011\u0005\n\u0007\u000bc\u0013\u0013!C\u0001\u0007\u000fC\u0011ba#-\u0003\u0003%\t%!%\t\u0013\r5E&!A\u0005\u0002\r=\u0005\"CBIY\u0005\u0005I\u0011ABJ\u0011%\u0019y\nLA\u0001\n\u0003\u001a\t\u000bC\u0005\u000402\n\t\u0011\"\u0001\u00042\"I1Q\u0017\u0017\u0002\u0002\u0013\u00053q\u0017\u0005\n\u0007wc\u0013\u0011!C!\u0007{C\u0011ba0-\u0003\u0003%\te!1\t\u0013\r\rG&!A\u0005B\r\u0015w!CBe\u0001\u0005\u0005\t\u0012ABf\r%\u0019I\u0005AA\u0001\u0012\u0003\u0019i\rC\u0004\u0002l}\"\taa9\t\u0013\r}v(!A\u0005F\r\u0005\u0007\"CBs\u007f\u0005\u0005I\u0011QBt\u0011%\u0019ioPI\u0001\n\u0003\u00199\tC\u0005\u0004p~\n\t\u0011\"!\u0004r\"IA1A \u0012\u0002\u0013\u00051q\u0011\u0005\b\t\u000b\u0001A\u0011\u0001C\u0004\u0011\u001d!y\u0001\u0001C\u0001\t#Aq\u0001b\u0006\u0001\t\u0013!I\u0002C\u0004\u0005$\u0001!I\u0001\"\n\t\u000f\u0011]\u0002\u0001\"\u0003\u0005:!9Aq\b\u0001\u0005\n\u0011\u0005\u0003b\u0002C%\u0001\u0011%A1\n\u0005\b\t\u001f\u0002A\u0011\u0002C)\u0011\u001d!Y\u0006\u0001C\u0005\t;Bq\u0001\"\u001a\u0001\t\u0013!9\u0007C\u0004\u0005l\u0001!I\u0001\"\u001c\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0015\t\u0019F+A\u0004tKJ4\u0018nY3\u000b\u0005U3\u0016!\u0003=me\u0016dW-Y:f\u0015\t9\u0006,A\u0005yK\nL\u0017\r\\1cg*\t\u0011,A\u0002d_6\u001c\u0001aE\u0002\u00019\n\u0004\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013a!\u00118z%\u00164\u0007CA2i\u001b\u0005!'BA3g\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0017\u0001C4sSjTH.\u001a3\n\u0005%$'a\u0002'pO\u001eLgnZ\u0001\bM>dG-\u001a:t!\taw.D\u0001n\u0015\tqG+\u0001\u0006sKB|7/\u001b;pefL!\u0001]7\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018a\u0003;fC6\u001cVM\u001d<jG\u0016\u0004\"a\u001d;\u000e\u0003IK!!\u001e*\u0003\u0017Q+\u0017-\\*feZL7-Z\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bC\u00017y\u0013\tIXNA\tSK2,\u0017m]3SKB|7/\u001b;pef\f1\u0002^1tWN+'O^5dKB\u00111\u000f`\u0005\u0003{J\u00131\u0002V1tWN+'O^5dK\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0004Y\u0006\u0005\u0011bAA\u0002[\n92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\rE\u0002t\u0003\u0013I1!a\u0003S\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f!\r\u0019\u0018\u0011C\u0005\u0004\u0003'\u0011&\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u0006qKJl\u0017n]:j_:\u001c\b\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uA+\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\t#a\u0007\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0005fm\u0016tGOQ;t!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016)\u00061QM^3oiNLA!a\f\u0002*\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007cA:\u00026%\u0019\u0011q\u0007*\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017!\u00074pY\u0012,'o\u00149fe\u0006$\u0018n\u001c8WC2LG-\u0019;peN\u0004D!!\u0010\u0002ZA1\u0011qHA(\u0003+rA!!\u0011\u0002L9!\u00111IA%\u001b\t\t)EC\u0002\u0002Hi\u000ba\u0001\u0010:p_Rt\u0014\"A0\n\u0007\u00055c,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00131\u000b\u0002\u0004'\u0016\f(bAA'=B!\u0011qKA-\u0019\u0001!1\"a\u0017\f\u0003\u0003\u0005\tQ!\u0001\u0002^\t\u0019q\fJ\u0019\u0012\t\u0005}\u0013Q\r\t\u0004;\u0006\u0005\u0014bAA2=\n9aj\u001c;iS:<\u0007cA:\u0002h%\u0019\u0011\u0011\u000e*\u00031\u0019{G\u000eZ3s\u001fB,'/\u0019;j_:4\u0016\r\\5eCR|'/\u0001\u0004=S:LGO\u0010\u000b\u0019\u0003_\n\t(a\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0005CA:\u0001\u0011\u0015QG\u00021\u0001l\u0011\u0015\tH\u00021\u0001s\u0011\u00151H\u00021\u0001x\u0011\u0015QH\u00021\u0001|\u0011\u0015qH\u00021\u0001\u0000\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000fAq!!\u0004\r\u0001\u0004\ty\u0001C\u0004\u0002\u00161\u0001\r!a\u0006\t\u000f\u0005\rB\u00021\u0001\u0002&!9\u0011\u0011\u0007\u0007A\u0002\u0005M\u0002bBA\u001d\u0019\u0001\u0007\u0011q\u0011\u0019\u0005\u0003\u0013\u000bi\t\u0005\u0004\u0002@\u0005=\u00131\u0012\t\u0005\u0003/\ni\t\u0002\u0007\u0002\\\u0005\u0015\u0015\u0011!A\u0001\u0006\u0003\ti&A\u0003T\u0019\u0006\u001b\u0006*\u0006\u0002\u0002\u0014B!\u0011QSAP\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015\u0001\u00027b]\u001eT!!!(\u0002\t)\fg/Y\u0005\u0005\u0003C\u000b9J\u0001\u0004TiJLgnZ\u0001\u0007'2\u000b5\u000b\u0013\u0011\u0002\u0019Mc\u0015i\u0015%`\r>cE)\u0012*\u0002\u001bMc\u0015i\u0015%`\r>cE)\u0012*!\u0003E\u0019\u0007.Z2l\r>dG-\u001a:Fq&\u001cHo\u001d\u000b\u0005\u0003[\u000b\u0019\fE\u0002^\u0003_K1!!-_\u0005\u0011)f.\u001b;\t\u000f\u0005U\u0016\u00031\u0001\u00028\u0006Aam\u001c7eKJLE\r\u0005\u0003\u0002:\u0006\u0005g\u0002BA^\u0003{\u00032!a\u0011_\u0013\r\tyLX\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00161\u0019\u0006\u0004\u0003\u007fs\u0006fA\t\u0002HB!\u0011\u0011ZAn\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017AC1o]>$\u0018\r^5p]*!\u0011\u0011[Aj\u0003\u0011\u0019wN]3\u000b\t\u0005U\u0017q[\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAAm\u0003\tIw.\u0003\u0003\u0002^\u0006-'!\u0002+j[\u0016$\u0017AB3ySN$8\u000f\u0006\u0003\u0002d\u0006%\bcA/\u0002f&\u0019\u0011q\u001d0\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0017\nA\u0002\u0005]\u0006f\u0001\n\u0002H\u0006Aq-\u001a;USRdW\r\u0006\u0003\u00028\u0006E\bbBA['\u0001\u0007\u0011q\u0017\u0015\u0004'\u0005\u001d\u0017aB4fiB\u000bG\u000f\u001b\u000b\u0005\u0003s\fY\u0010\u0005\u0004\u0002@\u0005=\u0013q\u0017\u0005\b\u0003k#\u0002\u0019AA\\Q\r!\u0012qY\u0001\tM&tGMQ=JIR1!1\u0001B\n\u0005+\u0001BA!\u0002\u0003\u00105\u0011!q\u0001\u0006\u0005\u0005\u0013\u0011Y!\u0001\u0004g_2$WM\u001d\u0006\u0004\u0005\u001b!\u0016A\u00023p[\u0006Lg.\u0003\u0003\u0003\u0012\t\u001d!A\u0002$pY\u0012,'\u000fC\u0004\u00026V\u0001\r!a.\t\u0013\t]Q\u0003%AA\u0002\te\u0011!\u00023faRD\u0007\u0003BAK\u00057IAA!\b\u0002\u0018\n9\u0011J\u001c;fO\u0016\u0014\bfA\u000b\u0002H\u0006\u0011b-\u001b8e\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)C\u000b\u0003\u0003\u001a\t\u001d2F\u0001B\u0015!\u0011\u0011YCa\r\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055g,\u0003\u0003\u00036\t5\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069b-\u001b8e-&,w/\u00192mK\u001a{G\u000eZ3sg\nK\u0018\n\u001a\u000b\t\u0005\u0007\u0011YD!\u0010\u0003@!9\u0011QW\fA\u0002\u0005]\u0006\"\u0003B\f/A\u0005\t\u0019\u0001B\r\u0011%\u0011\te\u0006I\u0001\u0002\u0004\t\u0019/A\tf]\u001a|'oY3QKJl\u0017n]:j_:D3aFAd\u0003\u00052\u0017N\u001c3WS\u0016<\u0018M\u00197f\r>dG-\u001a:t\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133\u0003\u00052\u0017N\u001c3WS\u0016<\u0018M\u00197f\r>dG-\u001a:t\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YE\u000b\u0003\u0002d\n\u001d\u0012A\u00034j]\u0012\u0014\u0015\u0010U1uQR1!1\u0001B)\u0005+BqAa\u0015\u001b\u0001\u0004\t9,\u0001\u0003qCRD\u0007\"\u0003B\f5A\u0005\t\u0019\u0001B,!\ri&\u0011L\u0005\u0004\u00057r&aA%oi\"\u001a!$a2\u0002)\u0019Lg\u000e\u001a\"z!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019G\u000b\u0003\u0003X\t\u001d\u0012a\u00057jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cHC\u0003B5\u0005k\u0012IHa!\u0003\bB1!1\u000eB9\u0005\u0007i!A!\u001c\u000b\t\t=\u00141T\u0001\u0005kRLG.\u0003\u0003\u0003t\t5$\u0001\u0002'jgRDqAa\u001e\u001d\u0001\u0004\t9,\u0001\u0005qCJ,g\u000e^%e\u0011\u001d\u0011Y\b\ba\u0001\u0005{\nA\u0001]1hKB\u0019ANa \n\u0007\t\u0005UN\u0001\u0003QC\u001e,\u0007\"\u0003BC9A\u0005\t\u0019AAr\u0003]!WmY8sCR,w+\u001b;i!\u0016\u0014X.[:tS>t7\u000fC\u0005\u0003Bq\u0001\n\u00111\u0001\u0002d\"\u001aA$a2\u0002;1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:%I\u00164\u0017-\u001e7uIM\nQ\u0004\\5tiZKWm^1cY\u00164u\u000e\u001c3feN$C-\u001a4bk2$H\u0005N\u0001\u0005[>4X\r\u0006\u0004\u0003\u0004\tM%Q\u0013\u0005\b\u0003k{\u0002\u0019AA\\\u0011\u001d\u00119j\ba\u0001\u0003o\u000b1B\\3x!\u0006\u0014XM\u001c;JI\"\u001aq$a2\u0002\rI,g.Y7f)\u0019\u0011\u0019Aa(\u0003\"\"9\u0011Q\u0017\u0011A\u0002\u0005]\u0006b\u0002BRA\u0001\u0007\u0011qW\u0001\b]\u0016<h*Y7fQ\r\u0001\u0013qY\u0001\u0010g\u0016\f'o\u00195UK6\u0004H.\u0019;fgRQ!1\u0016B[\u0005o\u0013\tMa1\u0011\r\t-$\u0011\u000fBW!\u0011\u0011yK!-\u000e\u0005\t-\u0011\u0002\u0002BZ\u0005\u0017\u0011qAU3mK\u0006\u001cX\rC\u0004\u00026\u0006\u0002\r!a.\t\u000f\te\u0016\u00051\u0001\u0003<\u0006Y!/\u001a7fCN,7*\u001b8e!\u0011\u0011yK!0\n\t\t}&1\u0002\u0002\f%\u0016dW-Y:f\u0017&tG\rC\u0004\u0003|\u0005\u0002\rA! \t\u0013\t\u0005\u0013\u0005%AA\u0002\u0005\r\bfA\u0011\u0002H\u0006I2/Z1sG\"$V-\u001c9mCR,7\u000f\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019X-\u0019:dQJ+G.Z1tKN$\u0002B!4\u0003Z\nm'1\u001f\t\u0005\u0005\u001f\u0014).\u0004\u0002\u0003R*\u0019!1\u001b+\u0002\rM,\u0017M]2i\u0013\u0011\u00119N!5\u0003'I+G.Z1tKN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\u0005U6\u00051\u0001\u00028\"9!Q\\\u0012A\u0002\t}\u0017a\u00024jYR,'o\u001d\t\u0005\u0005C\u0014y/\u0004\u0002\u0003d*!!Q\u001dBt\u0003\u00151wN]7t\u0015\u0011\u0011IOa;\u0002\u0005Y\f$b\u0001Bw)\u0006\u0019\u0011\r]5\n\t\tE(1\u001d\u0002\u0010%\u0016dW-Y:fg\u001aKG\u000e^3sg\"I!1P\u0012\u0011\u0002\u0003\u0007!Q\u0010\u0015\u0004G\u0005\u001d\u0017\u0001G:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1 \u0016\u0005\u0005{\u00129#\u0001\u0007n_Z,G+Z7qY\u0006$X\r\u0006\u0005\u00028\u000e\u000511AB\u0004\u0011\u001d\t),\na\u0001\u0003oCqa!\u0002&\u0001\u0004\t9,\u0001\u0006uK6\u0004H.\u0019;f\u0013\u0012D\u0011b!\u0003&!\u0003\u0005\r!a9\u0002!MDw.\u001e7e\u001b\u0016\u0014x-\u001a+fC6\u001c\bfA\u0013\u0002H\u00061Rn\u001c<f)\u0016l\u0007\u000f\\1uK\u0012\"WMZ1vYR$3'\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0005\u0007\u0019\u0019b!\u0006\t\u000f\t]t\u00051\u0001\u00028\"9!\u0011B\u0014A\u0002\t\r\u0001fA\u0014\u0002HRA!1AB\u000e\u0007;\u0019y\u0002C\u0004\u0003x!\u0002\r!a.\t\u000f\t%\u0001\u00061\u0001\u0003\u0004!91\u0011\u0005\u0015A\u0002\u0005\r\u0018AE2sK\u0006$X\rR3gCVdG\u000fV3b[ND3\u0001KAd\u0003-\u0019\u0007.Z2l\u0019&l\u0017\u000e^:\u0015\r\u000556\u0011FB\u0016\u0011\u001d\t),\u000ba\u0001\u0003oCqAa&*\u0001\u0004\t9,\u0001\tdQ\u0016\u001c7NR8mI\u0016\u0014H)\u001a9uQRA\u0011QVB\u0019\u0007g\u0019)\u0004C\u0004\u00026*\u0002\r!a.\t\u000f\t]%\u00061\u0001\u00028\"91q\u0007\u0016A\u0002\re\u0012A\u00047j[&$8oU3ui&twm\u001d\t\u0005\u0007w\u0019\t%\u0004\u0002\u0004>)\u00191q\b+\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\u0019\u0019e!\u0010\u0003\u001f\u0019+\u0017\r^;sKN+G\u000f^5oON\f\u0011cZ3u\u0019&l\u0017\u000e^:TKR$\u0018N\\4t+\t\u0019IDA\bG_2$WM]!oI\u00163XM\u001c;t'\u0019aCl!\u0014\u0004TA\u0019Qla\u0014\n\u0007\rEcLA\u0004Qe>$Wo\u0019;\u0011\t\u0005}2QK\u0005\u0005\u0007/\n\u0019F\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0006\u0002\u0003\u0004\u00059am\u001c7eKJ\u0004SCAB0!\u0019\ty$a\u0014\u0004bA!11MB4\u001b\t\u0019)G\u0003\u0003\u0002,\t-\u0011\u0002BB5\u0007K\u0012a\u0002\u0017'SK2,\u0017m]3Fm\u0016tG/A\u0004fm\u0016tGo\u001d\u0011\u0015\r\r=41OB;!\r\u0019\t\bL\u0007\u0002\u0001!9!\u0011B\u0019A\u0002\t\r\u0001\"CA\u0016cA\u0005\t\u0019AB0\u0003\u0011\u0019w\u000e]=\u0015\r\r=41PB?\u0011%\u0011IA\rI\u0001\u0002\u0004\u0011\u0019\u0001C\u0005\u0002,I\u0002\n\u00111\u0001\u0004`\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCABBU\u0011\u0011\u0019Aa\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u0012\u0016\u0005\u0007?\u00129#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005/\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004\u0016\u000em\u0005cA/\u0004\u0018&\u00191\u0011\u00140\u0003\u0007\u0005s\u0017\u0010C\u0005\u0004\u001e^\n\t\u00111\u0001\u0003X\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa)\u0011\r\r\u001561VBK\u001b\t\u00199KC\u0002\u0004*z\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019ika*\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\u001c\u0019\fC\u0005\u0004\u001ef\n\t\u00111\u0001\u0004\u0016\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019j!/\t\u0013\ru%(!AA\u0002\t]\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t]\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u000e\u001d\u0007\"CBO{\u0005\u0005\t\u0019ABK\u0003=1u\u000e\u001c3fe\u0006sG-\u0012<f]R\u001c\bcAB9\u007fM)qha4\u0004\\BQ1\u0011[Bl\u0005\u0007\u0019yfa\u001c\u000e\u0005\rM'bABk=\u00069!/\u001e8uS6,\u0017\u0002BBm\u0007'\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0019in!9\u000e\u0005\r}'\u0002BAm\u00037KAaa\u0016\u0004`R\u001111Z\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0007_\u001aIoa;\t\u000f\t%!\t1\u0001\u0003\u0004!I\u00111\u0006\"\u0011\u0002\u0003\u00071qL\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BBz\u0007\u007f\u0004R!XB{\u0007sL1aa>_\u0005\u0019y\u0005\u000f^5p]B9Qla?\u0003\u0004\r}\u0013bAB\u007f=\n1A+\u001e9mKJB\u0011\u0002\"\u0001E\u0003\u0003\u0005\raa\u001c\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u0018GJ,\u0017\r^3XSRDw.\u001e;Qk\nd\u0017n\u001d5j]\u001e$\u0002ba\u001c\u0005\n\u0011-AQ\u0002\u0005\b\u0005o2\u0005\u0019AA\\\u0011\u001d\u0011IA\u0012a\u0001\u0005\u0007Aqa!\tG\u0001\u0004\t\u0019/\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003[#\u0019\u0002C\u0004\u00026\u001e\u0003\r!a.)\u0007\u001d\u000b9-A\bbe\u000eD\u0017N^3Pe\u0012+G.\u001a;f)\u0019\ti\u000bb\u0007\u0005 !9AQ\u0004%A\u0002\t]\u0013!\u00034pY\u0012,'/V5e\u0011\u001d!\t\u0003\u0013a\u0001\u0003o\u000b\u0011B]3mK\u0006\u001cX-\u00133\u0002\u00155,'oZ3UK\u0006l7\u000f\u0006\u0005\u0002.\u0012\u001dB\u0011\u0006C\u0016\u0011\u001d\t),\u0013a\u0001\u0003oCqa!\u0002J\u0001\u0004\t9\fC\u0004\u0005.%\u0003\r\u0001b\f\u0002\u001bQ,W\u000e\u001d7bi\u0016$V-Y7t!\u0019\ty$a\u0014\u00052A!!q\u0016C\u001a\u0013\u0011!)Da\u0003\u0003\tQ+\u0017-\\\u0001\re\u0016\u0004H.Y2f)\u0016\fWn\u001d\u000b\u0007\u0003[#Y\u0004\"\u0010\t\u000f\u0005U&\n1\u0001\u00028\"91Q\u0001&A\u0002\u0005]\u0016aG7fe\u001e,G+Z7qY\u0006$X-\u00118e\r>dG-\u001a:UK\u0006l7\u000f\u0006\u0004\u00050\u0011\rCq\t\u0005\b\t\u000bZ\u0005\u0019\u0001C\u0018\u0003-1w\u000e\u001c3feR+\u0017-\\:\t\u000f\u001152\n1\u0001\u00050\u0005i!/Z:fiR\u000b7o\u001b+fC6$B!!,\u0005N!91Q\u0001'A\u0002\u0005]\u0016AH2sK\u0006$X\rR3gCVdG\u000fV3b[N4uN\u001d+iK\u001a{G\u000eZ3s)\u0019!\u0019\u0006b\u0016\u0005ZA1\u0011q\bC+\u0007CJAAa\u001d\u0002T!9!\u0011B'A\u0002\t\r\u0001b\u0002B<\u001b\u0002\u0007\u0011qW\u0001\u0016G\",7m\u001b$pY\u0012,'oQ1o\u0005\u0016luN^3e)\u0019\ti\u000bb\u0018\u0005b!9\u0011Q\u0017(A\u0002\u0005]\u0006b\u0002C2\u001d\u0002\u0007\u0011qW\u0001\u0012]\u0016<hm\u001c7eKJLEm\u00149uS>t\u0017aF2iK\u000e\\gi\u001c7eKJ\u001c\u0015M\u001c\"f\t\u0016dW\r^3e)\u0011\ti\u000b\"\u001b\t\u000f\u0005Uv\n1\u0001\u00028\u000692\r[3dWR+W\u000e\u001d7bi\u0016\u001c\u0015M\u001c\"f\u001b>4X\r\u001a\u000b\u0007\u0003[#y\u0007\"\u001d\t\u000f\r\u0015\u0001\u000b1\u0001\u00028\"9\u0011Q\u0017)A\u0002\u0005]\u0006")
public class FolderService
implements Logging {
    private volatile FolderService$FolderAndEvents$ FolderAndEvents$module;
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final scala.collection.immutable.Seq<FolderOperationValidator> folderOperationValidators;
    private final String SLASH;
    private final String SLASH_FOLDER;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public FolderService$FolderAndEvents$ FolderAndEvents() {
        if (this.FolderAndEvents$module == null) {
            this.FolderAndEvents$lzycompute$1();
        }
        return this.FolderAndEvents$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String SLASH() {
        return this.SLASH;
    }

    public String SLASH_FOLDER() {
        return this.SLASH_FOLDER;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException("Folder " + Ids.ROOT_FOLDER_ID + " cannot be found", new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    @Timed
    public scala.collection.immutable.Seq<String> getPath(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException("Folder " + Ids.ROOT_FOLDER_ID + " cannot be found", new Object[0]);
        }
        return this.folders.getPath(folderId);
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findViewableFoldersById(String folderId, Integer depth, boolean enforcePermission) {
        return (Folder)this.folders.findViewableFoldersById(folderId, depth, enforcePermission).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    public Integer findViewableFoldersById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public Folder findByPath(String path, int depth) {
        return this.folders.findByPath(path, depth);
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public java.util.List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        block0: {
            if (!enforcePermission) break block0;
            this.permissions.checkViewFolder(parentId);
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folders.listViewableFolders(parentId, page, decorateWithPermissions, enforcePermission)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkLimits(folderId, newParentId);
        this.checkFolderCanBeMoved(folderId, newParentId);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        String string3 = Ids.ROOT_FOLDER_ID;
        String string4 = newParentId;
        List<XLReleaseEvent> list = !(string3 != null ? !string3.equals(string4) : string4 != null) && BoxesRunTime.equalsNumObject((Number)folder.get$securedCi(), (Object)BoxesRunTime.boxToInteger((int)1)) ? this.createDefaultTeamsForTheFolder(folder, newParentId) : BoxedUnit.UNIT;
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public java.util.List<Release> searchTemplates(String folderId, ReleaseKind releaseKind, Page page, boolean enforcePermission) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        filters.setKind(releaseKind);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), enforcePermission).getReleases();
    }

    public boolean searchTemplates$default$4() {
        return true;
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String newTemplateId = folderId + "/" + Ids.getName((String)templateId);
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string = Ids.getParentId((String)templateId);
        String string2 = folderId;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logger().info((Function0 & Serializable)() -> "Attempted to move template " + templateId + " to same folder " + folderId + ". Will be ignored.");
            return templateId;
        }
        scala.collection.immutable.Seq templateTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getStoredTeams(templateId)).asScala().toSeq();
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
        this.releaseRepository.move(templateId, newTemplateId);
        if (shouldMergeTeams) {
            this.mergeTeams(folderId, newTemplateId, (scala.collection.immutable.Seq<Team>)templateTeams);
        } else {
            this.replaceTeams(folderId, newTemplateId);
        }
        this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
        return newTemplateId;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        int allowedFolderDepth;
        String[] folderDepth = parentId.split(this.SLASH_FOLDER());
        FeatureSettings limitsSettings = this.getLimitsSettings();
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limitsSettings.getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled && folderDepth.length - 1 > (allowedFolderDepth = BoxesRunTime.unboxToInt((Object)limitsSettings.getProperty(Limits$.MODULE$.MAX_FOLDER_DEPTH())))) {
            throw new IllegalArgumentException("Creating Folder exceeds allowed sub-folder depth " + allowedFolderDepth);
        }
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        FolderAndEvents result = this.createWithoutPublishing(parentId, folder, createDefaultTeams);
        result.events().foreach((Function1 & Serializable)event -> {
            this.eventBus.publish(event);
            return BoxedUnit.UNIT;
        });
        return result.folder();
    }

    private void checkLimits(String folderId, String newParentId) {
        FeatureSettings limitsSettings = this.getLimitsSettings();
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)this.getLimitsSettings().getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled) {
            this.checkFolderDepth(folderId, newParentId, limitsSettings);
            return;
        }
    }

    private void checkFolderDepth(String folderId, String newParentId, FeatureSettings limitsSettings) {
        int newFolderIdSplitLength;
        int allowedFolderDepth = BoxesRunTime.unboxToInt((Object)limitsSettings.getProperty(Limits$.MODULE$.MAX_FOLDER_DEPTH()));
        int newParentIdFolderDepth = newParentId.split(this.SLASH_FOLDER()).length - 1;
        if (newParentIdFolderDepth > allowedFolderDepth) {
            throw new IllegalArgumentException("Moving folder/folders is not within the allowed sub-folder depth " + allowedFolderDepth);
        }
        String[] newFolderIdSplit = folderId.split(this.SLASH());
        String newFolderIdInDb = newFolderIdSplit[(newFolderIdSplitLength = newFolderIdSplit.length) - 1];
        int findChildrenOfNewFolder = this.folders.findNumberOfChildrenForAFolder(newFolderIdInDb);
        int newToBeFolderLength = newParentIdFolderDepth + findChildrenOfNewFolder;
        if (newToBeFolderLength > allowedFolderDepth) {
            throw new IllegalArgumentException("Moving folder/folders is not within the allowed sub-folder depth " + allowedFolderDepth);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FeatureSettings getLimitsSettings() {
        void var1_1;
        Optional<void> optional = this.configurationRepository.findFirstByType(Type.valueOf((String)Limits$.MODULE$.TYPE_LIMITS()));
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)Limits$.MODULE$.TYPE_LIMITS()).getDescriptor().newInstance("");
        feature.generateId();
        return (FeatureSettings)optional.orElse(var1_1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public FolderAndEvents createWithoutPublishing(String parentId, Folder folder, boolean createDefaultTeams) {
        Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
        this.checkFolderExists(parentId);
        this.folders.checkNameIsUnique(parentId, folder.getTitle());
        if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
            folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
        } else {
            folder.setId(parentId + "/" + Ids.getName((String)folder.getId()));
        }
        this.logger().info((Function0 & Serializable)() -> "Creating folder " + folder.getTitle() + " with id " + folder.getId());
        Folder saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
        .colon.colon events = new .colon.colon((Object)new FolderCreatedEvent(folder), (List)Nil$.MODULE$);
        if (createDefaultTeams) {
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                events = (scala.collection.immutable.Seq)events.$plus$plus(this.createDefaultTeamsForTheFolder(saved, parentId));
                return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
            }
        }
        events = (scala.collection.immutable.Seq)events.$colon$plus((Object)new TeamsUpdatedEvent(folder.getId()));
        return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeDeleted(folderId);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable)() -> "Deleting folder " + folderId);
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable)() -> "archiveOrDelete(" + folderUid + ", " + releaseId + "): status=" + status + " [inactive? " + status.isInactive() + "]");
        if (status.isInactive()) {
            Release release = this.releaseRepository.findById(releaseId);
            if (this.archivingService.shouldArchive(release)) {
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable)() -> "archiveRelease(" + releaseId + ")");
            this.archivingService.archiveRelease(releaseId);
            return;
        }
        this.logger().trace((Function0 & Serializable)() -> "deleteRelease(" + releaseId + ")");
        this.releaseRepository.delete(releaseId);
    }

    private void mergeTeams(String folderId, String templateId, scala.collection.immutable.Seq<Team> templateTeams) {
        if (templateTeams.nonEmpty()) {
            scala.collection.immutable.Seq folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(folderId)).asScala().toSeq();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable)() -> folderId);
            scala.collection.immutable.Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((scala.collection.immutable.Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, CollectionConverters$.MODULE$.SeqHasAsJava(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
            return;
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private scala.collection.immutable.Seq<Team> mergeTemplateAndFolderTeams(scala.collection.immutable.Seq<Team> folderTeams, scala.collection.immutable.Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)folderTeams.map((Function1 & Serializable)team -> new Tuple2((Object)team.getTeamName(), team))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq());
        templateTeams.foreach((Function1 & Serializable)templateTeam -> {
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                return folderTeamsMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getMembers()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getMembers()).asScala().toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getRoles()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getRoles()).asScala().toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getPermissions()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getPermissions()).asScala().toSet());
                folderTeam.setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)memberSet.toSeq()).asJava());
                folderTeam.setRoles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roleSet.toSeq()).asJava());
                folderTeam.setPermissions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)permissionSet.toSeq()).asJava());
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        if (!template.isWorkflow()) {
            template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
            return;
        }
    }

    private List<XLReleaseEvent> createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getFolderPermissions()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getAppPipelinesPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_APP_PIPELINES.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getReleasePermissions()).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getTriggerPermissions()).asScala())).concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getWorkflowExecutionPermissions()).asScala())).concat((IterableOnce)new .colon.colon((Object)XLReleasePermissions.VIEW_FOLDER.getPermissionName(), (List)new .colon.colon((Object)XLReleasePermissions.VIEW_APP_PIPELINES.getPermissionName(), (List)Nil$.MODULE$)));
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        Tuple2<java.util.List<Team>, java.util.List<XLReleaseEvent>> result = this.teamService.saveTeamsToPlatformWithoutPublishing(folder.getId(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)folderOwner, (List)new .colon.colon((Object)templateOwner, (List)new .colon.colon((Object)releaseAdmin, (List)Nil$.MODULE$)))).asJava(), true);
        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result._2()).asScala().toList();
    }

    private void checkFolderCanBeMoved(String folderId, String newfolderIdOption) {
        ArrayList validationMessages = new ArrayList();
        this.folderOperationValidators.foreach((Function1 & Serializable)validator -> {
            validator.validateMoveOperation(folderId, newfolderIdOption, validationMessages);
            return BoxedUnit.UNIT;
        });
        if (CollectionConverters$.MODULE$.ListHasAsScala(validationMessages).asScala().nonEmpty()) {
            String details = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(validationMessages).asScala().map((Function1 & Serializable)x$2 -> x$2.getMessage())).mkString(", ");
            throw new ItemInUseException("You cannot move this folder. The folder or its subfolders contain " + details + ".", new Object[0]);
        }
    }

    private void checkFolderCanBeDeleted(String folderId) {
        ArrayList validationMessages = new ArrayList();
        this.folderOperationValidators.foreach((Function1 & Serializable)validator -> {
            validator.validateDeleteOperation(folderId, validationMessages);
            return BoxedUnit.UNIT;
        });
        if (CollectionConverters$.MODULE$.ListHasAsScala(validationMessages).asScala().nonEmpty()) {
            String details = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(validationMessages).asScala().map((Function1 & Serializable)x$3 -> x$3.getMessage())).mkString(", ");
            throw new ItemInUseException("You cannot delete this folder. The folder or its subfolders contain " + details + ".", new Object[0]);
        }
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).forall((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private final void FolderAndEvents$lzycompute$1() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (this.FolderAndEvents$module == null) {
                this.FolderAndEvents$module = new FolderService$FolderAndEvents$(this);
            }
        }
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$9, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$9.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService, scala.collection.immutable.Seq<FolderOperationValidator> folderOperationValidators) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.folderOperationValidators = folderOperationValidators;
        Logging.$init$((Logging)this);
        this.SLASH = "/";
        this.SLASH_FOLDER = "/Folder";
    }

    public class FolderAndEvents
    implements Product,
    Serializable {
        private final Folder folder;
        private final scala.collection.immutable.Seq<XLReleaseEvent> events;
        public final /* synthetic */ FolderService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Folder folder() {
            return this.folder;
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> events() {
            return this.events;
        }

        public FolderAndEvents copy(Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            return new FolderAndEvents(this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer(), folder, events);
        }

        public Folder copy$default$1() {
            return this.folder();
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FolderAndEvents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.folder();
                }
                case 1: {
                    return this.events();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FolderAndEvents;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "folder";
                }
                case 1: {
                    return "events";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FolderAndEvents)) return false;
            if (((FolderAndEvents)object).com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() != this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FolderAndEvents folderAndEvents = (FolderAndEvents)x$1;
            Folder folder = this.folder();
            Folder folder2 = folderAndEvents.folder();
            if (folder == null) {
                if (folder2 != null) {
                    return false;
                }
            } else if (!folder.equals(folder2)) return false;
            scala.collection.immutable.Seq<XLReleaseEvent> seq = this.events();
            scala.collection.immutable.Seq<XLReleaseEvent> seq2 = folderAndEvents.events();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!folderAndEvents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FolderService com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() {
            return this.$outer;
        }

        public FolderAndEvents(FolderService $outer, Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            this.folder = folder;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

