/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.LinkBuilder;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.LinkCreatedEvent;
import com.xebialabs.xlrelease.domain.events.LinkDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.LinkRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks;
import com.xebialabs.xlrelease.service.TaskService;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class LinkService {
    private static final Logger logger = LoggerFactory.getLogger(LinkService.class);
    private CiIdService ciIdService;
    private TaskService taskService;
    private XLReleaseEventBus eventBus;
    private LinkRepository linkRepository;

    @Autowired
    public LinkService(CiIdService ciIdService, TaskService taskService, XLReleaseEventBus eventBus, LinkRepository linkRepository) {
        this.ciIdService = ciIdService;
        this.taskService = taskService;
        this.eventBus = eventBus;
        this.linkRepository = linkRepository;
    }

    @Timed
    public Link create(String containerId, String sourceId, String targetId) {
        Task container = this.taskService.getTaskWithoutDecoration(containerId);
        Task source = this.taskService.getTaskWithoutDecoration(sourceId);
        Task target = this.taskService.getTaskWithoutDecoration(targetId);
        Link link = LinkBuilder.newLink().withId(this.ciIdService.getUniqueId(Type.valueOf(Link.class), containerId)).withSource(source).withTarget(target).build();
        Preconditions.checkArgument((boolean)(container instanceof ParallelGroup), (Object)"You can't add a link to a container that's not a parallel group.");
        Preconditions.checkState((!container.hasBeenStarted() ? 1 : 0) != 0, (Object)"You can't add a link to a container that has already been started.");
        Preconditions.checkState((boolean)this.uniqueLinkWithinContainer(container, link), (Object)"You can't add the same link twice within a parallel group.");
        Preconditions.checkArgument((boolean)source.getContainer().equals(container), (Object)"You can't add a link whose source isn't a direct child of the container.");
        Preconditions.checkArgument((boolean)target.getContainer().equals(container), (Object)"You can't add a link whose target isn't a direct child of the container.");
        ParallelGroup parallelGroup = (ParallelGroup)container;
        LockedTaskOperationChecks.checkCreateTaskLink(parallelGroup);
        parallelGroup.getLinks().add(link);
        link.setParallelGroup(parallelGroup);
        this.linkRepository.create(link);
        this.eventBus.publish((XLReleaseEvent)new LinkCreatedEvent(link));
        return link;
    }

    @Timed
    public void delete(String linkId) {
        try {
            boolean isTargetNeedUpdate;
            Link link = this.linkRepository.findById(linkId);
            ParallelGroup parallelGroup = link.getParallelGroup();
            Preconditions.checkState((!parallelGroup.hasBeenStarted() ? 1 : 0) != 0, (Object)"Can't remove a link from a container that has already been started");
            LockedTaskOperationChecks.checkRemoveTaskLink(parallelGroup);
            Task target = link.getTarget();
            ArrayList<Object> events = new ArrayList<Object>();
            events.add(new LinkDeletedEvent(link));
            boolean bl = isTargetNeedUpdate = !target.isWaitForScheduledStartDate();
            if (isTargetNeedUpdate) {
                Task original = CiCloneHelper.cloneCi(target);
                target.setWaitForScheduledStartDate(true);
                events.add(new TaskUpdatedEvent(original, target));
            }
            Set links = link.getParallelGroup().getLinks();
            Set newLinks = links.stream().filter(l -> !l.getId().equals(link.getId())).collect(Collectors.toSet());
            link.getParallelGroup().setLinks(newLinks);
            this.linkRepository.delete(link);
            events.forEach(this.eventBus::publish);
        }
        catch (NotFoundException e) {
            logger.debug(String.format("Link with id %s not found in repository, skipping delete", linkId));
        }
    }

    private boolean uniqueLinkWithinContainer(Task container, Link newLink) {
        Set links = ((ParallelGroup)container).getLinks();
        for (Link link : links) {
            if (!Objects.equals(newLink.getSource(), link.getSource()) || !Objects.equals(newLink.getTarget(), link.getTarget())) continue;
            return false;
        }
        return true;
    }
}

