package com.xebialabs.xlrelease.api.v1.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.api.v1.CacheManagementApi;
import com.xebialabs.xlrelease.api.v1.views.CacheGroupView;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CacheManagementService;

import io.micrometer.core.annotation.Timed;


@Controller
public class CacheManagementApiImpl implements CacheManagementApi {

    private final CacheManagementService cacheManagementService;

    private final PermissionChecker permissions;

    @Autowired
    public CacheManagementApiImpl(final CacheManagementService cacheManagementService, final PermissionChecker permissions) {
        this.cacheManagementService = cacheManagementService;
        this.permissions = permissions;
    }

    @Timed
    @Override
    public List<CacheGroupView> listCacheGroups() {
        checkAdmin();
        return cacheManagementService.listCacheGroups()
                .stream().map(CacheGroupView::new).toList();
    }

    @Timed
    @Override
    public void clearAllCacheGroups() {
        checkAdmin();
        cacheManagementService.clearAllCacheGroups(true);
    }

    @Timed
    @Override
    public void clearCacheGroup(String cacheGroup) {
        checkAdmin();
        cacheManagementService.clearCacheGroup(cacheGroup, true);
    }

    private void checkAdmin() {
        if (!permissions.isCurrentUserAdmin()) {
            throw new PermissionDeniedException("Only admin users can perform this operation");
        }
    }
}
