package com.xebialabs.xlrelease.repository.sql.persistence

// scalastyle:off number.of.methods
object Schema {

  val COLUMN_LENGTH_TITLE: Int = 1024
  val COLUMN_LENGTH_AUTHORITY_NAME: Int = 256
  val COLUMN_LENGTH_SHORT_VARCHAR: Int = 256

  val TEMP_ORIGIN_TEMPLATE_ID = "TEMPLATE_ID"
  val TEMP_ORIGIN_TEMPLATE_TITLE = "TEMPLATE_TITLE"

  object SECURABLES extends Table("XLR_SECURABLES") {
    val CI_UID = "CI_UID"
  }

  object METADATA extends Table("XL_METADATA") {
    val NAME = "NAME"
    val ENTRY = "ENTRY"
    val CONTENT = "CONTENT"
  }

  object FOLDERS extends Table("XLR_FOLDERS") {
    val CI_UID: String = "CI_UID"
    val SECURITY_UID: String = "SECURITY_UID"
    val FOLDER_ID: String = "FOLDER_ID"
    val FOLDER_PATH: String = "FOLDER_PATH"
    val NAME: String = "NAME"
    val TOKEN = "TOKEN"
  }

  object PATHS extends Table("XLR_FOLDER_PATHS") {
    val ANCESTOR_UID: String = "ANCESTOR_UID"
    val DESCENDANT_UID: String = "DESCENDANT_UID"
    val DEPTH: String = "DEPTH"
  }

  object VIEW extends Table("XLR_VIEW_FOLDER_DESCENDANTS") {
    val ANCESTOR_UID: String = PATHS.ANCESTOR_UID
    val DESCENDANT_UID: String = PATHS.DESCENDANT_UID
    val TOKEN: String = FOLDERS.TOKEN
    val SECURITY_UID: String = FOLDERS.SECURITY_UID
    val FOLDER_ID: String = FOLDERS.FOLDER_ID
    val FOLDER_PATH: String = FOLDERS.FOLDER_PATH
    val NAME: String = FOLDERS.NAME
    val DEPTH: String = PATHS.DEPTH
  }

  object RELEASES extends Table("XLR_RELEASES") {
    val RELEASE_ID: String = "RELEASE_ID"
    val FOLDER_CI_UID: String = "FOLDER_CI_UID"
    val RELEASE_OWNER: String = "RELEASE_OWNER"
    val CALENDAR_TOKEN: String = "CALENDAR_TOKEN"
    val STATUS: String = "STATUS"
    val START_DATE: String = "START_DATE"
    val END_DATE: String = "END_DATE"
    val CI_UID: String = "CI_UID"
    val RELEASE_TITLE: String = "RELEASE_TITLE"
    val RISK_SCORE: String = "RISK_SCORE"
    val AUTO_START: String = "IS_AUTO_START"
    val TOTAL_RISK_SCORE: String = "TOTAL_RISK_SCORE"
    val ROOT_RELEASE_ID: String = "ROOT_RELEASE_ID"
    val REAL_FLAG_STATUS: String = "REAL_FLAG_STATUS"
    val SECURITY_UID: String = "SECURITY_UID"
    val PRE_ARCHIVED: String = "PRE_ARCHIVED"
    val SCM_DATA: String = "SCM_DATA"
    val PLANNED_DURATION: String = "PLANNED_DURATION"
    val IS_OVERDUE_NOTIFIED: String = "IS_OVERDUE_NOTIFIED"
    val ORIGIN_TEMPLATE_ID: String = "ORIGIN_TEMPLATE_ID"
    val KIND: String = "KIND"
  }

  object RELEASES_DATA extends Table("XLR_RELEASES_DATA") {
    val CI_UID: String = RELEASES.CI_UID
    val CONTENT: String = "CONTENT"
  }

  object RELEASES_EXT extends Table("XLR_RELEASES_EXT") {
    val RELEASE_UID: String = "RELEASE_UID"
    val EXTENSION_ID: String = "EXTENSION_ID"
    val EXTENSION_TYPE: String = "EXTENSION_TYPE"
    val CONTENT: String = "CONTENT"
  }

  object TEMPLATE_METADATA extends Table("XLR_TEMPLATE_META") {
    val RELEASE_UID: String = "RELEASE_UID"
    val AUTHOR: String = "AUTHOR"
    val DESCRIPTION: String = "DESCRIPTION"
    val TARGET_FOLDER_CI_UID: String = "TARGET_FOLDER_CI_UID"
    val ALLOW_TARGET_FOLDER_OVERRIDE: String = "ALLOW_TARGET_FOLDER_OVERRIDE"
    val LOGO_DATA: String = "LOGO_DATA"
  }

  object TAGS extends Table("XLR_TAGS") {
    val CI_UID: String = "CI_UID"
    val VALUE: String = "TAG_VALUE"
  }

  object TASK_TAGS extends Table("XLR_TASK_TAGS") {
    val CI_UID: String = "CI_UID"
    val VALUE: String = "TAG_VALUE"
  }

  object ARTIFACTS extends Table("XLR_ARTIFACTS") {
    val ARTIFACTS_ID: String = "ARTIFACT_ID"
    val CI_UID: String = "CI_UID"
    val NAME: String = "ARTIFACT_NAME"
    val CONTENT: String = "CONTENT"
  }

  object DEPENDENCIES extends Table("XLR_DEPENDENCIES") {
    val DEPENDENCY_ID: String = "DEPENDENCY_ID"
    val GATE_TASK_UID: String = "GATE_TASK_UID"
    val GATE_STATUS: String = "GATE_STATUS"
    val TARGET_ID: String = "TARGET_ID"
    val TARGET_RELEASE_UID: String = "TARGET_RELEASE_UID"
    val TARGET_RELEASE_ID: String = "TARGET_RELEASE_ID"
  }

  object PHASES extends Table("XLR_PHASES") {
    val CI_UID: String = "CI_UID"
    val RELEASE_UID: String = "RELEASE_UID"
    val PHASE_ID: String = "PHASE_ID"
    val PHASE_TITLE: String = "PHASE_TITLE"
    val STATUS: String = "STATUS"
    val COLOR: String = "COLOR"
    val START_DATE: String = "START_DATE"
    val END_DATE: String = "END_DATE"
  }

  object TASKS extends Table("XLR_TASKS") {
    val CI_UID: String = "CI_UID"
    val RELEASE_UID: String = "RELEASE_UID"
    val TASK_ID: String = "TASK_ID"
    val TASK_ID_HASH: String = "TASK_ID_HASH"
    val PHASE_ID: String = "PHASE_ID"
    val TASK_TYPE: String = "TASK_TYPE"
    val TITLE: String = "TITLE"
    val STATUS: String = "STATUS"
    val STATUS_LINE: String = "STATUS_LINE"
    val OWNER: String = "OWNER"
    val TEAM: String = "TEAM"
    val START_DATE: String = "START_DATE"
    val END_DATE: String = "END_DATE"
    val IS_AUTOMATED: String = "IS_AUTOMATED"
    val LOCKED: String = "LOCKED"
    val PLANNED_DURATION: String = "PLANNED_DURATION"
    val IS_OVERDUE_NOTIFIED: String = "IS_OVERDUE_NOTIFIED"
    val IS_DUE_SOON_NOTIFIED: String = "IS_DUE_SOON_NOTIFIED"
  }

  object TASK_BACKUPS extends Table("XLR_TASK_BACKUPS") {
    val TASK_ID: String = "TASK_ID"
    val CI_UID: String = "CI_UID"
    val CONTENT: String = "CONTENT"
  }

  object COMMENTS extends Table("XLR_COMMENTS") {
    val TASK_UID: String = "TASK_UID"
    val COMMENT_ID: String = "COMMENT_ID"
    val AUTHOR: String = "AUTHOR"
    val CREATION_DATE: String = "CREATION_DATE"
    val MODIFIED_DATE: String = "MODIFIED_DATE"
    val CONTENT: String = "CONTENT"
  }

  object CONFIGURATIONS extends Table("XLR_CONFIGURATIONS") {
    val CI_UID = "CI_UID"
    val ID = "ID"
    val TITLE = "TITLE"
    val CI_TYPE = "CI_TYPE"
    val FOLDER_CI_UID = "FOLDER_CI_UID"
    val CONTENT = "CONTENT"
  }

  object LICENSE extends Table("XLR_LICENSE") {
    val ID = "ID"
    val CONTENT = "CONTENT"
  }

  abstract class ReferenceMapTable(table: String) extends Table(table) {
    val sourceColumn: String
    val targetColumn: String
  }

  abstract class ConfigurationRefs(TABLE: String) extends ReferenceMapTable(TABLE) {
    val CONFIGURATION_UID = "CONFIGURATION_UID"
    override val targetColumn = CONFIGURATION_UID
    val USED_BY_UID: String
  }

  object RELEASE_CONFIGURATION_REFS extends ConfigurationRefs("XLR_RELEASE_CONFIGURATION_REFS") {
    override val USED_BY_UID = "USED_BY_RELEASE_UID"
    override val sourceColumn = USED_BY_UID
  }

  object TRIGGER_CONFIGURATION_REFS extends ConfigurationRefs("XLR_TRIGGER_CONFIGURATION_REFS") {
    override val USED_BY_UID = "USED_BY_TRIGGER_UID"
    override val sourceColumn = USED_BY_UID
  }

  object USER_PROFILE extends Table("XLR_USER_PROFILES") {
    val CI_UID: String = "CI_UID"
    val USERNAME: String = "USERNAME"
    val EMAIL: String = "EMAIL"
    val FULL_NAME: String = "FULL_NAME"
    val ENABLED: String = "ENABLED"
    val CONTENT: String = "CONTENT"
    val LAST_ACTIVE: String = "LAST_ACTIVE"
  }

  object CALENDAR_ENTRIES extends Table("XLR_CALENDAR_ENTRIES") {
    val CI_UID = "CI_UID"
    val ENTRY_ID = "ENTRY_ID"
    val LABEL = "LABEL"
    val START_DATE = "START_DATE"
    val END_DATE = "END_DATE"
    val CI_TYPE = "CI_TYPE"
    val CONTENT = "CONTENT"
  }

  object TRIGGERS extends Table("XLR_TRIGGERS") {
    val CI_UID = "CI_UID"
    val ID = "ID"
    val FOLDER_UID = "FOLDER_UID"
    val ENABLED = "ENABLED"
    val TRIGGER_TITLE = "TRIGGER_TITLE"
    val CI_TYPE = "CI_TYPE"
    val DESCRIPTION = "DESCRIPTION"
    val CONTENT = "CONTENT"
    val LAST_RUN_DATE = "LAST_RUN_DATE"
    val LAST_RUN_STATUS = "LAST_RUN_STATUS"
  }

  object TEMPLATE_TRIGGERS extends Table("XLR_TEMPLATE_TRIGGERS") {
    val RELEASE_UID = "RELEASE_UID"
    val TRIGGER_UID = "TRIGGER_UID"
  }

  object TRIGGERED_RELEASES extends Table("XLR_TRIGGERED_RELEASES") {
    val TEMPLATE_UID = "TEMPLATE_UID"
    val TRIGGER_UID = "TRIGGER_UID"
    val RELEASE_UID = "RELEASE_UID"
  }

  object PERSISTENT_LOGIN_TOKENS extends Table("XLR_PERSISTENT_LOGIN_TOKENS") {
    val SERIES = "SERIES"
    val USERNAME = "USERNAME"
    val LAST_USED = "LAST_USED"
    val TOKEN = "TOKEN"
  }

  object FACETS extends Table("XLR_FACETS") {
    val CI_UID = "CI_UID"
    val FACET_ID = "FACET_ID"
    val CI_TYPE = "CI_TYPE"
    val APPLIED_TO_TASK_UID = "APPLIED_TO_TASK_UID"
    val CONTENT = "CONTENT"
    val RETRY_ATTEMPT_NUMBER = "RETRY_ATTEMPT_NUMBER"
    val CREATED_VIA_API = "CREATED_VIA_API"
  }

  object FOLDER_VARIABLES extends Table("XLR_FOLDER_VARIABLES") {
    val CI_UID = "CI_UID"
    val ID = "ID"
    val CI_TYPE = "CI_TYPE"
    val KEY = "VARIABLE_KEY"
    val CONTENT = "CONTENT"
    val FOLDER_CI_UID = "FOLDER_CI_UID"
  }

  object SCM_DATA extends Table("XLR_SCM_DATA") {
    val SCM_DATA_ID = "SCM_DATA_ID"
    val SCM_TYPE = "SCM_TYPE"
    val SCM_KIND = "SCM_KIND"
    val SCM_COMMIT = "SCM_COMMIT"
    val SCM_AUTHOR = "SCM_AUTHOR"
    val SCM_DATE = "SCM_DATE"
    val SCM_MESSAGE = "SCM_MESSAGE"
    val SCM_REMOTE = "SCM_REMOTE"
    val SCM_FILENAME = "SCM_FILENAME"
  }

  object SPRING_SESSION extends Table("SPRING_SESSION") {
    val PRIMARY_ID = "PRIMARY_ID"
    val SESSION_ID = "SESSION_ID"
    val CREATION_TIME = "CREATION_TIME"
    val LAST_ACCESS_TIME = "LAST_ACCESS_TIME"
    val MAX_INACTIVE_INTERVAL = "MAX_INACTIVE_INTERVAL"
    val EXPIRY_TIME = "EXPIRY_TIME"
    val PRINCIPAL_NAME = "PRINCIPAL_NAME"
  }

  object TASK_JOBS extends Table("XLR_TASK_JOBS") {
    val ID = "JOB_ID"
    val TASK_ID = "TASK_ID"
    val TASK_ID_HASH = "TASK_ID_HASH"
    val RELEASE_UID = "RELEASE_UID"
    val JOB_TYPE = "JOB_TYPE"
    val STATUS = "STATUS"
    val VERSION = "VERSION"
    val SUBMIT_TIME = "SUBMIT_TIME"
    val SCHEDULED_START_TIME = "SCHEDULED_START_TIME"
    val RESERVATION_TIME = "RESERVATION_TIME"
    val EXECUTION_ID = "EXECUTION_ID"
    val START_TIME = "START_TIME"
    val NODE = "NODE"
    val RUNNER_ID = "RUNNER_ID"
  }

  object TASK_EXECUTIONS extends Table("XLR_TASK_EXECUTIONS") {
    val TASK_ID_HASH = "TASK_ID_HASH"
    val EXECUTION_ID = "EXECUTION_ID"
    val LAST_JOB = "LAST_JOB"
    val LAST_CHUNK = "LAST_CHUNK"
    val LAST_MODIFIED_DATE = "LAST_MODIFIED_DATE"
    val END_DATE = "END_DATE"
  }

  object PERMISSION_SNAPSHOTS extends Table("XLR_PERMISSION_SNAPSHOTS") {
    val CONTAINER_ID: String = "CONTAINER_ID"
    val SNAPSHOT_DATE: String = "SNAPSHOT_DATE"
    val CONTENT: String = "CONTENT"
  }

  object USER_TOKENS extends Table("XLR_USER_TOKENS") {
    val CI_UID: String = "CI_UID"
    val USERNAME: String = "USERNAME"
    val TOKEN_NOTE: String = "TOKEN_NOTE"
    val TOKEN_HASH: String = "TOKEN_HASH"
    val CREATED_DATE: String = "CREATED_DATE"
    val LAST_USED_DATE: String = "LAST_USED_DATE"
    val EXPIRY_DATE: String = "EXPIRY_DATE"
    val IS_TOKEN_EXPIRE_NOTIFIED: String = "IS_TOKEN_EXPIRE_NOTIFIED"
    val TOKEN_PERMISSIONS: String = "TOKEN_PERMISSIONS"
  }

  object RUNNER_TOKENS extends Table("XLR_RUNNER_TOKENS") {
    val RUNNER_ID: String = "RUNNER_ID"
    val TOKEN_HASH: String = "TOKEN_HASH"
    val CREATED_DATE: String = "CREATED_DATE"
    val UPDATED_DATE: String = "UPDATED_DATE"
    val EXPIRY_DATE: String = "EXPIRY_DATE"
  }

  object CATEGORIES extends Table("XLR_CATEGORIES") {
    val CI_UID: String = "CI_UID"
    val CATEGORY: String = "CATEGORY"
    val ACTIVE: String = "ACTIVE"
  }

  object RELEASE_CATEGORY_REFS extends ReferenceMapTable("XLR_RELEASE_CATEGORY_REFS") {
    override val sourceColumn = "USED_BY_RELEASE_UID"
    override val targetColumn = "CATEGORY_UID"
  }

  trait TaskRecordTable {
    self: Table =>
    val RECORD_ID: String = "RECORD_ID"
    val RECORD_TYPE: String = "RECORD_TYPE"
    val TASK_UID: String = "TASK_UID"
    val CREATION_DATE: String = "CREATION_DATE"
    val SERVER_URL: String = "SERVER_URL"
    val SERVER_USER: String = "SERVER_USER"
    val RETRY_ATTEMPT_NUMBER: String = "RETRY_ATTEMPT_NUMBER"
    val CREATED_VIA_API: String = "CREATED_VIA_API"
  }

  class ItsmTaskReportingRecordTable(tableName: String) extends Table(tableName) with TaskRecordTable {
    val RECORD: String = "RECORD"
    val RECORD_URL: String = "RECORD_URL"
    val TITLE: String = "TITLE"
    val STATUS: String = "STATUS"
    val PRIORITY: String = "PRIORITY"
    val CREATED_BY: String = "CREATED_BY"
  }

  class DeploymentTaskReportingRecordTable(tableName: String) extends Table(tableName)
    with TaskRecordTable {
    val DEPLOYMENT_TASK: String = "DEPLOYMENT_TASK"
    val DEPLOYMENT_TASK_URL: String = "DEPLOYMENT_TASK_URL"
    val ENVIRONMENT_NAME: String = "ENVIRONMENT_NAME"
    val APPLICATION_NAME: String = "APPLICATION_NAME"
    val VERSION: String = "VERSION"
    val STATUS: String = "STATUS"
  }

  class CodeComplianceTaskReportingRecordTable(tableName: String) extends Table(tableName)
    with TaskRecordTable {
    val PROJECT: String = "PROJECT"
    val PROJECT_URL: String = "PROJECT_URL"
    val ANALYSIS_DATE: String = "ANALYSIS_DATE"
    val OUTCOME: String = "OUTCOME"
    val COMPLIANCE_DATA: String = "COMPLIANCE_DATA"
  }

  case object ITSM_TASK_REPORTING_RECORD extends ItsmTaskReportingRecordTable("XLR_TASK_RECORD_ITSM")

  case object DEPLOYMENT_TASK_REPORTING_RECORD extends DeploymentTaskReportingRecordTable("XLR_TASK_RECORD_DPLMNT")

  case object CODE_COMPLIANCE_TASK_REPORTING_RECORD extends CodeComplianceTaskReportingRecordTable("XLR_TASK_RECORD_CODECOMPLIANCE")

  object Archive {

    case object ITSM_TASK_REPORTING_RECORD extends ItsmTaskReportingRecordTable("TASK_RECORD_ITSM")

    case object DEPLOYMENT_TASK_REPORTING_RECORD extends DeploymentTaskReportingRecordTable("TASK_RECORD_DEPLOYMENT")

    case object CODE_COMPLIANCE_TASK_REPORTING_RECORD extends CodeComplianceTaskReportingRecordTable("TASK_RECORD_CODE_COMPLIANCE")

  }

}
