package com.xebialabs.xlrelease.security

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlrelease.domain.Task

trait PermissionContext {

  def check(permission: Permission, releaseId: String): Unit

  def checkView(releaseId: String): Unit

  def checkEdit(releaseId: String): Unit

  def checkAbort(releaseId: String): Unit

  def checkEditTask(releaseId: String): Unit

  def checkEditAttachment(ciId: String): Unit

  def checkLockTaskPermission(releaseId: String): Unit

  def checkEditPreconditionPermission(releaseId: String): Unit

  def checkEditFailureHandlerPermission(releaseId: String): Unit

  def checkEditTaskConfigurationFacet(releaseId: String): Unit

  def checkEditBlackoutPermission(releaseId: String): Unit

  def checkReassignTaskPermission(releaseId: String): Unit

  def checkReassignTaskToUser(taskId: String, newUser: String): Unit

  def checkEditDate(ciId: String): Unit

  def checkIsAllowedToCommentOnTask(taskId: String): Unit

  def checkIsAllowedToEditAttachmentsOnTask(taskId: String): Unit

  // def checkIsAllowedToStartTask(taskId: String): Unit // needs too much data

  def checkIsAllowedToWorkOnTask(taskId: String): Unit

  // TODO what is the difference between checkTaskTransitionPermission, checkAdvanceTaskTransitionPermission and checkRelevantTaskTransitionPermission?
  def checkTaskTransitionPermission(taskId: String): Unit

  def checkAdvanceTaskTransitionPermission(taskId: String): Unit

  def checkRelevantTaskTransitionPermission(taskId: String): Unit

  def hasGlobalPermission(permission: Permission): Boolean

  def canEditTask(releaseId: String): Boolean

  def canViewRelease(releaseId: String): Boolean

  def isAllowedToWorkOnTask(taskId: String): Boolean

  // semi-private (exposed for permission checker)
  private[security] def hasCiPermission(permission: Permission, containerId: String): Boolean

  private[security] def hasPermission(permission: Permission, ciId: String): Boolean

  // Please do not use methods that accept populated objects - those are here for compatibility reason
  def areUsersInTheSameTaskTeam(task: Task, newUser: String): Boolean

  def checkHasPermissionsToUpdateTask(task: Task): Unit

}

